/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;

public class CustomFileChooser
extends JFileChooser {
    public static final String FILE_CHOOSER_READ_ONLY_KEY = "FileChooser.readOnly";
    private final boolean previousReadOnlyFlag;
    private final PropertyChangeListener propertyChangeListener;
    private JTextComponent textField;

    public CustomFileChooser(boolean previousReadOnlyFlag) {
        this.previousReadOnlyFlag = previousReadOnlyFlag;
        this.propertyChangeListener = event -> {
            if ("directoryChanged".equalsIgnoreCase(event.getPropertyName())) {
                if (this.getFileSelectionMode() == 0) {
                    this.resetSelectedFile();
                }
            } else if (("SelectedFileChangedProperty".equalsIgnoreCase(event.getPropertyName()) || "SelectedFilesChangedProperty".equalsIgnoreCase(event.getPropertyName())) && this.getFileSelectionMode() == 0 && event.getNewValue() == null) {
                this.resetSelectedFile();
            }
        };
    }

    private static List<JComboBox<?>> findComboBoxes(Container root) {
        ArrayList comboBoxes = new ArrayList();
        Stack<Container> stack = new Stack<Container>();
        stack.push(root);
        while (!stack.isEmpty()) {
            Component[] components;
            Container container = (Container)stack.pop();
            for (Component component : components = container.getComponents()) {
                if (component instanceof JComboBox) {
                    comboBoxes.add((JComboBox)component);
                    continue;
                }
                if (!(component instanceof Container)) continue;
                stack.push((Container)component);
            }
        }
        return comboBoxes;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        int returnCode = super.showDialog(parent, approveButtonText);
        UIManager.getDefaults().put(FILE_CHOOSER_READ_ONLY_KEY, (Object)this.previousReadOnlyFlag);
        return returnCode;
    }

    public Path getSelectedPath() {
        File file = super.getSelectedFile();
        return Paths.get(file.toURI());
    }

    public void setCurrentDirectoryPath(Path directoryPath) {
        super.setCurrentDirectory(directoryPath.toFile());
    }

    public void setSelectedPath(Path path) {
        super.setSelectedFile(path.toFile());
    }

    private void resetSelectedFile() {
        this.removePropertyChangeListener(this.propertyChangeListener);
        try {
            this.setSelectedFile(null);
            this.setSelectedFiles(null);
            if (this.textField != null) {
                this.textField.setText("");
            }
        }
        finally {
            this.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private static JTextComponent findTextField(Container root) {
        Component[] components;
        for (Component component : components = root.getComponents()) {
            JTextComponent filePane;
            if (component instanceof JTextComponent) {
                return (JTextComponent)component;
            }
            if (!(component instanceof Container) || (filePane = CustomFileChooser.findTextField((Container)component)) == null) continue;
            return filePane;
        }
        return null;
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        dialog.setMinimumSize(new Dimension(450, 350));
        this.addPropertyChangeListener(this.propertyChangeListener);
        this.textField = CustomFileChooser.findTextField(this);
        List<JComboBox<?>> comboBoxes = CustomFileChooser.findComboBoxes(this);
        if (this.textField != null && comboBoxes.size() > 0) {
            Dimension preferredComboBoxSize;
            Dimension preferredTextFieldSize = this.textField.getPreferredSize();
            int maximumHeight = preferredTextFieldSize.height;
            for (JComboBox<?> box : comboBoxes) {
                preferredComboBoxSize = box.getPreferredSize();
                maximumHeight = Math.max(maximumHeight, preferredComboBoxSize.height);
            }
            preferredTextFieldSize.height = maximumHeight;
            this.textField.setPreferredSize(preferredTextFieldSize);
            for (JComboBox<?> comboBox : comboBoxes) {
                preferredComboBoxSize = comboBox.getPreferredSize();
                preferredComboBoxSize.height = maximumHeight;
                comboBox.setPreferredSize(preferredComboBoxSize);
            }
        }
        return dialog;
    }

    public static FileFilter buildFileFilter(String extension, String description) {
        return new CustomFileFilter(extension, description);
    }

    public static CustomFileChooser buildFileChooser(String dialogTitle, boolean multiSelectionEnabled, int fileSelectionMode) {
        return CustomFileChooser.buildFileChooser(dialogTitle, multiSelectionEnabled, fileSelectionMode, true);
    }

    public static CustomFileChooser buildFileChooser(String dialogTitle, boolean multiSelectionEnabled, int fileSelectionMode, boolean readOnly) {
        boolean previousReadOnlyFlag = UIManager.getDefaults().getBoolean(FILE_CHOOSER_READ_ONLY_KEY);
        UIManager.getDefaults().put(FILE_CHOOSER_READ_ONLY_KEY, (Object)readOnly);
        CustomFileChooser fileChooser = new CustomFileChooser(previousReadOnlyFlag);
        fileChooser.setDialogTitle(dialogTitle);
        fileChooser.setMultiSelectionEnabled(multiSelectionEnabled);
        fileChooser.setFileSelectionMode(fileSelectionMode);
        return fileChooser;
    }

    private static class CustomFileFilter
    extends FileFilter {
        private final String extension;
        private final String description;

        private CustomFileFilter(String extension, String description) {
            if (StringUtils.isBlank((CharSequence)extension)) {
                throw new NullPointerException("The extension is null or empty.");
            }
            if (StringUtils.isBlank((CharSequence)description)) {
                throw new NullPointerException("The description is null or empty.");
            }
            this.extension = extension;
            this.description = description;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return StringUtils.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)this.extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

