/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.esa.snap.ui.loading.ItemRenderer;
import org.esa.snap.ui.loading.LabelListCellRenderer;
import org.esa.snap.ui.loading.SwingUtils;

public class CustomComboBox<ItemType>
extends JComboBox<ItemType> {
    private final int preferredHeight;

    public CustomComboBox(ItemRenderer<ItemType> itemRenderer, int preferredHeight, boolean isEditable, Color backgroundColor) {
        this(itemRenderer, preferredHeight, isEditable);
        if (backgroundColor == null) {
            throw new NullPointerException("The background color is null.");
        }
        this.setBackground(backgroundColor);
    }

    public CustomComboBox(ItemRenderer<ItemType> itemRenderer, int preferredHeight, boolean isEditable) {
        if (preferredHeight <= 0) {
            throw new IllegalArgumentException("The preferred size " + preferredHeight + " must be > 0.");
        }
        this.preferredHeight = preferredHeight;
        this.setBorder(SwingUtils.LINE_BORDER);
        this.setMaximumRowCount(5);
        this.setEditable(true);
        ComboBoxEditorComponent<ItemType> comboBoxEditorComponent = new ComboBoxEditorComponent<ItemType>(itemRenderer);
        JTextField editorTextField = comboBoxEditorComponent.getEditorComponent();
        editorTextField.setBorder(SwingUtils.EDIT_TEXT_BORDER);
        editorTextField.setOpaque(false);
        if (!isEditable) {
            comboBoxEditorComponent.getEditorComponent().setEditable(false);
        }
        this.setEditor(comboBoxEditorComponent);
        editorTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (CustomComboBox.this.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (CustomComboBox.this.isPopupVisible()) {
                        CustomComboBox.this.hidePopup();
                    } else {
                        CustomComboBox.this.showPopup();
                    }
                }
            }
        });
        LabelListCellRenderer listCellRenderer = new LabelListCellRenderer<ItemType>(this.preferredHeight, itemRenderer){

            @Override
            public JLabel getListCellRendererComponent(JList<? extends ItemType> list, ItemType value, int index, boolean isSelected, boolean cellHasFocus) {
                Component label = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!isSelected) {
                    ((JComponent)label).setBackground(CustomComboBox.this.getBackground());
                }
                return label;
            }
        };
        listCellRenderer.setBorder(SwingUtils.EDIT_TEXT_BORDER);
        this.setRenderer(listCellRenderer);
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getEditor() != null && this.getEditor().getEditorComponent() != null) {
            this.getEditor().getEditorComponent().setEnabled(enabled);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, this.preferredHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.height = this.preferredHeight;
        return size;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = super.getMaximumSize();
        size.height = this.preferredHeight;
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = this.preferredHeight;
        return size;
    }

    private static class ComboBoxEditorComponent<ItemType>
    implements ComboBoxEditor {
        private final ItemRenderer<ItemType> itemRenderer;
        private final JTextField editorTextField;
        private ItemType item;

        private ComboBoxEditorComponent(ItemRenderer<ItemType> itemRenderer) {
            this.itemRenderer = itemRenderer;
            this.editorTextField = new JTextField("", 9);
            this.editorTextField.setBorder(null);
        }

        @Override
        public JTextField getEditorComponent() {
            return this.editorTextField;
        }

        @Override
        public void setItem(Object item) {
            this.item = item;
            String text = this.item == null ? "" : this.itemRenderer.getItemDisplayText(this.item);
            this.editorTextField.setText(text);
        }

        @Override
        public Object getItem() {
            String newValue = this.editorTextField.getText();
            if (this.item != null && !(this.item instanceof String) && newValue.equals(this.itemRenderer.getItemDisplayText(this.item))) {
                return this.item;
            }
            return newValue;
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void addActionListener(ActionListener listener) {
            this.editorTextField.addActionListener(listener);
        }

        @Override
        public void removeActionListener(ActionListener listener) {
            this.editorTextField.removeActionListener(listener);
        }
    }
}

