/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.esa.snap.ui.loading.CircularProgressPainter;

public class CircularProgressIndicatorLabel
extends JLabel {
    private final CircularProgressPainter circularProgressPainter = new CircularProgressPainter(Color.LIGHT_GRAY, this.getForeground());
    private Timer timer;
    private boolean isRunning = false;

    public CircularProgressIndicatorLabel() {
        this.setIcon(new PainterIcon(this.circularProgressPainter, this.circularProgressPainter.getPreferredSize()));
    }

    @Override
    public void removeNotify() {
        this.stopAnimation();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.startAnimation();
    }

    public void setRunning(boolean isRunning) {
        boolean timerDefined;
        boolean bl = timerDefined = this.timer != null;
        if (!timerDefined && isRunning) {
            this.isRunning = true;
            this.startAnimation();
        } else if (timerDefined && !isRunning) {
            this.isRunning = false;
            this.stopAnimation();
        }
    }

    private void startAnimation() {
        if (!this.isRunning || this.getParent() == null) {
            return;
        }
        this.stopAnimation();
        this.timer = new Timer(100, new ActionListener(){
            private int frame = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.frame = (this.frame + 1) % CircularProgressIndicatorLabel.this.circularProgressPainter.getPoints();
                CircularProgressIndicatorLabel.this.circularProgressPainter.setFrame(this.frame);
                CircularProgressIndicatorLabel.this.repaint();
            }
        });
        this.timer.start();
    }

    private void stopAnimation() {
        if (this.timer != null) {
            this.timer.stop();
            this.circularProgressPainter.setFrame(-1);
            this.repaint();
            this.timer = null;
        }
    }

    private static class PainterIcon
    implements Icon {
        private final Dimension size;
        private final CircularProgressPainter painter;

        public PainterIcon(CircularProgressPainter painter, Dimension size) {
            this.painter = painter;
            this.size = size;
        }

        @Override
        public int getIconHeight() {
            return this.size.height;
        }

        @Override
        public int getIconWidth() {
            return this.size.width;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            if (this.painter != null && graphics instanceof Graphics2D) {
                graphics = graphics.create();
                graphics.translate(x, y);
                this.painter.doPaint((Graphics2D)graphics, this.getIconWidth(), this.getIconHeight());
                graphics.translate(-x, -y);
                graphics.dispose();
            }
        }
    }
}

