/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.esa.snap.ui.loading.GenericRunnable;
import org.esa.snap.ui.loading.LoadingIndicator;

public abstract class AbstractTimerRunnable<OutputType>
implements Runnable {
    private static final Logger logger = Logger.getLogger(AbstractTimerRunnable.class.getName());
    private final Timer timer;
    private final int timerDelayInMilliseconds;
    private final int threadId;
    private final LoadingIndicator loadingIndicator;

    protected AbstractTimerRunnable(LoadingIndicator loadingIndicator, int threadId, int timerDelayInMilliseconds) {
        this.loadingIndicator = loadingIndicator;
        this.threadId = threadId;
        this.timerDelayInMilliseconds = timerDelayInMilliseconds;
        this.timer = this.timerDelayInMilliseconds > 0 ? new Timer() : null;
    }

    protected abstract OutputType execute() throws Exception;

    protected abstract String getExceptionLoggingMessage();

    @Override
    public final void run() {
        try {
            OutputType result = this.execute();
            GenericRunnable runnable = new GenericRunnable<OutputType>(result){

                @Override
                protected void execute(OutputType item) {
                    if (AbstractTimerRunnable.this.loadingIndicator.onHide(AbstractTimerRunnable.this.threadId)) {
                        AbstractTimerRunnable.this.onSuccessfullyFinish(item);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, this.getExceptionLoggingMessage(), exception);
            GenericRunnable<Exception> runnable = new GenericRunnable<Exception>(exception){

                @Override
                protected void execute(Exception threadException) {
                    if (AbstractTimerRunnable.this.loadingIndicator.onHide(AbstractTimerRunnable.this.threadId)) {
                        AbstractTimerRunnable.this.onFailed(threadException);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        finally {
            this.stopTimer();
        }
    }

    protected void onFailed(Exception exception) {
    }

    protected void onSuccessfullyFinish(OutputType result) {
    }

    public final void executeAsync() {
        this.startTimerIfDefined();
        Thread thread = new Thread(this);
        thread.start();
    }

    private void startTimerIfDefined() {
        if (this.timerDelayInMilliseconds > 0) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (AbstractTimerRunnable.this.isRunning()) {
                        AbstractTimerRunnable.this.timerWakeUp();
                    }
                }
            };
            this.timer.schedule(timerTask, this.timerDelayInMilliseconds);
        }
    }

    protected void onTimerWakeUp(String messageToDisplay) {
        this.onDisplayLoadingIndicatorMessage(messageToDisplay);
    }

    protected final boolean onDisplayLoadingIndicatorMessage(String messageToDisplay) {
        return this.loadingIndicator.onDisplay(this.threadId, messageToDisplay);
    }

    protected final boolean isRunning() {
        return this.loadingIndicator.isRunning(this.threadId);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void timerWakeUp() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractTimerRunnable.this.onTimerWakeUp(null);
            }
        });
    }
}

