/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.loading;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.loading.ComponentsEnabled;
import org.esa.snap.ui.loading.LoadingIndicator;
import org.esa.snap.ui.loading.LoadingIndicatorPanel;
import org.esa.snap.ui.loading.MessageDialog;

public abstract class AbstractModalDialog
extends AbstractDialog
implements MessageDialog {
    private LoadingIndicatorPanel loadingIndicatorPanel;
    private List<JComponent> componentsAllwaysEnabled;

    protected AbstractModalDialog(Window parent, String title, boolean isModal, String helpID) {
        super(new JDialogExtended(parent, Dialog.ModalityType.MODELESS), 0, null, helpID);
        JDialogExtended dialog = (JDialogExtended)this.getJDialog();
        dialog.setTitle(title);
        dialog.setModal(isModal);
        dialog.setLayoutRunnable(new Runnable(){

            @Override
            public void run() {
                AbstractModalDialog.this.centerLoadingIndicatorPanel();
            }
        });
    }

    protected abstract JPanel buildContentPanel(int var1, int var2);

    protected abstract JPanel buildButtonsPanel(ActionListener var1);

    @Override
    public void close() {
        this.getJDialog().dispose();
    }

    @Override
    public final int show() {
        JDialog dialog = this.getJDialog();
        if (!dialog.isShowing()) {
            this.componentsAllwaysEnabled = new ArrayList<JComponent>();
            ActionListener cancelActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AbstractModalDialog.this.close();
                }
            };
            this.registerEscapeKey(cancelActionListener);
            ComponentsEnabled componentsEnabled = new ComponentsEnabled(){

                @Override
                public void setComponentsEnabled(boolean enabled) {
                    AbstractModalDialog.this.setEnabledComponentsWhileLoading(enabled);
                }
            };
            this.loadingIndicatorPanel = new LoadingIndicatorPanel(componentsEnabled);
            dialog.getLayeredPane().add((Component)this.loadingIndicatorPanel, JLayeredPane.MODAL_LAYER);
            int gapBetweenColumns = this.getDefaultGapBetweenColumns();
            int gapBetweenRows = this.getDefaultGapBetweenRows();
            JPanel contentPanel = this.buildContentPanel(gapBetweenColumns, gapBetweenRows);
            JPanel buttonsPanel = this.buildButtonsPanel(cancelActionListener);
            JPanel dialogContentPanel = new JPanel(new BorderLayout(0, this.getDefaultGapBetweenContentAndButtonPanels()));
            dialogContentPanel.add((Component)contentPanel, "Center");
            dialogContentPanel.add((Component)buttonsPanel, "South");
            Border dialogBorder = this.buildDialogBorder(this.getDefaultContentPanelMargins());
            dialogContentPanel.setBorder(dialogBorder);
            dialog.setContentPane(dialogContentPanel);
            dialog.setResizable(true);
            dialog.setDefaultCloseOperation(0);
            dialog.setUndecorated(false);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent aEvent) {
                    AbstractModalDialog.this.close();
                }
            });
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getParent());
            this.onAboutToShow();
            dialog.setVisible(true);
        }
        return 0;
    }

    protected int getDefaultGapBetweenContentAndButtonPanels() {
        return 7;
    }

    protected int getDefaultContentPanelMargins() {
        return 7;
    }

    protected int getDefaultGapBetweenRows() {
        return 5;
    }

    protected int getDefaultGapBetweenColumns() {
        return 5;
    }

    protected final Insets buildDefaultTextFieldMargins() {
        return new Insets(3, 2, 3, 2);
    }

    protected final Insets buildDefaultListItemMargins() {
        return new Insets(3, 2, 3, 2);
    }

    protected final void addComponentToAllwaysEnabledList(JComponent component) {
        this.componentsAllwaysEnabled.add(component);
    }

    protected final JPanel buildButtonsPanel(String finishButtonText, ActionListener finishActionListener, String cancelButtonText, ActionListener cancelActionListener) {
        JButton finishButton = this.buildDialogButton(finishButtonText);
        finishButton.addActionListener(finishActionListener);
        JButton cancelButton = this.buildDialogButton(cancelButtonText);
        cancelButton.addActionListener(cancelActionListener);
        this.componentsAllwaysEnabled.add(cancelButton);
        JPanel buttonsGridPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        buttonsGridPanel.add(finishButton);
        buttonsGridPanel.add(cancelButton);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)buttonsGridPanel, "East");
        return buttonsPanel;
    }

    protected void setEnabledComponentsWhileLoading(boolean enabled) {
        JDialog dialog = this.getJDialog();
        JPanel dialogContentPanel = (JPanel)dialog.getContentPane();
        Stack<JComponent> stack = new Stack<JComponent>();
        stack.push(dialogContentPanel);
        while (!stack.isEmpty()) {
            JComponent component = (JComponent)stack.pop();
            component.setEnabled(enabled);
            int childrenCount = component.getComponentCount();
            for (int i = 0; i < childrenCount; ++i) {
                Component child = component.getComponent(i);
                if (!(child instanceof JComponent)) continue;
                JComponent childComponent = (JComponent)child;
                boolean found = false;
                for (int k = 0; k < this.componentsAllwaysEnabled.size(); ++k) {
                    if (childComponent != this.componentsAllwaysEnabled.get(k)) continue;
                    found = true;
                }
                if (found) continue;
                stack.push(childComponent);
            }
        }
    }

    protected final LoadingIndicator getLoadingIndicator() {
        return this.loadingIndicatorPanel;
    }

    protected final int getNewCurrentThreadId() {
        return this.loadingIndicatorPanel.getNewCurrentThreadId();
    }

    protected void onAboutToShow() {
    }

    protected Border buildDialogBorder(int margins) {
        return new EmptyBorder(margins, margins, margins, margins);
    }

    protected void registerEscapeKey(ActionListener cancelActionListener) {
        JRootPane rootPane = this.getJDialog().getRootPane();
        KeyStroke escapeKey = this.getEscapeKeyPressed();
        rootPane.registerKeyboardAction(cancelActionListener, escapeKey, 2);
    }

    private KeyStroke getEscapeKeyPressed() {
        int noModifiers = 0;
        return KeyStroke.getKeyStroke(27, noModifiers, false);
    }

    private void centerLoadingIndicatorPanel() {
        JDialog dialog = this.getJDialog();
        Rectangle layeredPaneBounds = dialog.getLayeredPane().getBounds();
        Dimension size = this.loadingIndicatorPanel.getPreferredSize();
        int x = layeredPaneBounds.width / 2 - size.width / 2;
        int y = layeredPaneBounds.height / 2 - size.height / 2;
        this.loadingIndicatorPanel.setBounds(x, y, size.width, size.height);
    }

    protected final JButton buildDialogButton(String buttonText) {
        JButton button = new JButton(buttonText);
        button.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                AbstractModalDialog.this.getJDialog().requestFocusInWindow();
            }
        });
        Dimension size = button.getPreferredSize();
        size.width = 75;
        button.setPreferredSize(size);
        return button;
    }

    protected static void computePanelFirstColumn(JPanel contentPanel) {
        Component subComponent;
        int k;
        int childPanelComponentCount;
        JPanel childPanel;
        Component component;
        int i;
        int rootPanelComponentCount = contentPanel.getComponentCount();
        int maximumLabelWidth = 0;
        for (i = 0; i < rootPanelComponentCount; ++i) {
            int labelWidth;
            component = contentPanel.getComponent(i);
            if (component instanceof JPanel) {
                childPanel = (JPanel)component;
                childPanelComponentCount = childPanel.getComponentCount();
                for (k = 0; k < childPanelComponentCount; ++k) {
                    int labelWidth2;
                    subComponent = childPanel.getComponent(k);
                    if (!(subComponent instanceof JLabel) || maximumLabelWidth >= (labelWidth2 = subComponent.getPreferredSize().width)) continue;
                    maximumLabelWidth = labelWidth2;
                }
                continue;
            }
            if (!(component instanceof JLabel) || maximumLabelWidth >= (labelWidth = component.getPreferredSize().width)) continue;
            maximumLabelWidth = labelWidth;
        }
        for (i = 0; i < rootPanelComponentCount; ++i) {
            component = contentPanel.getComponent(i);
            if (component instanceof JPanel) {
                childPanel = (JPanel)component;
                childPanelComponentCount = childPanel.getComponentCount();
                for (k = 0; k < childPanelComponentCount; ++k) {
                    subComponent = childPanel.getComponent(k);
                    if (!(subComponent instanceof JLabel)) continue;
                    AbstractModalDialog.setLabelSize((JLabel)subComponent, maximumLabelWidth);
                }
                continue;
            }
            if (!(component instanceof JLabel)) continue;
            AbstractModalDialog.setLabelSize((JLabel)component, maximumLabelWidth);
        }
    }

    private static void setLabelSize(JLabel label, int maximumLabelWidth) {
        Dimension labelSize = label.getPreferredSize();
        labelSize.width = maximumLabelWidth;
        label.setPreferredSize(labelSize);
        label.setMinimumSize(labelSize);
    }

    private static class JDialogExtended
    extends JDialog {
        private Runnable layoutRunnable;

        private JDialogExtended(Window owner, Dialog.ModalityType modalityType) {
            super(owner, modalityType);
        }

        @Override
        protected final JRootPane createRootPane() {
            JRootPane rp = new JRootPane(){

                @Override
                public void doLayout() {
                    super.doLayout();
                    layoutRunnable.run();
                }
            };
            rp.setOpaque(true);
            return rp;
        }

        public final void setLayoutRunnable(Runnable layoutRunnable) {
            this.layoutRunnable = layoutRunnable;
        }
    }
}

