/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.help;

import eu.esa.snap.netbeans.javahelp.api.Help;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class HelpDisplayer {
    private static final String DEFAULT_ONLINE_HELP_URL = "https://step.esa.int/main/doc/online-help";
    private static final String VERSION_JSON_URL = "../../wp-content/help/versions/";
    private static final String VERSION_JSON_FILE = "/version.json";

    public static void show(String helpId) {
        HelpDisplayer.show(helpId != null ? new HelpCtx(helpId) : null);
    }

    public static void show(HelpCtx helpCtx) {
        String serverURL = Config.instance().preferences().get("snap.online.help.url", DEFAULT_ONLINE_HELP_URL);
        String version = SystemUtils.getReleaseVersion();
        String fullURL = serverURL + "?helpid=" + helpCtx.getHelpID() + "&version=" + version;
        String versionURL = serverURL + VERSION_JSON_URL + version + VERSION_JSON_FILE;
        if (HelpDisplayer.checkServer(versionURL) && HelpDisplayer.browse(fullURL)) {
            return;
        }
        Help helpImpl = (Help)Lookup.getDefault().lookup(Help.class);
        if (helpImpl == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        helpImpl.showHelp(helpCtx);
    }

    private static boolean browse(String uriString) {
        URI uri;
        Desktop desktop = Desktop.getDesktop();
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        try {
            desktop.browse(uri);
        }
        catch (IOException e) {
            return false;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkServer(String serverURL) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(serverURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setConnectTimeout(1000);
            int responseCode = connection.getResponseCode();
            if (responseCode >= 400) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return true;
    }
}

