/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.diagram;

import java.io.Serializable;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.ui.diagram.Diagram;

public class DiagramAxis
implements Serializable {
    private static final double[] _tickFactors = new double[]{1.0, 1.5, 2.0, 2.5, 4.0, 5.0, 7.5, 10.0};
    private Diagram diagram;
    private String name;
    private String unit;
    private double unitFactor;
    private double minValue;
    private double maxValue;
    private int numMajorTicks;
    private int numMinorTicks;
    private boolean isMinToMax;

    public DiagramAxis() {
        this(null, null);
    }

    public DiagramAxis(String name, String unit) {
        this.name = name;
        this.unit = unit;
        this.unitFactor = 1.0;
        this.minValue = 0.0;
        this.maxValue = 100.0;
        this.numMajorTicks = 3;
        this.numMinorTicks = 5;
        this.isMinToMax = true;
    }

    public String getName() {
        return this.name;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public void setName(String name) {
        if (!ObjectUtils.equalObjects((Object)this.name, (Object)name)) {
            this.name = name;
            this.invalidate();
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        if (!ObjectUtils.equalObjects((Object)this.unit, (Object)unit)) {
            this.unit = unit;
            this.invalidate();
        }
    }

    public double getUnitFactor() {
        return this.unitFactor;
    }

    public void setUnitFactor(double unitFactor) {
        if (this.unitFactor != unitFactor) {
            this.unitFactor = unitFactor;
            this.invalidate();
        }
    }

    public void setMinToMax(boolean isMinToMax) {
        this.isMinToMax = isMinToMax;
    }

    public boolean isMinToMax() {
        return this.isMinToMax;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setValueRange(double minValue, double maxValue) {
        if (minValue >= maxValue) {
            throw new IllegalArgumentException("minValue >= maxValue");
        }
        if (this.minValue != minValue || this.maxValue != maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.invalidate();
        }
    }

    public int getNumMajorTicks() {
        return this.numMajorTicks;
    }

    public void setNumMajorTicks(int numMajorTicks) {
        if (numMajorTicks < 2) {
            throw new IllegalArgumentException("numMajorTicks < 2");
        }
        if (this.numMajorTicks != numMajorTicks) {
            this.numMajorTicks = numMajorTicks;
            this.invalidate();
        }
    }

    public int getNumMinorTicks() {
        return this.numMinorTicks;
    }

    public void setNumMinorTicks(int numMinorTicks) {
        if (numMinorTicks < 2) {
            throw new IllegalArgumentException("numMinorTicks < 2");
        }
        if (this.numMinorTicks != numMinorTicks) {
            this.numMinorTicks = numMinorTicks;
            this.invalidate();
        }
    }

    public double getMajorTickMarkDistance() {
        return (this.getMaxValue() - this.getMinValue()) / (double)(this.getNumMajorTicks() - 1);
    }

    public void setSubDivision(double minValue, double maxValue, int numMajorTicks, int numMinorTicks) {
        this.setValueRange(minValue, maxValue);
        this.setNumMajorTicks(numMajorTicks);
        this.setNumMinorTicks(numMinorTicks);
    }

    public void setOptimalSubDivision(int numMajorTicksMin, int numMajorTicksMax, int numMinorTicks) {
        double oldMinValue = this.minValue;
        double oldMaxValue = this.maxValue;
        double oldDelta = oldMaxValue - oldMinValue;
        double deltaDeltaMin = Double.MAX_VALUE;
        int numMajorTicksOpt = this.numMajorTicks;
        double newMinValueOpt = oldMinValue;
        double newMaxValueOpt = oldMaxValue;
        for (int numMajorTicks = numMajorTicksMin; numMajorTicks <= numMajorTicksMax; ++numMajorTicks) {
            double tickDist = DiagramAxis.getOptimalTickDistance(oldMinValue, oldMaxValue, numMajorTicks);
            double newMinValue = DiagramAxis.adjustFloor(oldMinValue, tickDist);
            double newMaxValue = DiagramAxis.adjustCeil(oldMaxValue, tickDist);
            double newDelta = newMaxValue - newMinValue;
            double deltaDelta = Math.abs(newDelta - oldDelta);
            if (!(deltaDelta < deltaDeltaMin)) continue;
            deltaDeltaMin = deltaDelta;
            numMajorTicksOpt = numMajorTicks;
            newMinValueOpt = newMinValue;
            newMaxValueOpt = newMaxValue;
        }
        this.setSubDivision(newMinValueOpt, newMaxValueOpt, numMajorTicksOpt, numMinorTicks);
    }

    public static double getOptimalTickDistance(double minValue, double maxValue, int numMajorTicks) {
        double tickFactor;
        if (minValue >= maxValue) {
            throw new IllegalArgumentException("minValue >= maxValue");
        }
        if (numMajorTicks < 2) {
            throw new IllegalArgumentException("numMajorTicks < 2");
        }
        double tickDist = (maxValue - minValue) / (double)(numMajorTicks - 1);
        double oom = MathUtils.getOrderOfMagnitude((double)tickDist);
        double scale = Math.pow(10.0, oom);
        double tickDistOpt = 0.0;
        double[] dArray = _tickFactors;
        int n = dArray.length;
        for (int i = 0; i < n && !((tickDistOpt = (tickFactor = dArray[i]) * scale) >= tickDist); ++i) {
        }
        return tickDistOpt;
    }

    private static double adjustCeil(double x, double dx) {
        return Math.ceil(x / dx) * dx;
    }

    private static double adjustFloor(double x, double dx) {
        return Math.floor(x / dx) * dx;
    }

    public String[] createTickmarkTexts() {
        double roundFactor = MathUtils.computeRoundFactor((double)this.getMinValue(), (double)this.getMaxValue(), (int)3);
        return DiagramAxis.createTickmarkTexts(this.getMinValue(), this.getMaxValue(), this.getNumMajorTicks(), roundFactor);
    }

    private static String[] createTickmarkTexts(double min, double max, int n, double roundFactor) {
        String[] texts = new String[n];
        for (int i = 0; i < n; ++i) {
            long xi;
            double x = min + (double)i * (max - min) / (double)(n - 1);
            texts[i] = (x = MathUtils.round((double)x, (double)roundFactor)) == (double)(xi = (long)Math.floor(x)) ? String.valueOf(xi) : String.valueOf(x);
        }
        return texts;
    }

    private void invalidate() {
        if (this.diagram != null) {
            this.diagram.invalidate();
        }
    }
}

