/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueSet;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.esa.snap.core.datamodel.ImageGeometry;
import org.esa.snap.core.datamodel.Product;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OutputGeometryFormModel {
    public static final int REFERENCE_PIXEL_UPPER_LEFT = 0;
    public static final int REFERENCE_PIXEL_SCENE_CENTER = 1;
    public static final int REFERENCE_PIXEL_USER = 2;
    private static final int REFERENCE_PIXEL_DEFAULT = 1;
    private static final boolean FIT_PRODUCT_SIZE_DEFAULT = true;
    private transient Product sourceProduct;
    private transient CoordinateReferenceSystem targetCrs;
    private transient PropertySet propertyContainer;
    private int referencePixelLocation;
    private boolean fitProductSize;

    public OutputGeometryFormModel(PropertySet sourcePropertySet) {
        this.init(null, null, sourcePropertySet);
    }

    public OutputGeometryFormModel(Product sourceProduct, Product collocationProduct) {
        this(sourceProduct, ImageGeometry.createCollocationTargetGeometry((Product)sourceProduct, (Product)collocationProduct));
    }

    public OutputGeometryFormModel(Product sourceProduct, CoordinateReferenceSystem targetCrs) {
        this(sourceProduct, ImageGeometry.createTargetGeometry((Product)sourceProduct, (CoordinateReferenceSystem)targetCrs, null, null, null, null, null, null, null, null, null));
    }

    public OutputGeometryFormModel(Product sourceProduct, CoordinateReferenceSystem targetCrs, PropertySet ps) {
        this(sourceProduct, ImageGeometry.createTargetGeometry((Product)sourceProduct, (CoordinateReferenceSystem)targetCrs, (Double)((Double)ps.getValue("pixelSizeX")), (Double)((Double)ps.getValue("pixelSizeY")), (Integer)((Integer)ps.getValue("width")), (Integer)((Integer)ps.getValue("height")), (Double)((Double)ps.getValue("orientation")), (Double)((Double)ps.getValue("easting")), (Double)((Double)ps.getValue("northing")), (Double)((Double)ps.getValue("referencePixelX")), (Double)((Double)ps.getValue("referencePixelY"))));
    }

    public OutputGeometryFormModel(OutputGeometryFormModel formModel) {
        this.init(formModel.sourceProduct, formModel.targetCrs, formModel.getPropertySet());
    }

    private OutputGeometryFormModel(Product sourceProduct, ImageGeometry imageGeometry) {
        this.init(sourceProduct, imageGeometry.getMapCrs(), (PropertySet)PropertyContainer.createObjectBacked((Object)imageGeometry));
    }

    private void init(Product sourceProduct, CoordinateReferenceSystem targetCrs, PropertySet sourcePropertySet) {
        Property[] properties;
        this.sourceProduct = sourceProduct;
        this.targetCrs = targetCrs;
        this.setFitProductSize(OutputGeometryFormModel.getFitProductSize(sourceProduct, sourcePropertySet, targetCrs));
        this.setReferencePixelLocation(OutputGeometryFormModel.getReferencePixelLocation(sourcePropertySet));
        this.propertyContainer = PropertyContainer.createValueBacked(ImageGeometry.class);
        this.configurePropertyContainer(this.propertyContainer);
        for (Property property : properties = sourcePropertySet.getProperties()) {
            if (!this.propertyContainer.isPropertyDefined(property.getName())) continue;
            this.propertyContainer.setValue(property.getName(), property.getValue());
        }
    }

    public PropertySet getPropertySet() {
        return this.propertyContainer;
    }

    public void setSourceProduct(Product sourceProduct) {
        this.sourceProduct = sourceProduct;
        this.updateProductSize();
    }

    public void setTargetCrs(CoordinateReferenceSystem targetCrs) {
        this.targetCrs = targetCrs;
        this.updateProductSize();
        this.setAxisUnits(this.propertyContainer);
    }

    public void resetToDefaults(ImageGeometry ig) {
        Property[] properties;
        PropertyContainer pc = PropertyContainer.createObjectBacked((Object)ig);
        for (Property property : properties = pc.getProperties()) {
            this.propertyContainer.setValue(property.getName(), property.getValue());
        }
        this.propertyContainer.setValue("referencePixelLocation", (Object)1);
        this.propertyContainer.setValue("fitProductSize", (Object)true);
    }

    private void configurePropertyContainer(PropertySet ps) {
        PropertyContainer thisPS = PropertyContainer.createObjectBacked((Object)this);
        ps.addProperties(thisPS.getProperties());
        ps.getDescriptor("referencePixelLocation").setValueSet(new ValueSet((Object[])new Integer[]{0, 1, 2}));
        this.setAxisUnits(ps);
        ps.getDescriptor("orientation").setUnit("\u00b0");
        ps.addPropertyChangeListener((PropertyChangeListener)new ChangeListener());
    }

    private void setAxisUnits(PropertySet pc) {
        if (this.targetCrs != null) {
            String crsAxisUnit = this.targetCrs.getCoordinateSystem().getAxis(0).getUnit().toString();
            pc.getDescriptor("easting").setUnit(crsAxisUnit);
            pc.getDescriptor("northing").setUnit(crsAxisUnit);
            pc.getDescriptor("pixelSizeX").setUnit(crsAxisUnit);
            pc.getDescriptor("pixelSizeY").setUnit(crsAxisUnit);
        }
    }

    private void updateProductSize() {
        if (this.targetCrs != null && this.sourceProduct != null) {
            Double pixelSizeX = (Double)this.propertyContainer.getValue("pixelSizeX");
            Double pixelSizeY = (Double)this.propertyContainer.getValue("pixelSizeY");
            Rectangle productSize = ImageGeometry.calculateProductSize((Product)this.sourceProduct, (CoordinateReferenceSystem)this.targetCrs, (double)pixelSizeX, (double)pixelSizeY);
            this.propertyContainer.setValue("width", (Object)productSize.width);
            this.propertyContainer.setValue("height", (Object)productSize.height);
        }
    }

    private void updateReferencePixel() {
        double referencePixelX = (Double)this.propertyContainer.getValue("referencePixelX");
        double referencePixelY = (Double)this.propertyContainer.getValue("referencePixelY");
        if (this.getReferencePixelLocation() == 0) {
            referencePixelX = 0.5;
            referencePixelY = 0.5;
        } else if (this.getReferencePixelLocation() == 1) {
            referencePixelX = 0.5 * (double)((Integer)this.propertyContainer.getValue("width")).intValue();
            referencePixelY = 0.5 * (double)((Integer)this.propertyContainer.getValue("height")).intValue();
        }
        this.propertyContainer.setValue("referencePixelX", (Object)referencePixelX);
        this.propertyContainer.setValue("referencePixelY", (Object)referencePixelY);
    }

    private static boolean getFitProductSize(Product sourceProduct, PropertySet sourcePropertySet, CoordinateReferenceSystem targetCrs) {
        if (sourceProduct != null) {
            int width = (Integer)sourcePropertySet.getValue("width");
            int height = (Integer)sourcePropertySet.getValue("height");
            ImageGeometry iGeometry = ImageGeometry.createTargetGeometry((Product)sourceProduct, (CoordinateReferenceSystem)targetCrs, null, null, null, null, null, null, null, null, null);
            Rectangle imageRect = iGeometry.getImageRect();
            return width == imageRect.width && height == imageRect.height;
        }
        return sourcePropertySet.getProperty("width") == null && sourcePropertySet.getProperty("height") == null;
    }

    private static int getReferencePixelLocation(PropertySet sourcePropertySet) {
        if (sourcePropertySet != null) {
            double referencePixelX = (Double)sourcePropertySet.getValue("referencePixelX");
            double referencePixelY = (Double)sourcePropertySet.getValue("referencePixelY");
            int width = (Integer)sourcePropertySet.getValue("width");
            int height = (Integer)sourcePropertySet.getValue("height");
            if (referencePixelX == 0.5 && referencePixelY == 0.5) {
                return 0;
            }
            if (referencePixelX == (double)width / 2.0 && referencePixelY == (double)height / 2.0) {
                return 1;
            }
            return 2;
        }
        return 1;
    }

    public int getReferencePixelLocation() {
        return this.referencePixelLocation;
    }

    public void setReferencePixelLocation(int referencePixelLocation) {
        this.referencePixelLocation = referencePixelLocation;
    }

    boolean isReferencePixelLocationSetTo(int referencePixelLocationId) {
        return this.getReferencePixelLocation() == referencePixelLocationId;
    }

    public boolean isFitProductSize() {
        return this.fitProductSize;
    }

    public void setFitProductSize(boolean fitProductSize) {
        this.fitProductSize = fitProductSize;
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if (OutputGeometryFormModel.this.isFitProductSize()) {
                if (propertyName.startsWith("pixelSize") || propertyName.startsWith("fitProductSize")) {
                    OutputGeometryFormModel.this.updateProductSize();
                    OutputGeometryFormModel.this.updateReferencePixel();
                }
            } else if (propertyName.startsWith("referencePixelLocation") || (propertyName.startsWith("width") || propertyName.startsWith("height")) && OutputGeometryFormModel.this.getReferencePixelLocation() == 1) {
                OutputGeometryFormModel.this.updateReferencePixel();
            }
        }
    }
}

