/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.crs;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.crs.OutputGeometryFormModel;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OutputGeometryForm
extends JPanel {
    private final BindingContext context;
    private JCheckBox fitProductSizeCheckBox;
    private JTextField widthTextfield;
    private JTextField heightTextfield;
    private final OutputGeometryFormModel model;

    public OutputGeometryForm(OutputGeometryFormModel model) {
        this.context = new BindingContext(model.getPropertySet());
        this.model = model;
        this.createUI();
    }

    private void createUI() {
        int line = 0;
        JPanel dialogPane = GridBagUtils.createPanel();
        dialogPane.setBorder(new EmptyBorder(7, 7, 7, 7));
        GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
        GridBagUtils.setAttributes(gbc, "insets.top=0,gridwidth=3");
        JRadioButton pixelRefULeftButton = new JRadioButton("Reference pixel is at scene upper left", false);
        JRadioButton pixelRefCenterButton = new JRadioButton("Reference pixel is at scene center", false);
        JRadioButton pixelRefOtherButton = new JRadioButton("Other reference pixel position", false);
        ButtonGroup g = new ButtonGroup();
        g.add(pixelRefULeftButton);
        g.add(pixelRefCenterButton);
        g.add(pixelRefOtherButton);
        this.context.bind("referencePixelLocation", g);
        this.context.bindEnabledState("referencePixelX", true, "referencePixelLocation", (Object)2);
        this.context.bindEnabledState("referencePixelY", true, "referencePixelLocation", (Object)2);
        if (this.model.isReferencePixelLocationSetTo(0)) {
            pixelRefULeftButton.setSelected(true);
        } else if (this.model.isReferencePixelLocationSetTo(1)) {
            pixelRefCenterButton.setSelected(true);
        } else {
            pixelRefOtherButton.setSelected(true);
        }
        ++line;
        gbc.gridy = line++;
        GridBagUtils.addToPanel(dialogPane, pixelRefULeftButton, gbc, "fill=HORIZONTAL,weightx=1");
        gbc.gridy = line++;
        GridBagUtils.addToPanel(dialogPane, pixelRefCenterButton, gbc);
        gbc.gridy = line++;
        GridBagUtils.addToPanel(dialogPane, pixelRefOtherButton, gbc);
        gbc.gridy = line;
        JComponent[] components = this.createComponents("referencePixelX");
        JComponent unitcomponent = this.createUnitComponent("referencePixelX");
        GridBagUtils.addToPanel(dialogPane, components[1], gbc, "insets.top=1,gridwidth=1,fill=NONE,weightx=0");
        GridBagUtils.addToPanel(dialogPane, components[0], gbc, "fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel(dialogPane, unitcomponent, gbc, "fill=NONE,weightx=0");
        JTextField referencePixelXTextfield = (JTextField)components[0];
        if (pixelRefCenterButton.isSelected()) {
            referencePixelXTextfield.setEnabled(false);
        }
        gbc.gridy = ++line;
        components = this.createComponents("referencePixelY");
        unitcomponent = this.createUnitComponent("referencePixelY");
        GridBagUtils.addToPanel(dialogPane, components[1], gbc, "insets.top=3");
        GridBagUtils.addToPanel(dialogPane, components[0], gbc, "fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel(dialogPane, unitcomponent, gbc, "fill=NONE,weightx=0");
        JTextField referencePixelYTextfield = (JTextField)components[0];
        if (pixelRefCenterButton.isSelected()) {
            referencePixelYTextfield.setEnabled(false);
        }
        ++line;
        gbc.gridy = line++;
        components = this.createComponents("easting");
        unitcomponent = this.createUnitComponent("easting");
        GridBagUtils.addToPanel(dialogPane, components[1], gbc, "insets.top=12");
        GridBagUtils.addToPanel(dialogPane, components[0], gbc, "fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel(dialogPane, unitcomponent, gbc, "fill=NONE,weightx=0");
        JTextField eastingTextfield = (JTextField)components[0];
        String original = eastingTextfield.getText();
        eastingTextfield.setText("0.01234567890123456789");
        Dimension size = eastingTextfield.getPreferredSize();
        eastingTextfield.setText(original);
        eastingTextfield.setPreferredSize(size);
        gbc.gridy = line++;
        components = this.createComponents("northing");
        unitcomponent = this.createUnitComponent("northing");
        GridBagUtils.addToPanel(dialogPane, components[1], gbc, "insets.top=3");
        GridBagUtils.addToPanel(dialogPane, components[0], gbc, "fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel(dialogPane, unitcomponent, gbc, "fill=NONE,weightx=0");
        gbc.gridy = line++;
        components = this.createComponents("orientation");
        unitcomponent = this.createUnitComponent("orientation");
        GridBagUtils.addToPanel(dialogPane, components[1], gbc, "insets.top=3");
        GridBagUtils.addToPanel(dialogPane, components[0], gbc, "fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel(dialogPane, unitcomponent, gbc, "fill=NONE,weightx=0");
        gbc.gridy = line++;
        components = this.createComponents("pixelSizeX");
        unitcomponent = this.createUnitComponent("pixelSizeX");
        GridBagUtils.addToPanel(dialogPane, components[1], gbc, "insets.top=12");
        GridBagUtils.addToPanel(dialogPane, components[0], gbc, "fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel(dialogPane, unitcomponent, gbc, "fill=NONE,weightx=0");
        gbc.gridy = line++;
        components = this.createComponents("pixelSizeY");
        unitcomponent = this.createUnitComponent("pixelSizeY");
        GridBagUtils.addToPanel(dialogPane, components[1], gbc, "insets.top=3");
        GridBagUtils.addToPanel(dialogPane, components[0], gbc, "fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel(dialogPane, unitcomponent, gbc, "fill=NONE,weightx=0");
        gbc.gridy = line++;
        components = this.createComponents("fitProductSize");
        this.context.bindEnabledState("width", false, "fitProductSize", (Object)true);
        this.context.bindEnabledState("height", false, "fitProductSize", (Object)true);
        this.fitProductSizeCheckBox = (JCheckBox)components[0];
        GridBagUtils.addToPanel(dialogPane, this.fitProductSizeCheckBox, gbc, "insets.top=12, gridwidth=3,fill=HORIZONTAL,weightx=1");
        gbc.gridy = line;
        components = this.createComponents("width");
        unitcomponent = this.createUnitComponent("width");
        GridBagUtils.addToPanel(dialogPane, components[1], gbc, "insets.top=3, gridwidth=1,fill=NONE,weightx=0");
        GridBagUtils.addToPanel(dialogPane, components[0], gbc, "fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel(dialogPane, unitcomponent, gbc, "fill=NONE,weightx=0");
        this.widthTextfield = (JTextField)components[0];
        if (this.model.isFitProductSize()) {
            this.widthTextfield.setEnabled(false);
        }
        gbc.gridy = ++line;
        components = this.createComponents("height");
        unitcomponent = this.createUnitComponent("height");
        GridBagUtils.addToPanel(dialogPane, components[1], gbc);
        GridBagUtils.addToPanel(dialogPane, components[0], gbc, "fill=HORIZONTAL,weightx=1");
        GridBagUtils.addToPanel(dialogPane, unitcomponent, gbc, "fill=NONE,weightx=0");
        this.heightTextfield = (JTextField)components[0];
        if (this.model.isFitProductSize()) {
            this.heightTextfield.setEnabled(false);
        }
        this.fitProductSizeCheckBox.addActionListener(e -> {
            if (this.fitProductSizeCheckBox.isSelected()) {
                this.widthTextfield.setEnabled(false);
                this.heightTextfield.setEnabled(false);
            } else {
                this.widthTextfield.setEnabled(true);
                this.heightTextfield.setEnabled(true);
            }
        });
        if (this.model.isFitProductSize()) {
            this.fitProductSizeCheckBox.setSelected(true);
        }
        this.add(dialogPane);
    }

    private JComponent[] createComponents(String propertyName) {
        PropertyDescriptor descriptor = this.context.getPropertySet().getDescriptor(propertyName);
        PropertyEditorRegistry propertyEditorRegistry = PropertyEditorRegistry.getInstance();
        PropertyEditor editor = propertyEditorRegistry.findPropertyEditor(descriptor);
        return editor.createComponents(descriptor, this.context);
    }

    private JComponent createUnitComponent(String propertyName) {
        PropertyDescriptor descriptor = this.context.getPropertySet().getDescriptor(propertyName);
        JLabel unitLabel = new JLabel(descriptor.getUnit());
        this.context.getBinding(propertyName).addComponent((JComponent)unitLabel);
        return unitLabel;
    }

    public static void main(String[] args) throws Exception {
        JFrame jFrame = new JFrame("Output parameter Definition Form");
        Container contentPane = jFrame.getContentPane();
        if (args.length == 0) {
            throw new IllegalArgumentException("Missing argument to product file.");
        }
        Product sourceProduct = ProductIO.readProduct((String)args[0]);
        CoordinateReferenceSystem targetCrs = CRS.decode((String)"EPSG:32632");
        OutputGeometryFormModel model = new OutputGeometryFormModel(sourceProduct, targetCrs);
        OutputGeometryForm form = new OutputGeometryForm(model);
        contentPane.add(form);
        jFrame.setSize(400, 600);
        jFrame.setLocationRelativeTo(null);
        jFrame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(() -> jFrame.setVisible(true));
    }
}

