/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.JTextComponent;
import org.esa.snap.ui.loading.SwingUtils;
import org.jdesktop.swingx.JXMonthView;

public class DatePickerComboBox
extends JComboBox<Void> {
    private final int preferredHeight;
    private final DateFormat dateFormat;
    private final JXMonthView monthView;
    private final JPopupMenu popup;

    public DatePickerComboBox(int preferredHeight, Color backgroundColor, DateFormat dateFormat) {
        if (preferredHeight <= 0) {
            throw new IllegalArgumentException("The preferred size " + preferredHeight + " must be > 0.");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("The background color is null.");
        }
        if (dateFormat == null) {
            throw new NullPointerException("The date format is null.");
        }
        this.preferredHeight = preferredHeight;
        this.dateFormat = dateFormat;
        this.setBackground(backgroundColor);
        this.setBorder(SwingUtils.LINE_BORDER);
        this.setEditable(true);
        this.monthView = new JXMonthView();
        this.monthView.setTraversable(true);
        this.monthView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DatePickerComboBox.this.newSelectedDate();
                    }
                });
            }
        });
        Date todayDate = new Date(System.currentTimeMillis());
        String dateAsString = this.dateFormat.format(todayDate);
        JLabel todayLabel = new JLabel("Today is " + dateAsString, 0);
        MatteBorder outsideBorder = new MatteBorder(1, 0, 0, 0, SwingUtils.LINE_BORDER.getLineColor());
        EmptyBorder insideBorder = new EmptyBorder(5, 0, 5, 0);
        todayLabel.setBorder(new CompoundBorder(outsideBorder, insideBorder));
        this.popup = new JPopupMenu();
        this.popup.setLayout(new BorderLayout());
        this.popup.add((Component)this.monthView, "Center");
        this.popup.add((Component)todayLabel, "South");
        this.popup.setBorder(SwingUtils.LINE_BORDER);
        JTextComponent editorComponent = this.getEditorComponent();
        editorComponent.setBorder(null);
        editorComponent.setOpaque(false);
        editorComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DatePickerComboBox.this.popup.setVisible(false);
            }
        });
        this.replaceArrowButtonMouseListeners();
    }

    @Override
    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getEditor() != null && this.getEditor().getEditorComponent() != null) {
            this.getEditor().getEditorComponent().setEnabled(enabled);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, this.preferredHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.height = this.preferredHeight;
        return size;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = super.getMaximumSize();
        size.height = this.preferredHeight;
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = this.preferredHeight;
        return size;
    }

    public void setDate(Date date) {
        this.monthView.setSelectionDate(date);
        String dateAsString = date == null ? "" : this.dateFormat.format(date);
        this.getEditorComponent().setText(dateAsString);
    }

    public String getEnteredDateAsString() {
        return this.getEditorComponent().getText().trim();
    }

    public Date getDate() {
        String dateAsString = this.getEnteredDateAsString();
        if (dateAsString.length() > 0) {
            try {
                return this.dateFormat.parse(dateAsString);
            }
            catch (ParseException e) {
                throw new IllegalStateException("Failed to parse the date '" + dateAsString + "'.", e);
            }
        }
        return null;
    }

    private void newSelectedDate() {
        String dateAsString = this.dateFormat.format(this.monthView.getSelectionDate());
        this.getEditorComponent().setText(dateAsString);
        this.popup.setVisible(false);
    }

    private JTextComponent getEditorComponent() {
        return (JTextComponent)this.getEditor().getEditorComponent();
    }

    private void toggleShowPopup() {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            Date visibleDate;
            String dateAsString = this.getEnteredDateAsString();
            Date date = null;
            if (dateAsString.length() > 0) {
                try {
                    date = this.dateFormat.parse(dateAsString);
                }
                catch (ParseException e) {
                    this.getEditorComponent().setText("");
                }
            }
            if ((visibleDate = date) == null) {
                visibleDate = new Date(System.currentTimeMillis());
            }
            this.monthView.setSelectionDate(date);
            this.monthView.ensureDateVisible(visibleDate);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DatePickerComboBox.this.popup.show(DatePickerComboBox.this, 0, DatePickerComboBox.this.getHeight());
                }
            });
        }
    }

    private void replaceArrowButtonMouseListeners() {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JButton)) continue;
            JButton arrowButton = (JButton)component;
            MouseListener[] mouseListeners = arrowButton.getMouseListeners();
            if (mouseListeners.length >= 1) {
                arrowButton.removeMouseListener(mouseListeners[1]);
            }
            arrowButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    DatePickerComboBox.this.toggleShowPopup();
                }
            });
        }
    }
}

