/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JTextField;
import org.esa.snap.ui.loading.SwingUtils;

public class CustomTextField
extends JTextField {
    private final int preferredHeight;

    public CustomTextField(int preferredHeight, Color backgroundColor) {
        if (preferredHeight <= 0) {
            throw new IllegalArgumentException("The preferred size " + preferredHeight + " must be > 0.");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("The background color is null.");
        }
        this.preferredHeight = preferredHeight;
        this.setBackground(backgroundColor);
        this.setBorder(SwingUtils.LINE_BORDER);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, this.preferredHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.height = this.preferredHeight;
        return size;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = super.getMaximumSize();
        size.height = this.preferredHeight;
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = this.preferredHeight;
        return size;
    }
}

