/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputAdapter;
import org.esa.snap.ui.color.ColorCodes;
import org.esa.snap.ui.color.ColorComboBox;

public class ColorLabel
extends JComponent {
    private String displayName;
    private Color color;
    private boolean highlighted;
    private boolean hoverEnabled;
    private MouseInputAdapter hoverListener;

    public ColorLabel() {
        this(Color.WHITE);
    }

    public ColorLabel(Color color) {
        this(color, null);
    }

    public ColorLabel(Color color, String displayName) {
        this.color = color != null ? color : ColorComboBox.TRANSPARENCY;
        this.displayName = displayName;
        this.setPreferredSize(new Dimension(14, 14));
        this.setBorder(this.createEmptyBorder());
        this.updateText();
        this.hoverListener = new MouseHoverListener();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldValue = this.color;
        this.color = color != null ? color : ColorComboBox.TRANSPARENCY;
        this.updateText();
        this.repaint();
        this.firePropertyChange("color", oldValue, this.color);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        String oldValue = this.displayName;
        this.displayName = displayName;
        this.updateText();
        this.firePropertyChange("displayName", oldValue, this.displayName);
    }

    public boolean isHoverEnabled() {
        return this.hoverEnabled;
    }

    public void setHoverEnabled(boolean hoverEnabled) {
        boolean oldValue = this.hoverEnabled;
        this.hoverEnabled = hoverEnabled;
        if (hoverEnabled) {
            this.addMouseListener(this.hoverListener);
        } else {
            this.removeMouseListener(this.hoverListener);
        }
        this.firePropertyChange("hoverEnabled", oldValue, this.hoverEnabled);
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean highlighted) {
        boolean oldValue = this.highlighted;
        this.highlighted = highlighted;
        this.firePropertyChange("highlighted", oldValue, this.highlighted);
        if (highlighted) {
            this.setBorder(this.createHighlightedBorder());
        } else {
            this.setBorder(this.createEmptyBorder());
        }
    }

    private LineBorder createHighlightedBorder() {
        return new LineBorder(Color.BLUE, 1);
    }

    private Border createEmptyBorder() {
        return new EmptyBorder(1, 1, 1, 1);
    }

    private Color getColorBoxLineColor() {
        int cMax;
        int a = this.color.getAlpha();
        Color borderColor = a < 127 ? Color.GRAY : ((cMax = Math.max(this.color.getRed(), Math.max(this.color.getGreen(), this.color.getBlue()))) < 127 ? Color.LIGHT_GRAY : Color.GRAY);
        return borderColor;
    }

    private void updateText() {
        String name;
        String rgbText = this.color.getAlpha() != 255 ? String.format("%d,%d,%d,%d", this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()) : String.format("%d,%d,%d", this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        String text = this.getDisplayName() != null ? String.format("%s (%s)", this.getDisplayName(), rgbText) : ((name = ColorCodes.getName(this.color)) != null ? String.format("%s (%s)", name, rgbText) : rgbText);
        this.setToolTipText(text);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        int w = this.getWidth() - (this.getInsets().left + this.getInsets().right) - 1;
        int h = this.getHeight() - (this.getInsets().top + this.getInsets().bottom) - 1;
        if (this.getColor().getAlpha() < 255) {
            this.drawChessboardBackground(g, x, y, w, h);
        }
        this.drawColorBox(g, x, y, w, h);
    }

    private void drawColorBox(Graphics g, int x, int y, int w, int h) {
        g.setColor(this.getColor());
        g.fillRect(x, y, w, h);
        g.setColor(this.getColorBoxLineColor());
        g.drawRect(x, y, w, h);
    }

    private void drawChessboardBackground(Graphics g, int x, int y, int w, int h) {
        int s = 8;
        int ni = w / s + 1;
        int nj = h / s + 1;
        Shape clip = g.getClip();
        g.setClip(x, y, w, h);
        for (int j = 0; j < nj; ++j) {
            for (int i = 0; i < ni; ++i) {
                g.setColor(i % 2 != j % 2 ? Color.WHITE : Color.LIGHT_GRAY);
                g.fillRect(x + i * s, y + j * s, s, s);
            }
        }
        g.setClip(clip);
    }

    private class MouseHoverListener
    extends MouseInputAdapter {
        private MouseHoverListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ColorLabel.this.setHighlighted(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ColorLabel.this.setHighlighted(true);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
        }
    }
}

