/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.ui.color.ColorCodes;
import org.esa.snap.ui.color.ColorLabel;

public class ColorChooserPanel
extends JPanel {
    public static final String SELECTED_COLOR_PROPERTY = "selectedColor";
    static final Color TRANSPARENCY = new Color(0, 0, 0, 0);
    private static final int GAP = 2;
    private Color selectedColor;

    public ColorChooserPanel() {
        this(Color.WHITE);
    }

    public ColorChooserPanel(Color selectedColor) {
        super(new BorderLayout(2, 2));
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setSelectedColor(selectedColor);
        JButton noneButton = new JButton("None");
        noneButton.addActionListener(e -> this.setSelectedColor(TRANSPARENCY));
        JButton moreButton = new JButton("More...");
        moreButton.addActionListener(e -> {
            Color color = this.showMoreColorsDialog();
            if (color != null) {
                this.setSelectedColor(color);
            }
        });
        this.add((Component)noneButton, "North");
        this.add((Component)this.createColorPicker(), "Center");
        this.add((Component)moreButton, "South");
        this.setBackground(Color.WHITE);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        Color oldValue = this.selectedColor;
        this.selectedColor = selectedColor;
        this.firePropertyChange(SELECTED_COLOR_PROPERTY, oldValue, this.selectedColor);
    }

    protected JComponent createColorPicker() {
        Color[] colors = new Color[]{Color.BLACK, Color.DARK_GRAY, Color.GRAY, Color.LIGHT_GRAY, Color.WHITE, Color.CYAN, Color.BLUE, Color.MAGENTA, Color.YELLOW, Color.ORANGE, Color.RED, Color.PINK, Color.GREEN};
        JPanel colorsPanel = new JPanel(new GridLayout(-1, 6, 4, 4));
        colorsPanel.setOpaque(false);
        for (Color color : colors) {
            final ColorLabel colorLabel = new ColorLabel(color);
            colorLabel.setDisplayName(ColorCodes.getName(color));
            colorLabel.setHoverEnabled(true);
            colorLabel.setMaximumSize(colorLabel.getPreferredSize());
            colorLabel.setMinimumSize(colorLabel.getPreferredSize());
            colorLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    ColorChooserPanel.this.setSelectedColor(colorLabel.getColor());
                }
            });
            colorsPanel.add(colorLabel);
        }
        return colorsPanel;
    }

    protected Color showMoreColorsDialog() {
        JColorChooser colorChooser = new JColorChooser(this.getSelectedColor());
        AbstractColorChooserPanel[] oldChooserPanels = colorChooser.getChooserPanels();
        AbstractColorChooserPanel[] newChooserPanels = new AbstractColorChooserPanel[oldChooserPanels.length + 1];
        System.arraycopy(oldChooserPanels, 0, newChooserPanels, 1, oldChooserPanels.length);
        newChooserPanels[0] = new MyAbstractColorChooserPanel();
        colorChooser.setChooserPanels(newChooserPanels);
        ColorTracker colorTracker = new ColorTracker(colorChooser);
        JDialog dialog = JColorChooser.createDialog(this, "Select Colour", true, colorChooser, colorTracker, null);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        return colorTracker.getColor();
    }

    private static class ColorTracker
    implements ActionListener {
        private JColorChooser colorChooser;
        private Color color;

        public ColorTracker(JColorChooser colorChooser) {
            this.colorChooser = colorChooser;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.colorChooser.getColor();
        }
    }

    private static class MyAbstractColorChooserPanel
    extends AbstractColorChooserPanel
    implements ListSelectionListener {
        private JList<String> colorList;

        @Override
        public void updateChooser() {
            int i;
            Color selectedColor = this.getColorSelectionModel().getSelectedColor();
            if (selectedColor != null && (i = ColorCodes.indexOf(selectedColor)) >= 0) {
                this.colorList.setSelectedIndex(i);
            }
        }

        @Override
        protected void buildChooser() {
            this.colorList = new JList<String>(new Vector<String>(ColorCodes.getNames()));
            DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setOpaque(true);
                    Color color = ColorCodes.getColor(value.toString());
                    int max = Math.max(color.getRed(), Math.max(color.getGreen(), color.getBlue()));
                    this.setForeground(max < 160 ? Color.WHITE : Color.BLACK);
                    this.setBackground(color);
                    this.setBorder(new EmptyBorder(5, 5, 5, 5));
                    this.setFont(this.getFont().deriveFont(14.0f));
                    return this;
                }
            };
            this.colorList.setCellRenderer(cellRenderer);
            this.colorList.addListSelectionListener(this);
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.add((Component)new JScrollPane(this.colorList), "Center");
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedIndex = this.colorList.getSelectedIndex();
            Color color = ColorCodes.getColor(selectedIndex);
            this.getColorSelectionModel().setSelectedColor(color);
        }

        @Override
        public String getDisplayName() {
            return "HTML Color Codes";
        }

        @Override
        public Icon getSmallDisplayIcon() {
            return null;
        }

        @Override
        public Icon getLargeDisplayIcon() {
            return null;
        }
    }
}

