/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.assistant;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.assistant.AssistantPage;
import org.esa.snap.ui.assistant.AssistantPageContext;

public class AssistantPane
implements AssistantPageContext {
    private AssistantPage currentPage;
    private Deque<AssistantPage> pageStack = new ArrayDeque<AssistantPage>();
    private JDialog dialog;
    private Action prevAction = new PrevAction();
    private Action nextAction = new NextAction();
    private Action finishAction = new FinishAction();
    private JLabel titleLabel;
    private JPanel pagePanel;
    private HelpAction helpAction;
    private CancelAction cancelAction = new CancelAction();

    public AssistantPane(Window parent, String title) {
        this.helpAction = new HelpAction();
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 2, 2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.add(new JButton(this.prevAction));
        JButton nextButton = new JButton(this.nextAction);
        buttonPanel.add(nextButton);
        buttonPanel.add(new JButton(this.finishAction));
        buttonPanel.add(new JButton(this.cancelAction));
        buttonPanel.add(new JButton(this.helpAction));
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1, 14.0f));
        this.titleLabel.setHorizontalAlignment(4);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.titleLabel.setForeground(Color.WHITE);
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBackground(titlePanel.getBackground().darker());
        titlePanel.add((Component)this.titleLabel, "Center");
        this.pagePanel = new JPanel(new BorderLayout());
        this.pagePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dialog = new JDialog(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.getContentPane().add((Component)titlePanel, "North");
        this.dialog.getContentPane().add((Component)this.pagePanel, "Center");
        this.dialog.getContentPane().add((Component)buttonPanel, "South");
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.getRootPane().setDefaultButton(nextButton);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AssistantPane.this.cancelAction.cancel();
            }
        });
    }

    @Override
    public Window getWindow() {
        return this.dialog;
    }

    @Override
    public AssistantPage getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void setCurrentPage(AssistantPage currentPage) {
        this.currentPage = currentPage;
        this.pagePanel.removeAll();
        this.titleLabel.setText(currentPage.getPageTitle());
        this.pagePanel.add(currentPage.getPageComponent(), "Center");
        this.updateState();
        this.dialog.invalidate();
        this.dialog.validate();
        this.dialog.repaint();
    }

    @Override
    public void updateState() {
        AssistantPage page = this.getCurrentPage();
        if (page != null) {
            boolean pageValid = page.validatePage();
            this.prevAction.setEnabled(!this.pageStack.isEmpty());
            this.nextAction.setEnabled(pageValid && page.hasNextPage());
            this.finishAction.setEnabled(pageValid && page.canFinish());
            this.helpAction.setEnabled(page.canHelp());
        }
    }

    @Override
    public void showErrorDialog(String message) {
        AssistantPage currentPage = this.getCurrentPage();
        String dialogTitle = currentPage != null ? currentPage.getPageTitle() : "Unexpected Error";
        AbstractDialog.showErrorDialog(this.dialog, message, dialogTitle);
    }

    public void show(AssistantPage firstPage) {
        this.show(firstPage, null);
    }

    public void show(AssistantPage firstPage, Rectangle bounds) {
        this.initPage(firstPage);
        this.setCurrentPage(firstPage);
        if (bounds == null) {
            this.dialog.setSize(480, 320);
            UIUtils.centerComponent(this.dialog, this.dialog.getParent());
        } else {
            this.dialog.setBounds(bounds);
        }
        this.dialog.setVisible(true);
    }

    private void initPage(AssistantPage currentPage) {
        currentPage.setContext(this);
    }

    private void close() {
        this.dialog.dispose();
        this.pageStack.clear();
        this.currentPage = null;
    }

    private class HelpAction
    extends AbstractAction {
        private HelpAction() {
            super("Help");
            this.putValue("ActionCommandKey", "Help");
            this.putValue("MnemonicKey", 72);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(156, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AssistantPane.this.getCurrentPage().performHelp();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
            super("Cancel");
            this.putValue("ActionCommandKey", "Cancel");
            this.putValue("MnemonicKey", 67);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancel();
        }

        public void cancel() {
            AssistantPane.this.getCurrentPage().performCancel();
            AssistantPane.this.close();
        }
    }

    private class FinishAction
    extends AbstractAction {
        private FinishAction() {
            super("Finish");
            this.putValue("ActionCommandKey", "Finish");
            this.putValue("MnemonicKey", 70);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AssistantPane.this.getCurrentPage().performFinish()) {
                AssistantPane.this.close();
            }
        }
    }

    private class NextAction
    extends AbstractAction {
        private NextAction() {
            super("Next >");
            this.putValue("ActionCommandKey", "Next");
            this.putValue("MnemonicKey", 78);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AssistantPage nextPage = AssistantPane.this.currentPage.getNextPage();
            if (nextPage != null) {
                AssistantPane.this.pageStack.push(AssistantPane.this.currentPage);
                AssistantPane.this.initPage(nextPage);
                AssistantPane.this.setCurrentPage(nextPage);
            }
        }
    }

    private class PrevAction
    extends AbstractAction {
        private PrevAction() {
            super("< Previous");
            this.putValue("ActionCommandKey", "Previous");
            this.putValue("MnemonicKey", 80);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AssistantPane.this.setCurrentPage(AssistantPane.this.pageStack.pop());
        }
    }
}

