/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import org.esa.snap.core.util.Guardian;

public class UserInputHistory {
    private String propertyKey;
    private int maxNumEntries;
    private List<String> entriesList;

    public UserInputHistory(int maxNumEntries, String propertyKey) {
        Guardian.assertNotNullOrEmpty((String)"propertyKey", (String)propertyKey);
        this.propertyKey = propertyKey;
        this.setMaxNumEntries(maxNumEntries);
    }

    public int getNumEntries() {
        if (this.entriesList != null) {
            return this.entriesList.size();
        }
        return 0;
    }

    public int getMaxNumEntries() {
        return this.maxNumEntries;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String[] getEntries() {
        if (this.entriesList != null) {
            return this.entriesList.toArray(new String[this.entriesList.size()]);
        }
        return null;
    }

    public void initBy(Preferences preferences) {
        int maxNumEntries = preferences.getInt(this.getLengthKey(), this.getMaxNumEntries());
        this.setMaxNumEntries(maxNumEntries);
        for (int i = maxNumEntries - 1; i >= 0; --i) {
            String entry = preferences.get(this.getNumKey(i), null);
            if (entry == null || !this.isValidItem(entry)) continue;
            this.push(entry);
        }
    }

    protected boolean isValidItem(String item) {
        return true;
    }

    public void push(String entry) {
        if (entry != null && this.isValidItem(entry)) {
            if (this.entriesList == null) {
                this.entriesList = new LinkedList<String>();
            }
            for (String anEntry : this.entriesList) {
                if (!anEntry.equals(entry)) continue;
                this.entriesList.remove(anEntry);
                break;
            }
            if (this.entriesList.size() == this.maxNumEntries) {
                this.entriesList.remove(this.entriesList.size() - 1);
            }
            this.entriesList.add(0, entry);
        }
    }

    public void copyInto(Preferences preferences) {
        preferences.putInt(this.getLengthKey(), this.maxNumEntries);
        for (int i = 0; i < 100; ++i) {
            preferences.put(this.getNumKey(i), "");
        }
        String[] entries = this.getEntries();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                preferences.put(this.getNumKey(i), entries[i]);
            }
        }
    }

    private String getLengthKey() {
        return this.propertyKey + ".length";
    }

    private String getNumKey(int index) {
        return this.propertyKey + "." + index;
    }

    public void setMaxNumEntries(int maxNumEntries) {
        int n = this.maxNumEntries = maxNumEntries > 0 ? maxNumEntries : 16;
        if (this.entriesList != null) {
            while (this.maxNumEntries < this.entriesList.size()) {
                this.entriesList.remove(this.entriesList.size() - 1);
            }
        }
    }
}

