/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openide.util.HelpCtx;

public class SelectExportMethodDialog {
    public static final int EXPORT_TO_CLIPBOARD = 0;
    public static final int EXPORT_TO_FILE = 1;
    public static final int EXPORT_CANCELED = -1;

    public static int run(Component parentComponent, String title, String text, String helpID) {
        return SelectExportMethodDialog.run(parentComponent, title, text, new JCheckBox[0], helpID);
    }

    public static int run(Component parentComponent, String title, String text, JCheckBox[] options, String helpID) {
        DialogDescriptor descriptor = SelectExportMethodDialog.createDialog(parentComponent, title, text, helpID, options);
        descriptor.dialog.setVisible(true);
        return SelectExportMethodDialog.getChosenMethod(descriptor);
    }

    private static int getChosenMethod(DialogDescriptor descriptor) {
        int method = -1;
        Object value = descriptor.optionPane.getValue();
        if (descriptor.copyToClipboardButton.equals(value)) {
            method = 0;
        } else if (descriptor.writeToFileButton.equals(value)) {
            method = 1;
        }
        return method;
    }

    private static DialogDescriptor createDialog(Component parentComponent, String title, String text, String helpID, JCheckBox[] options) {
        String copyToClipboardText = "Copy to Clipboard";
        String writeToFileText = "Write to File";
        String cancelText = "Cancel";
        String iconDir = "/org/esa/snap/resources/images/icons/";
        ImageIcon copyIcon = new ImageIcon(SelectExportMethodDialog.class.getResource("/org/esa/snap/resources/images/icons/Copy16.gif"));
        ImageIcon saveIcon = new ImageIcon(SelectExportMethodDialog.class.getResource("/org/esa/snap/resources/images/icons/Save16.gif"));
        JButton copyToClipboardButton = new JButton("Copy to Clipboard");
        copyToClipboardButton.setMnemonic('b');
        copyToClipboardButton.setIcon(copyIcon);
        JButton writeToFileButton = new JButton("Write to File");
        writeToFileButton.setMnemonic('W');
        writeToFileButton.setIcon(saveIcon);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic('C');
        cancelButton.setIcon(null);
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel checkboxPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.gridx = 0;
        c.gridy = -1;
        for (JCheckBox option : options) {
            checkboxPanel.add((Component)option, c);
        }
        c.gridx = 0;
        c.gridy = 0;
        panel.add((Component)checkboxPanel, c);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        c.gridy = -1;
        buttonPanel.add((Component)copyToClipboardButton, c);
        buttonPanel.add((Component)writeToFileButton, c);
        buttonPanel.add((Component)cancelButton, c);
        c.gridx = 0;
        c.gridy = 1;
        panel.add((Component)buttonPanel, c);
        final JOptionPane optionPane = new JOptionPane(text, 3, -1, null, new JPanel[]{panel}, copyToClipboardButton);
        final JDialog dialog = optionPane.createDialog(parentComponent, title);
        dialog.getContentPane().setLayout(new BoxLayout(dialog.getContentPane(), 1));
        if (helpID != null) {
            HelpCtx.setHelpIDString((JComponent)optionPane, (String)helpID);
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                optionPane.setValue(e.getSource());
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        copyToClipboardButton.addActionListener(actionListener);
        writeToFileButton.addActionListener(actionListener);
        cancelButton.addActionListener(actionListener);
        return new DialogDescriptor(dialog, optionPane, copyToClipboardButton, writeToFileButton);
    }

    private static class DialogDescriptor {
        private final JDialog dialog;
        private final JOptionPane optionPane;
        private final JButton copyToClipboardButton;
        private final JButton writeToFileButton;

        private DialogDescriptor(JDialog dialog, JOptionPane optionPane, JButton copyToClipboardButton, JButton writeToFileButton) {
            this.dialog = dialog;
            this.optionPane = optionPane;
            this.copyToClipboardButton = copyToClipboardButton;
            this.writeToFileButton = writeToFileButton;
        }
    }
}

