/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureEditorAware;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.ShapeFigure;
import com.bc.ceres.swing.figure.ViewportInteractor;
import com.bc.ceres.swing.figure.support.DefaultFigureEditor;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.ui.BoundaryOverlay;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.WorldMapPane;
import org.esa.snap.ui.WorldMapPaneDataModel;

public class RegionSelectableWorldMapPane {
    static final String NORTH_BOUND = "northBound";
    static final String SOUTH_BOUND = "southBound";
    static final String WEST_BOUND = "westBound";
    static final String EAST_BOUND = "eastBound";
    private static final int OFFSET = 6;
    private final BindingContext bindingContext;
    private final DefaultFigureEditor figureEditor;
    private boolean mustInitFigureEditor = true;
    private final WorldMapPane worldMapPane;
    private final RegionSelectionInteractor regionSelectionInteractor;
    private final CursorChanger cursorChanger = new CursorChanger();
    private Rectangle2D selectionRectangle;
    private Rectangle2D movableRectangle;
    private Rectangle2D.Double defaultRectangle;
    private Shape defaultShape;
    private final RegionSelectionDecoratingPanSupport panSupport;
    private AtomicBoolean updatingModelBounds = new AtomicBoolean(false);

    public RegionSelectableWorldMapPane(WorldMapPaneDataModel dataModel, BindingContext bindingContext) {
        RegionSelectableWorldMapPane.ensureValidBindingContext(bindingContext);
        this.bindingContext = bindingContext;
        this.worldMapPane = new FigureEditorAwareWorldMapPane(dataModel, new SelectionOverlay(dataModel));
        this.panSupport = new RegionSelectionDecoratingPanSupport(this.worldMapPane.getLayerCanvas());
        this.worldMapPane.setPanSupport(this.panSupport);
        this.figureEditor = new DefaultFigureEditor((JComponent)this.worldMapPane.getLayerCanvas());
        this.regionSelectionInteractor = new RegionSelectionInteractor();
        this.worldMapPane.getLayerCanvas().addMouseMotionListener((MouseMotionListener)this.cursorChanger);
    }

    public JPanel createUI() {
        return this.worldMapPane;
    }

    static void ensureValidBindingContext(BindingContext bindingContext) {
        if (bindingContext == null) {
            throw new IllegalArgumentException("bindingContext must be not null");
        }
        RegionSelectableWorldMapPane.ensureExistingProperty(bindingContext, NORTH_BOUND);
        RegionSelectableWorldMapPane.ensureExistingProperty(bindingContext, SOUTH_BOUND);
        RegionSelectableWorldMapPane.ensureExistingProperty(bindingContext, WEST_BOUND);
        RegionSelectableWorldMapPane.ensureExistingProperty(bindingContext, EAST_BOUND);
        PropertySet propertySet = bindingContext.getPropertySet();
        Double northBound = (Double)propertySet.getValue(NORTH_BOUND);
        Double eastBound = (Double)propertySet.getValue(EAST_BOUND);
        Double southBound = (Double)propertySet.getValue(SOUTH_BOUND);
        Double westBound = (Double)propertySet.getValue(WEST_BOUND);
        if (northBound == null && eastBound == null && southBound == null && westBound == null) {
            RegionSelectableWorldMapPane.setDefaultValues(bindingContext);
        } else if (!RegionSelectableWorldMapPane.geoBoundsAreValid(northBound, eastBound, southBound, westBound)) {
            throw new IllegalArgumentException(MessageFormat.format("Given geo-bounds ({0}, {1}, {2}, {3}) are invalid.", northBound, eastBound, southBound, westBound));
        }
    }

    private DefaultFigureEditor getFigureEditor() {
        this.initFigureEditor(this.figureEditor, null);
        return this.figureEditor;
    }

    private void initFigureEditor(DefaultFigureEditor editor, Product selectedProduct) {
        if (this.mustInitFigureEditor) {
            this.initGeometries(selectedProduct);
            ShapeFigure polygonFigure = editor.getFigureFactory().createPolygonFigure(this.defaultShape, (FigureStyle)this.createFigureStyle((DefaultFigureStyle)editor.getDefaultPolygonStyle()));
            if (polygonFigure != null) {
                editor.getFigureCollection().addFigure((Figure)polygonFigure);
            }
            this.regionSelectionInteractor.updateProperties(this.defaultShape.getBounds2D());
            this.mustInitFigureEditor = false;
        }
    }

    private static void ensureExistingProperty(BindingContext bindingContext, String propertyName) {
        Assert.argument((bindingContext.getPropertySet().getProperty(propertyName) != null ? 1 : 0) != 0, (String)("bindingContext must contain a property named " + propertyName));
    }

    private static void setDefaultValues(BindingContext bindingContext) {
        bindingContext.getPropertySet().setValue(NORTH_BOUND, (Object)75.0);
        bindingContext.getPropertySet().setValue(WEST_BOUND, (Object)-15.0);
        bindingContext.getPropertySet().setValue(SOUTH_BOUND, (Object)35.0);
        bindingContext.getPropertySet().setValue(EAST_BOUND, (Object)30.0);
    }

    static boolean geoBoundsAreValid(Double northBound, Double eastBound, Double southBound, Double westBound) {
        return northBound != null && eastBound != null && southBound != null && westBound != null && northBound > southBound && eastBound > westBound && RegionSelectableWorldMapPane.isInValidLatitudeRange(northBound) && RegionSelectableWorldMapPane.isInValidLatitudeRange(southBound) && RegionSelectableWorldMapPane.isInValidLongitudeRange(eastBound) && RegionSelectableWorldMapPane.isInValidLongitudeRange(westBound);
    }

    static void correctBoundsIfNecessary(Rectangle2D newFigureShape) {
        double minX = newFigureShape.getMinX();
        double minY = newFigureShape.getMinY();
        double maxX = newFigureShape.getMaxX();
        double maxY = newFigureShape.getMaxY();
        minX = Math.min(maxX, Math.min(180.0, Math.max(-180.0, minX)));
        minY = Math.min(maxY, Math.min(90.0, Math.max(-90.0, minY)));
        maxX = Math.max(minX, Math.min(180.0, Math.max(-180.0, maxX)));
        maxY = Math.max(minY, Math.min(90.0, Math.max(-90.0, maxY)));
        minX = Math.min(maxX, Math.min(180.0, Math.max(-180.0, minX)));
        minY = Math.min(maxY, Math.min(90.0, Math.max(-90.0, minY)));
        if (newFigureShape.getMinX() != minX || newFigureShape.getMinY() != minY || newFigureShape.getMaxX() != maxX || newFigureShape.getMaxY() != maxY) {
            double width = maxX - minX;
            double height = maxY - minY;
            newFigureShape.setRect(minX, minY, width - 1.0E-12, height - 1.0E-12);
        }
    }

    private static boolean isInValidLongitudeRange(Double longitude) {
        return longitude <= 180.0 && longitude >= -180.0;
    }

    private static boolean isInValidLatitudeRange(Double latitude) {
        return latitude <= 90.0 && latitude >= -90.0;
    }

    private DefaultFigureStyle createFigureStyle(DefaultFigureStyle figureStyle) {
        figureStyle.setFillColor(new Color(255, 200, 200));
        figureStyle.setFillOpacity(0.2);
        figureStyle.setStrokeColor(new Color(200, 0, 0));
        figureStyle.setStrokeWidth(2.0);
        return figureStyle;
    }

    private void updateRectangles() {
        AffineTransform modelToView = this.worldMapPane.getLayerCanvas().getViewport().getModelToViewTransform();
        this.selectionRectangle = modelToView.createTransformedShape(this.getFirstFigure().getBounds()).getBounds2D();
        this.movableRectangle.setRect(this.selectionRectangle);
        this.cursorChanger.updateRectanglesForDragCursor();
    }

    private Figure getFirstFigure() {
        return this.getFigureEditor().getFigureCollection().getFigure(0);
    }

    private void handleZoom() {
        FigureCollection figureCollection = this.getFigureEditor().getFigureCollection();
        if (figureCollection.getFigureCount() == 0) {
            return;
        }
        Rectangle2D modelBounds = figureCollection.getFigure(0).getBounds();
        AffineTransform modelToViewTransform = this.worldMapPane.getLayerCanvas().getViewport().getModelToViewTransform();
        Shape transformedShape = modelToViewTransform.createTransformedShape(modelBounds);
        this.movableRectangle.setRect(transformedShape.getBounds2D());
        this.selectionRectangle.setRect(this.movableRectangle);
        this.cursorChanger.updateRectanglesForDragCursor();
    }

    private void initGeometries(Product selectedProduct) {
        GeoPos lowerRightGeoPos;
        GeoPos upperLeftGeoPos;
        if (selectedProduct != null) {
            PixelPos upperLeftPixel = new PixelPos(0.5, 0.5);
            PixelPos lowerRightPixel = new PixelPos((double)((float)selectedProduct.getSceneRasterWidth() - 0.5f), (double)((float)selectedProduct.getSceneRasterHeight() - 0.5f));
            GeoCoding geoCoding = selectedProduct.getSceneGeoCoding();
            upperLeftGeoPos = geoCoding.getGeoPos(upperLeftPixel, null);
            lowerRightGeoPos = geoCoding.getGeoPos(lowerRightPixel, null);
        } else {
            PropertySet propertySet = this.bindingContext.getPropertySet();
            Double northBound = (Double)propertySet.getValue(NORTH_BOUND);
            Double eastBound = (Double)propertySet.getValue(EAST_BOUND);
            Double southBound = (Double)propertySet.getValue(SOUTH_BOUND);
            Double westBound = (Double)propertySet.getValue(WEST_BOUND);
            upperLeftGeoPos = new GeoPos((double)northBound.floatValue(), (double)westBound.floatValue());
            lowerRightGeoPos = new GeoPos((double)southBound.floatValue(), (double)eastBound.floatValue());
        }
        Viewport viewport = this.worldMapPane.getLayerCanvas().getViewport();
        AffineTransform modelToViewTransform = viewport.getModelToViewTransform();
        Point2D.Double lowerRight = this.modelToView(lowerRightGeoPos, modelToViewTransform);
        Point2D.Double upperLeft = this.modelToView(upperLeftGeoPos, modelToViewTransform);
        Rectangle2D.Double rectangularShape = new Rectangle2D.Double(upperLeft.x, upperLeft.y, lowerRight.x - upperLeft.x, lowerRight.y - upperLeft.y);
        this.selectionRectangle = this.createRectangle(rectangularShape);
        this.movableRectangle = this.createRectangle(rectangularShape);
        this.defaultRectangle = this.createRectangle(rectangularShape);
        this.cursorChanger.updateRectanglesForDragCursor();
        this.defaultShape = viewport.getViewToModelTransform().createTransformedShape(rectangularShape);
    }

    private Rectangle2D.Double createRectangle(Rectangle2D.Double rectangularShape) {
        return new Rectangle2D.Double(rectangularShape.getX(), rectangularShape.getY(), rectangularShape.getWidth(), rectangularShape.getHeight());
    }

    private Point2D.Double modelToView(GeoPos geoPos, AffineTransform modelToView) {
        Point2D.Double result = new Point2D.Double();
        modelToView.transform(new Point2D.Double(geoPos.getLon(), geoPos.getLat()), result);
        return result;
    }

    private class ResetAction
    extends AbstractAction {
        private ResetAction() {
            this.putValue("SwingLargeIconKey", UIUtils.loadImageIcon("icons/Undo24.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                RegionSelectableWorldMapPane.this.regionSelectionInteractor.reset();
            }
        }
    }

    private class RegionSelectionDecoratingPanSupport
    extends WorldMapPane.DefaultPanSupport {
        private Point p0;

        private RegionSelectionDecoratingPanSupport(LayerCanvas layerCanvas) {
            super(layerCanvas);
        }

        @Override
        public void panStarted(MouseEvent event) {
            super.panStarted(event);
            this.p0 = event.getPoint();
            Rectangle2D.Double intersectionRectangle = this.createIntersectionRectangle();
            if (intersectionRectangle.contains(event.getPoint())) {
                RegionSelectableWorldMapPane.this.regionSelectionInteractor.mousePressed(event);
            }
        }

        @Override
        public void performPan(MouseEvent event) {
            Rectangle2D.Double intersectionRectangle = this.createIntersectionRectangle();
            if (intersectionRectangle.contains(this.p0)) {
                RegionSelectableWorldMapPane.this.regionSelectionInteractor.mouseDragged(event);
            } else {
                super.performPan(event);
            }
        }

        @Override
        public void panStopped(MouseEvent event) {
            super.panStopped(event);
            RegionSelectableWorldMapPane.this.updateRectangles();
        }

        private Rectangle2D.Double createIntersectionRectangle() {
            return new Rectangle2D.Double(RegionSelectableWorldMapPane.this.selectionRectangle.getX() - 6.0, RegionSelectableWorldMapPane.this.selectionRectangle.getY() - 6.0, RegionSelectableWorldMapPane.this.selectionRectangle.getWidth() + 12.0, RegionSelectableWorldMapPane.this.selectionRectangle.getHeight() + 12.0);
        }
    }

    private class RegionSelectionInteractor
    extends ViewportInteractor {
        private static final int NO_LONGITUDE_BORDER = -3;
        private static final int NO_LATITUDE_BORDER = -2;
        private static final int BORDER_UNKNOWN = -1;
        private static final int NORTH_BORDER = 0;
        private static final int EAST_BORDER = 1;
        private static final int SOUTH_BORDER = 2;
        private static final int WEST_BORDER = 3;
        private Point point;
        private int rectangleLongitude;
        private int rectangleLatitude;

        private RegionSelectionInteractor() {
            PropertySet propertySet = RegionSelectableWorldMapPane.this.bindingContext.getPropertySet();
            propertySet.getProperty(RegionSelectableWorldMapPane.NORTH_BOUND).addPropertyChangeListener((PropertyChangeListener)new BoundsChangeListener(RegionSelectableWorldMapPane.NORTH_BOUND));
            propertySet.getProperty(RegionSelectableWorldMapPane.SOUTH_BOUND).addPropertyChangeListener((PropertyChangeListener)new BoundsChangeListener(RegionSelectableWorldMapPane.SOUTH_BOUND));
            propertySet.getProperty(RegionSelectableWorldMapPane.WEST_BOUND).addPropertyChangeListener((PropertyChangeListener)new BoundsChangeListener(RegionSelectableWorldMapPane.WEST_BOUND));
            propertySet.getProperty(RegionSelectableWorldMapPane.EAST_BOUND).addPropertyChangeListener((PropertyChangeListener)new BoundsChangeListener(RegionSelectableWorldMapPane.EAST_BOUND));
        }

        public void mousePressed(MouseEvent event) {
            this.point = event.getPoint();
            this.determineDraggedRectangleBorders(event);
        }

        private void determineDraggedRectangleBorders(MouseEvent e) {
            double x = e.getX();
            double y = e.getY();
            double x1 = RegionSelectableWorldMapPane.this.selectionRectangle.getX();
            double y1 = RegionSelectableWorldMapPane.this.selectionRectangle.getY();
            double x2 = x1 + RegionSelectableWorldMapPane.this.selectionRectangle.getWidth();
            double y2 = y1 + RegionSelectableWorldMapPane.this.selectionRectangle.getHeight();
            double dx1 = Math.abs(x1 - x);
            double dy1 = Math.abs(y1 - y);
            double dx2 = Math.abs(x2 - x);
            double dy2 = Math.abs(y2 - y);
            this.rectangleLongitude = -1;
            if (dx1 <= 6.0) {
                this.rectangleLongitude = 3;
            } else if (dx2 <= 6.0) {
                this.rectangleLongitude = 1;
            } else if (x >= x1 && x < x2) {
                this.rectangleLongitude = -3;
            }
            this.rectangleLatitude = -1;
            if (dy1 <= 6.0) {
                this.rectangleLatitude = 0;
            } else if (dy2 <= 6.0) {
                this.rectangleLatitude = 2;
            } else if (y > y1 && y < y2) {
                this.rectangleLatitude = -2;
            }
        }

        public void mouseDragged(MouseEvent event) {
            double dx = (double)event.getX() - this.point.getX();
            double dy = this.point.getY() - (double)event.getY();
            double xOfUpdatedRectangle = RegionSelectableWorldMapPane.this.selectionRectangle.getX();
            double yOfUpdatedRectangle = RegionSelectableWorldMapPane.this.selectionRectangle.getY();
            double widthOfUpdatedRectangle = RegionSelectableWorldMapPane.this.selectionRectangle.getWidth();
            double heightOfUpdatedRectangle = RegionSelectableWorldMapPane.this.selectionRectangle.getHeight();
            if (this.rectangleLongitude == -3 && this.rectangleLatitude == -2) {
                xOfUpdatedRectangle = RegionSelectableWorldMapPane.this.selectionRectangle.getX() + dx;
                yOfUpdatedRectangle = RegionSelectableWorldMapPane.this.selectionRectangle.getY() - dy;
            }
            if (this.rectangleLongitude == 3) {
                xOfUpdatedRectangle += dx;
                widthOfUpdatedRectangle -= dx;
            } else if (this.rectangleLongitude == 1) {
                widthOfUpdatedRectangle += dx;
            }
            if (this.rectangleLatitude == 0) {
                yOfUpdatedRectangle -= dy;
                heightOfUpdatedRectangle += dy;
            } else if (this.rectangleLatitude == 2) {
                heightOfUpdatedRectangle -= dy;
            }
            if (widthOfUpdatedRectangle > 2.0 && heightOfUpdatedRectangle > 2.0 && (RegionSelectableWorldMapPane.this.selectionRectangle.getX() != xOfUpdatedRectangle || RegionSelectableWorldMapPane.this.selectionRectangle.getY() != yOfUpdatedRectangle || RegionSelectableWorldMapPane.this.selectionRectangle.getWidth() != widthOfUpdatedRectangle || RegionSelectableWorldMapPane.this.selectionRectangle.getHeight() != heightOfUpdatedRectangle)) {
                this.setMovableRectangleInImageCoordinates(xOfUpdatedRectangle, yOfUpdatedRectangle, widthOfUpdatedRectangle, heightOfUpdatedRectangle);
                Shape newFigureShape = this.getViewToModelTransform(event).createTransformedShape(RegionSelectableWorldMapPane.this.movableRectangle);
                Rectangle2D modelRectangle = newFigureShape.getBounds2D();
                this.adaptToModelRectangle(modelRectangle);
            }
        }

        public void mouseReleased(MouseEvent event) {
            RegionSelectableWorldMapPane.this.selectionRectangle.setRect(RegionSelectableWorldMapPane.this.movableRectangle);
        }

        private void reset() {
            RegionSelectableWorldMapPane.this.selectionRectangle.setRect(RegionSelectableWorldMapPane.this.defaultRectangle);
            RegionSelectableWorldMapPane.this.movableRectangle.setRect(RegionSelectableWorldMapPane.this.defaultRectangle);
            RegionSelectableWorldMapPane.this.cursorChanger.updateRectanglesForDragCursor();
            this.updateProperties(RegionSelectableWorldMapPane.this.defaultShape.getBounds2D());
            this.updateFigure(RegionSelectableWorldMapPane.this.defaultShape.getBounds2D());
            RegionSelectableWorldMapPane.this.worldMapPane.zoomAll();
        }

        private void updateProperties(Rectangle2D modelRectangle) {
            if (!RegionSelectableWorldMapPane.this.updatingModelBounds.getAndSet(true)) {
                try {
                    PropertySet propertySet = RegionSelectableWorldMapPane.this.bindingContext.getPropertySet();
                    propertySet.getProperty(RegionSelectableWorldMapPane.NORTH_BOUND).setValue((Object)modelRectangle.getMaxY());
                    propertySet.getProperty(RegionSelectableWorldMapPane.SOUTH_BOUND).setValue((Object)modelRectangle.getMinY());
                    propertySet.getProperty(RegionSelectableWorldMapPane.WEST_BOUND).setValue((Object)modelRectangle.getMinX());
                    propertySet.getProperty(RegionSelectableWorldMapPane.EAST_BOUND).setValue((Object)modelRectangle.getMaxX());
                }
                catch (ValidationException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    RegionSelectableWorldMapPane.this.updatingModelBounds.set(false);
                }
            }
        }

        private void updateFigure(Rectangle2D modelRectangle) {
            DefaultFigureEditor figureEditor = RegionSelectableWorldMapPane.this.getFigureEditor();
            DefaultFigureStyle defaultFigureStyle = RegionSelectableWorldMapPane.this.createFigureStyle((DefaultFigureStyle)figureEditor.getDefaultPolygonStyle());
            ShapeFigure polygonFigure = figureEditor.getFigureFactory().createPolygonFigure((Shape)modelRectangle, (FigureStyle)defaultFigureStyle);
            if (polygonFigure != null) {
                figureEditor.getFigureCollection().removeAllFigures();
                figureEditor.getFigureCollection().addFigure((Figure)polygonFigure);
            }
        }

        private void setMovableRectangleInImageCoordinates(double x, double y, double width, double height) {
            RegionSelectableWorldMapPane.this.movableRectangle.setRect(x, y, width, height);
        }

        private void adaptToModelRectangle(Rectangle2D modelRectangle) {
            RegionSelectableWorldMapPane.correctBoundsIfNecessary(modelRectangle);
            if (modelRectangle.getWidth() != 0.0 && modelRectangle.getHeight() != 0.0 && !modelRectangle.equals(RegionSelectableWorldMapPane.this.getFirstFigure().getBounds())) {
                this.updateFigure(modelRectangle);
                this.updateProperties(modelRectangle);
            }
        }

        private class BoundsChangeListener
        implements PropertyChangeListener {
            private final String property;

            private BoundsChangeListener(String property) {
                this.property = property;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (RegionSelectableWorldMapPane.this.updatingModelBounds.get()) {
                    return;
                }
                PropertySet propertySet = RegionSelectableWorldMapPane.this.bindingContext.getPropertySet();
                Object westValue = propertySet.getProperty(RegionSelectableWorldMapPane.WEST_BOUND).getValue();
                Object southValue = propertySet.getProperty(RegionSelectableWorldMapPane.SOUTH_BOUND).getValue();
                Object eastValue = propertySet.getProperty(RegionSelectableWorldMapPane.EAST_BOUND).getValue();
                Object northValue = propertySet.getProperty(RegionSelectableWorldMapPane.NORTH_BOUND).getValue();
                if (westValue == null || southValue == null || eastValue == null || northValue == null) {
                    return;
                }
                Rectangle2D modelRectangle = RegionSelectableWorldMapPane.this.getFirstFigure().getBounds();
                double x = this.property.equals(RegionSelectableWorldMapPane.WEST_BOUND) ? Double.parseDouble(westValue.toString()) : modelRectangle.getX();
                double y = this.property.equals(RegionSelectableWorldMapPane.SOUTH_BOUND) ? Double.parseDouble(southValue.toString()) : modelRectangle.getY();
                double width = this.property.equals(RegionSelectableWorldMapPane.EAST_BOUND) || this.property.equals(RegionSelectableWorldMapPane.WEST_BOUND) ? Math.abs(Double.parseDouble(eastValue.toString()) - x) : modelRectangle.getWidth();
                double height = this.property.equals(RegionSelectableWorldMapPane.NORTH_BOUND) || this.property.equals(RegionSelectableWorldMapPane.SOUTH_BOUND) ? Math.abs(Double.parseDouble(northValue.toString()) - y) : modelRectangle.getHeight();
                modelRectangle.setRect(x, y, width, height);
                RegionSelectionInteractor.this.adaptToModelRectangle(modelRectangle);
                RegionSelectableWorldMapPane.this.updateRectangles();
            }
        }
    }

    private class SelectionOverlay
    extends BoundaryOverlay {
        SelectionOverlay(WorldMapPaneDataModel dataModel) {
            super(dataModel);
        }

        @Override
        protected void handleSelectedProduct(Rendering rendering, Product selectedProduct) {
            DefaultFigureEditor editor = RegionSelectableWorldMapPane.this.getFigureEditor();
            RegionSelectableWorldMapPane.this.initFigureEditor(editor, selectedProduct);
            editor.drawFigureCollection(rendering);
        }
    }

    private class FigureEditorAwareWorldMapPane
    extends WorldMapPane
    implements FigureEditorAware {
        private LayerCanvas.Overlay greyOverlay;

        private FigureEditorAwareWorldMapPane(WorldMapPaneDataModel dataModel, SelectionOverlay overlay) {
            super(dataModel, overlay);
            this.addZoomListener(() -> RegionSelectableWorldMapPane.this.handleZoom());
            this.greyOverlay = (canvas, rendering) -> {
                Graphics2D graphics = rendering.getGraphics();
                graphics.setPaint(new Color(200, 200, 200, 180));
                graphics.fillRect(0, 0, RegionSelectableWorldMapPane.this.worldMapPane.getWidth(), RegionSelectableWorldMapPane.this.worldMapPane.getHeight());
            };
        }

        public FigureEditor getFigureEditor() {
            RegionSelectableWorldMapPane.this.initFigureEditor(RegionSelectableWorldMapPane.this.figureEditor, null);
            return RegionSelectableWorldMapPane.this.figureEditor;
        }

        @Override
        protected Action[] getOverlayActions() {
            Action[] overlayActions = super.getOverlayActions();
            Action[] actions = new Action[overlayActions.length + 1];
            System.arraycopy(overlayActions, 0, actions, 0, overlayActions.length);
            actions[actions.length - 1] = new ResetAction();
            return actions;
        }

        @Override
        public void zoomToProduct(Product product) {
            if (product != null) {
                super.zoomToProduct(product);
            }
            Rectangle2D modelBounds = RegionSelectableWorldMapPane.this.getFirstFigure().getBounds();
            modelBounds.setFrame(modelBounds.getX() - 2.0, modelBounds.getY() - 2.0, modelBounds.getWidth() + 4.0, modelBounds.getHeight() + 4.0);
            this.getLayerCanvas().getViewport().zoom(modelBounds);
            RegionSelectableWorldMapPane.this.handleZoom();
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (enabled == this.isEnabled()) {
                return;
            }
            super.setEnabled(enabled);
            if (enabled) {
                RegionSelectableWorldMapPane.this.worldMapPane.getLayerCanvas().addMouseMotionListener((MouseMotionListener)RegionSelectableWorldMapPane.this.cursorChanger);
                RegionSelectableWorldMapPane.this.worldMapPane.getLayerCanvas().removeOverlay(this.greyOverlay);
                RegionSelectableWorldMapPane.this.worldMapPane.setPanSupport(RegionSelectableWorldMapPane.this.panSupport);
            } else {
                RegionSelectableWorldMapPane.this.worldMapPane.getLayerCanvas().removeMouseMotionListener((MouseMotionListener)RegionSelectableWorldMapPane.this.cursorChanger);
                RegionSelectableWorldMapPane.this.worldMapPane.getLayerCanvas().addOverlay(this.greyOverlay);
                RegionSelectableWorldMapPane.this.worldMapPane.setPanSupport(new NullPanSupport());
            }
        }

        private class NullPanSupport
        implements WorldMapPane.PanSupport {
            private NullPanSupport() {
            }

            @Override
            public void panStarted(MouseEvent event) {
            }

            @Override
            public void performPan(MouseEvent event) {
            }

            @Override
            public void panStopped(MouseEvent event) {
            }
        }
    }

    private class CursorChanger
    implements MouseMotionListener {
        private final String DEFAULT = "default";
        private final String MOVE = "move";
        private final String NORTH = "north";
        private final String SOUTH = "south";
        private final String WEST = "west";
        private final String EAST = "east";
        private final String NORTH_WEST = "northWest";
        private final String NORTH_EAST = "northEast";
        private final String SOUTH_WEST = "southWest";
        private final String SOUTH_EAST = "southEast";
        private Map<String, Cursor> cursorMap = new HashMap<String, Cursor>();
        private Map<String, Rectangle2D.Double> rectangleMap;

        private CursorChanger() {
            this.cursorMap.put("default", Cursor.getPredefinedCursor(0));
            this.cursorMap.put("move", Cursor.getPredefinedCursor(13));
            this.cursorMap.put("north", Cursor.getPredefinedCursor(8));
            this.cursorMap.put("south", Cursor.getPredefinedCursor(9));
            this.cursorMap.put("west", Cursor.getPredefinedCursor(10));
            this.cursorMap.put("east", Cursor.getPredefinedCursor(11));
            this.cursorMap.put("northWest", Cursor.getPredefinedCursor(6));
            this.cursorMap.put("northEast", Cursor.getPredefinedCursor(7));
            this.cursorMap.put("southWest", Cursor.getPredefinedCursor(4));
            this.cursorMap.put("southEast", Cursor.getPredefinedCursor(5));
            this.rectangleMap = new HashMap<String, Rectangle2D.Double>();
            this.rectangleMap.put("default", new Rectangle2D.Double());
            this.rectangleMap.put("move", new Rectangle2D.Double());
            this.rectangleMap.put("north", new Rectangle2D.Double());
            this.rectangleMap.put("south", new Rectangle2D.Double());
            this.rectangleMap.put("west", new Rectangle2D.Double());
            this.rectangleMap.put("east", new Rectangle2D.Double());
            this.rectangleMap.put("northEast", new Rectangle2D.Double());
            this.rectangleMap.put("northWest", new Rectangle2D.Double());
            this.rectangleMap.put("southEast", new Rectangle2D.Double());
            this.rectangleMap.put("southWest", new Rectangle2D.Double());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.updateRectanglesForDragCursor();
            this.updateCursor(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateCursor(e);
        }

        private void updateCursor(MouseEvent e) {
            boolean cursorOutsideOfSelectionRectangle;
            boolean bl = cursorOutsideOfSelectionRectangle = !this.rectangleMap.get("default").contains(e.getPoint()) && RegionSelectableWorldMapPane.this.worldMapPane.getCursor() != this.cursorMap.get("default");
            if (cursorOutsideOfSelectionRectangle) {
                RegionSelectableWorldMapPane.this.worldMapPane.setCursor(this.cursorMap.get("default"));
            } else {
                String region;
                boolean cursorIsSet;
                String[] regionIdentifiers;
                String[] stringArray = regionIdentifiers = new String[]{"move", "north", "south", "west", "east", "northWest", "northEast", "southWest", "southEast"};
                int n = stringArray.length;
                for (int i = 0; i < n && !(cursorIsSet = this.setCursorWhenContained(this.cursorMap.get(region = stringArray[i]), this.rectangleMap.get(region), e.getPoint())); ++i) {
                }
            }
        }

        private boolean setCursorWhenContained(Cursor cursor, Rectangle2D.Double rectangle, Point point) {
            if (rectangle.contains(point)) {
                if (RegionSelectableWorldMapPane.this.worldMapPane.getCursor() != cursor) {
                    RegionSelectableWorldMapPane.this.worldMapPane.setCursor(cursor);
                }
                return true;
            }
            return false;
        }

        private void updateRectanglesForDragCursor() {
            Rectangle2D.Double rectangleForDragCursor = new Rectangle2D.Double(RegionSelectableWorldMapPane.this.movableRectangle.getX() + 6.0, RegionSelectableWorldMapPane.this.movableRectangle.getY() + 6.0, RegionSelectableWorldMapPane.this.movableRectangle.getWidth() - 12.0, RegionSelectableWorldMapPane.this.movableRectangle.getHeight() - 12.0);
            this.rectangleMap.get("move").setRect(rectangleForDragCursor);
            double x = rectangleForDragCursor.getX();
            double y = rectangleForDragCursor.getY();
            double width = rectangleForDragCursor.getWidth();
            double height = rectangleForDragCursor.getHeight();
            this.setRectangle("default", x - 12.0, y - 12.0, width + 24.0, height + 24.0);
            this.setRectangle("north", x, y - 12.0, width, 12.0);
            this.setRectangle("south", x, y + height, width, 12.0);
            this.setRectangle("west", x - 12.0, y, 12.0, height);
            this.setRectangle("east", x + width, y, 12.0, height);
            this.setRectangle("northWest", x - 12.0, y - 12.0, 12.0, 12.0);
            this.setRectangle("northEast", x + width, y - 12.0, 12.0, 12.0);
            this.setRectangle("southWest", x - 12.0, y + height, 12.0, 12.0);
            this.setRectangle("southEast", x + width, y + height, 12.0, 12.0);
        }

        private void setRectangle(String rectangleIdentifier, double x, double y, double w, double h) {
            this.rectangleMap.get(rectangleIdentifier).setRect(x, y, w, h);
        }
    }
}

