/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.esa.snap.core.dataio.ProductSubsetBuilder;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeList;
import org.esa.snap.core.datamodel.ProductNodeNameValidator;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.param.ParamChangeEvent;
import org.esa.snap.core.param.ParamChangeListener;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSubsetDialog;

public class NewProductDialog
extends ModalDialog {
    private static final String DEFAULT_NUMBER_TEXT = "####";
    private static final String DEFAULT_LATLON_TEXT = "##\u00b0";
    private static final String COPY_ALL_COMMAND = "all";
    private static final String COPY_GEOCODING_COMMAND = "geo";
    private static final String COPY_SUBSET_COMMAND = "sub";
    private static int numNewProducts = 0;
    private Parameter paramNewName;
    private Parameter paramNewDesc;
    private Parameter paramSourceProduct;
    private final ProductNodeList sourceProducts;
    private final Window parent;
    private String prefix;
    private Exception exception;
    private boolean sourceProductOwner;
    private ProductSubsetDef subsetDef;
    private Product editProduct;
    private Product resultProduct;
    private JButton subsetButton;
    private JRadioButton copyAllRButton;
    private JRadioButton geocodingRButton;
    private JRadioButton subsetRButton;
    private JLabel labelWidthInfo;
    private JLabel labelHeightInfo;
    private JLabel labelCenterLatInfo;
    private JLabel labelCenterLonInfo;
    private int selectedProductIndex;

    public NewProductDialog(Window parent, ProductNodeList<Product> sourceProducts, int selectedSourceIndex, boolean sourceProductOwner) {
        this(parent, sourceProducts, selectedSourceIndex, sourceProductOwner, "subset");
    }

    public NewProductDialog(Window parent, ProductNodeList<Product> sourceProducts, int selectedSourceIndex, boolean sourceProductOwner, String prefix) {
        super(parent, "New Product", 33, null);
        Guardian.assertNotNull((String)"sourceProducts", sourceProducts);
        Guardian.assertGreaterThan((String)"sourceProducts.size()", (long)sourceProducts.size(), (long)0L);
        this.sourceProducts = sourceProducts;
        this.selectedProductIndex = selectedSourceIndex;
        this.parent = parent;
        this.prefix = prefix;
        this.sourceProductOwner = sourceProductOwner;
    }

    @Override
    public int show() {
        this.createParameter();
        this.createUI();
        this.updateUI();
        return super.show();
    }

    public void setSubsetDef(ProductSubsetDef subsetDef) {
        this.subsetDef = subsetDef;
    }

    public boolean isSourceProductOwner() {
        return this.sourceProductOwner;
    }

    public Product getSourceProduct() {
        String displayName = this.paramSourceProduct.getValueAsText();
        return (Product)this.sourceProducts.getByDisplayName(displayName);
    }

    public Product getResultProduct() {
        return this.resultProduct;
    }

    @Override
    protected void onCancel() {
        super.onCancel();
        this.resultProduct = null;
    }

    @Override
    protected void onOK() {
        super.onOK();
        String prodName = this.paramNewName.getValueAsText();
        String prodDesc = this.paramNewDesc.getValueAsText();
        Product sourceProduct = this.getSourceProduct();
        this.resultProduct = null;
        try {
            if (this.geocodingRButton.isSelected()) {
                ProductSubsetDef def = new ProductSubsetDef();
                def.addNodeName("latitude");
                def.addNodeName("longitude");
                def.addNodeName("history");
                this.resultProduct = ProductSubsetBuilder.createProductSubset((Product)sourceProduct, (boolean)this.sourceProductOwner, (ProductSubsetDef)def, (String)prodName, (String)prodDesc);
                TiePointGrid latGrid = this.resultProduct.getTiePointGrid("latitude");
                TiePointGrid lonGrid = this.resultProduct.getTiePointGrid("longitude");
                if (latGrid != null && lonGrid != null) {
                    this.resultProduct.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(latGrid, lonGrid, sourceProduct.getSceneGeoCoding().getGeoCRS()));
                }
            } else {
                this.resultProduct = this.subsetDef != null && this.subsetRButton.isSelected() ? ProductSubsetBuilder.createProductSubset((Product)sourceProduct, (boolean)this.sourceProductOwner, (ProductSubsetDef)this.subsetDef, (String)prodName, (String)prodDesc) : ProductSubsetBuilder.createProductSubset((Product)sourceProduct, (boolean)this.sourceProductOwner, null, (String)prodName, (String)prodDesc);
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    protected boolean verifyUserInput() {
        boolean b = super.verifyUserInput();
        String name = this.paramNewName.getValueAsText();
        boolean bName = name != null && name.length() > 0;
        boolean subset = true;
        if (this.subsetRButton.isSelected() && this.subsetDef == null) {
            subset = false;
            this.showErrorDialog("Please define a valid spatial or spectral subset.");
        }
        return b && bName && subset;
    }

    private void createParameter() {
        boolean enableSourceProduct;
        String prodDesc;
        String prodName;
        String[] valueSet;
        ++numNewProducts;
        if (this.editProduct == null) {
            valueSet = this.sourceProducts.getDisplayNames();
            Product product = (Product)this.sourceProducts.getAt(this.selectedProductIndex);
            prodName = this.createNewProductName(valueSet.length > 0 ? product.getName() : "");
            prodDesc = "";
            enableSourceProduct = true;
        } else {
            prodName = this.editProduct.getName();
            prodDesc = this.editProduct.getDescription();
            valueSet = new String[]{prodName};
            enableSourceProduct = false;
        }
        this.paramNewName = new Parameter("productName", (Object)prodName);
        this.paramNewName.getProperties().setLabel("Name");
        this.paramNewName.getProperties().setNullValueAllowed(false);
        this.paramNewName.getProperties().setValidatorClass(ProductNodeNameValidator.class);
        this.paramNewDesc = new Parameter("productDesc", (Object)prodDesc);
        this.paramNewDesc.getProperties().setLabel("Description");
        this.paramNewDesc.getProperties().setNullValueAllowed(false);
        this.paramSourceProduct = new Parameter("sourceProduct", (Object)valueSet[this.selectedProductIndex]);
        this.paramSourceProduct.getProperties().setValueSet(valueSet);
        this.paramSourceProduct.getProperties().setLabel("Derive from Product");
        this.paramSourceProduct.getProperties().setValueSetBound(true);
        this.paramSourceProduct.setUIEnabled(enableSourceProduct);
        this.paramSourceProduct.addParamChangeListener(new ParamChangeListener(){

            public void parameterValueChanged(ParamChangeEvent event) {
                NewProductDialog.this.subsetDef = null;
                NewProductDialog.this.updateUI();
                NewProductDialog.this.setNewProductName();
            }
        });
    }

    private void createUI() {
        this.createButtonsAndLabels();
        int line = 0;
        JPanel dialogPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
        ++line;
        gbc.gridy = line++;
        GridBagUtils.addToPanel(dialogPane, this.paramNewName.getEditor().getLabelComponent(), gbc, "fill=BOTH, weightx=0, insets.top=3");
        GridBagUtils.addToPanel(dialogPane, this.paramNewName.getEditor().getComponent(), gbc, "weightx=1, gridwidth=3");
        gbc.gridy = line++;
        GridBagUtils.addToPanel(dialogPane, this.paramNewDesc.getEditor().getLabelComponent(), gbc, "weightx=0, gridwidth=1");
        GridBagUtils.addToPanel(dialogPane, this.paramNewDesc.getEditor().getComponent(), gbc, "weightx=1, gridwidth=3");
        gbc.gridy = line++;
        GridBagUtils.addToPanel(dialogPane, this.paramSourceProduct.getEditor().getLabelComponent(), gbc, "fill=NONE, gridwidth=4, insets.top=15");
        gbc.gridy = line++;
        GridBagUtils.addToPanel(dialogPane, this.paramSourceProduct.getEditor().getComponent(), gbc, "fill=HORIZONTAL, insets.top=3");
        gbc.gridy = line++;
        JPanel radioPanel = new JPanel(new BorderLayout());
        radioPanel.add((Component)this.copyAllRButton, "West");
        radioPanel.add(this.geocodingRButton);
        GridBagUtils.addToPanel(dialogPane, radioPanel, gbc, "fill=NONE, gridwidth=2");
        GridBagUtils.addToPanel(dialogPane, this.subsetRButton, gbc, "gridwidth=1, weightx=300, anchor=EAST");
        GridBagUtils.addToPanel(dialogPane, this.subsetButton, gbc, "fill=NONE, weightx=1, anchor=EAST");
        gbc.gridy = line;
        GridBagUtils.addToPanel(dialogPane, this.createInfoPanel(), gbc, "fill=BOTH, anchor=WEST, insets.top=10, gridwidth=4");
        this.setContent(dialogPane);
        JComponent editorComponent = this.paramNewName.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextComponent) {
            JTextComponent tf = (JTextComponent)editorComponent;
            tf.selectAll();
            tf.requestFocus();
        }
    }

    private JPanel createInfoPanel() {
        JPanel infoPanel = GridBagUtils.createDefaultEmptyBorderPanel();
        infoPanel.setBorder(UIUtils.createGroupBorder("Output Product Information"));
        GridBagConstraints gbc2 = GridBagUtils.createDefaultConstraints();
        GridBagUtils.addToPanel(infoPanel, new JLabel("Scene Width:"), gbc2);
        GridBagUtils.addToPanel(infoPanel, this.labelWidthInfo, gbc2);
        GridBagUtils.addToPanel(infoPanel, new JLabel("pixel"), gbc2, "weightx=1");
        GridBagUtils.addToPanel(infoPanel, new JLabel("Scene Height:"), gbc2, "gridy=1, weightx=0");
        GridBagUtils.addToPanel(infoPanel, this.labelHeightInfo, gbc2);
        GridBagUtils.addToPanel(infoPanel, new JLabel("pixel"), gbc2, "weightx=1");
        GridBagUtils.addToPanel(infoPanel, new JLabel("Center Latitude:"), gbc2, "gridy=2, weightx=0");
        GridBagUtils.addToPanel(infoPanel, this.labelCenterLatInfo, gbc2, "weightx=1, gridwidth=2");
        GridBagUtils.addToPanel(infoPanel, new JLabel("Center Longitude:"), gbc2, "gridy=3, weightx=0, gridwidth=1");
        GridBagUtils.addToPanel(infoPanel, this.labelCenterLonInfo, gbc2, "weightx=1, gridwidth=2");
        return infoPanel;
    }

    private void createButtonsAndLabels() {
        this.copyAllRButton = new JRadioButton("Copy");
        this.geocodingRButton = new JRadioButton("Use Geocoding Only");
        this.subsetRButton = new JRadioButton("Use Subset");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.copyAllRButton);
        buttonGroup.add(this.geocodingRButton);
        buttonGroup.add(this.subsetRButton);
        this.copyAllRButton.setActionCommand(COPY_ALL_COMMAND);
        this.geocodingRButton.setActionCommand(COPY_GEOCODING_COMMAND);
        this.subsetRButton.setActionCommand(COPY_SUBSET_COMMAND);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewProductDialog.this.updateUI();
            }
        };
        this.copyAllRButton.addActionListener(listener);
        this.geocodingRButton.addActionListener(listener);
        this.subsetRButton.addActionListener(listener);
        if (this.subsetDef != null) {
            this.subsetRButton.setSelected(true);
        } else {
            this.geocodingRButton.setSelected(true);
        }
        this.subsetButton = new JButton("Subset...");
        this.subsetButton.addActionListener(this.createSubsetButtonListener());
        this.labelWidthInfo = new JLabel(DEFAULT_NUMBER_TEXT);
        this.labelHeightInfo = new JLabel(DEFAULT_NUMBER_TEXT);
        this.labelCenterLatInfo = new JLabel(DEFAULT_LATLON_TEXT);
        this.labelCenterLonInfo = new JLabel(DEFAULT_LATLON_TEXT);
    }

    private void updateUI() {
        Product product = this.getSourceProduct();
        if (this.subsetDef == null) {
            this.subsetButton.setText("Define subset ...");
            if (product != null) {
                int width = product.getSceneRasterWidth();
                int height = product.getSceneRasterHeight();
                this.labelWidthInfo.setText("" + width);
                this.labelHeightInfo.setText("" + height);
                GeoCoding geoCoding = product.getSceneGeoCoding();
                if (geoCoding != null) {
                    GeoPos pos = geoCoding.getGeoPos(new PixelPos((double)(0.5f * (float)width + 0.5f), (double)(0.5f * (float)height + 0.5f)), null);
                    this.labelCenterLatInfo.setText(pos.getLatString());
                    this.labelCenterLonInfo.setText(pos.getLonString());
                } else {
                    this.labelCenterLatInfo.setText(DEFAULT_LATLON_TEXT);
                    this.labelCenterLonInfo.setText(DEFAULT_LATLON_TEXT);
                }
            } else {
                this.labelWidthInfo.setText(DEFAULT_NUMBER_TEXT);
                this.labelHeightInfo.setText(DEFAULT_NUMBER_TEXT);
                this.labelCenterLatInfo.setText(DEFAULT_LATLON_TEXT);
                this.labelCenterLonInfo.setText(DEFAULT_LATLON_TEXT);
            }
        } else {
            this.subsetButton.setText("Edit Subset...");
            Rectangle region = this.subsetDef.getRegion();
            int subSamplingX = this.subsetDef.getSubSamplingX();
            int subSamplingY = this.subsetDef.getSubSamplingY();
            this.labelWidthInfo.setText("" + ((region.width - 1) / subSamplingX + 1));
            this.labelHeightInfo.setText("" + ((region.height - 1) / subSamplingY + 1));
            if (product == null) {
                this.labelCenterLatInfo.setText(DEFAULT_LATLON_TEXT);
                this.labelCenterLonInfo.setText(DEFAULT_LATLON_TEXT);
            } else {
                GeoCoding geoCoding = product.getSceneGeoCoding();
                if (geoCoding == null) {
                    this.labelCenterLatInfo.setText(DEFAULT_LATLON_TEXT);
                    this.labelCenterLonInfo.setText(DEFAULT_LATLON_TEXT);
                } else {
                    float centerX = 0.5f * (float)region.width + (float)region.x;
                    float centerY = 0.5f * (float)region.height + (float)region.y;
                    PixelPos centerPoint = new PixelPos((double)(centerX + 0.5f), (double)(centerY + 0.5f));
                    GeoPos pos = geoCoding.getGeoPos(centerPoint, null);
                    this.labelCenterLatInfo.setText(pos.getLatString());
                    this.labelCenterLonInfo.setText(pos.getLonString());
                }
            }
        }
        boolean geocodingAvailable = product != null && product.getSceneGeoCoding() != null;
        this.geocodingRButton.setEnabled(geocodingAvailable);
        if (this.geocodingRButton.isSelected() && !geocodingAvailable) {
            this.subsetRButton.setSelected(true);
        }
        this.subsetButton.setEnabled(this.subsetRButton.isSelected());
    }

    private ActionListener createSubsetButtonListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product product = NewProductDialog.this.getSourceProduct();
                if (product == null) {
                    return;
                }
                ProductSubsetDialog dialog = new ProductSubsetDialog(NewProductDialog.this.parent, product, NewProductDialog.this.subsetDef);
                if (dialog.show() == 1) {
                    NewProductDialog.this.subsetDef = dialog.getProductSubsetDef().isEntireProductSelected() ? null : dialog.getProductSubsetDef();
                }
                NewProductDialog.this.updateUI();
            }
        };
    }

    private boolean hasPrefix() {
        return this.prefix != null && this.prefix.length() > 1;
    }

    private void setNewProductName() {
        String newProductName = this.createNewProductName(this.getSourceProduct().getName());
        this.paramNewName.setValue((Object)newProductName, null);
    }

    private String createNewProductName(String sourceProductName) {
        String newNameBase = "";
        if (sourceProductName != null && sourceProductName.length() > 0) {
            newNameBase = FileUtils.exchangeExtension((String)sourceProductName, (String)"");
        }
        String newNamePrefix = "product";
        if (this.hasPrefix()) {
            newNamePrefix = this.prefix;
        }
        String newProductName = newNameBase.length() > 0 ? newNamePrefix + "_" + numNewProducts + "_" + newNameBase : newNamePrefix + "_" + numNewProducts;
        return newProductName;
    }
}

