/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.GridBagConstraints;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeNameValidator;
import org.esa.snap.core.param.ParamProperties;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;

public class NewBandDialog
extends ModalDialog {
    private Parameter _paramName;
    private Parameter _paramDesc;
    private Parameter _paramUnit;
    private Parameter _paramDataType;
    private Product _currentProduct;
    private static int _numNewBands = 0;

    public NewBandDialog(Window parent, Product product) {
        super(parent, "New Band", 33, null);
        Guardian.assertNotNull((String)"product", (Object)product);
        this._currentProduct = product;
        this.createParameter();
        this.createUI();
    }

    public String getNewBandsName() {
        return this._paramName.getValueAsText();
    }

    public String getNewBandsDesc() {
        return this._paramDesc.getValueAsText();
    }

    public String getNewBandsUnit() {
        return this._paramUnit.getValueAsText();
    }

    public int getNewBandsDataType() {
        return ProductData.getType((String)this._paramDataType.getValueAsText());
    }

    @Override
    protected boolean verifyUserInput() {
        String name = this._paramName.getValueAsText();
        if (name == null || name.length() == 0) {
            this.showWarningDialog("The field '" + this._paramName.getProperties().getLabel() + "' must not be empty");
            return false;
        }
        if (StringUtils.contains((String[])this._currentProduct.getBandNames(), (String)name)) {
            this.showErrorDialog("A band with the name '" + name + "' already exists.\nPlease choose a another one.");
            return false;
        }
        return super.verifyUserInput();
    }

    private void createParameter() {
        ParamProperties paramProps = new ParamProperties(String.class, (Object)("new_band_" + ++_numNewBands));
        paramProps.setLabel("Name");
        paramProps.setDescription("The name for the new band.");
        paramProps.setNullValueAllowed(false);
        paramProps.setValidatorClass(ProductNodeNameValidator.class);
        this._paramName = new Parameter("bandName", paramProps);
        paramProps = new ParamProperties(String.class, (Object)"");
        paramProps.setLabel("Description");
        paramProps.setDescription("The description for the new band.");
        paramProps.setNullValueAllowed(true);
        this._paramDesc = new Parameter("bandDesc", paramProps);
        paramProps = new ParamProperties(String.class, (Object)"");
        paramProps.setLabel("Unit");
        paramProps.setDescription("The physical unit for the new band.");
        paramProps.setNullValueAllowed(true);
        this._paramUnit = new Parameter("bandUnit", paramProps);
        paramProps = new ParamProperties(String.class, (Object)"float32", new String[]{"float32"});
        paramProps.setLabel("Data type");
        paramProps.setDescription("The data type for the new band.");
        paramProps.setValueSetBound(true);
        this._paramDataType = new Parameter("bandDataType", paramProps);
    }

    private void createUI() {
        JPanel dialogPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
        int line = 0;
        GridBagUtils.addToPanel(dialogPane, this._paramName.getEditor().getLabelComponent(), gbc, "fill=BOTH, weightx=1, insets.top=3");
        GridBagUtils.addToPanel(dialogPane, this._paramName.getEditor().getComponent(), gbc);
        GridBagUtils.addToPanel(dialogPane, this._paramDesc.getEditor().getLabelComponent(), gbc, "gridy=" + ++line);
        GridBagUtils.addToPanel(dialogPane, this._paramDesc.getEditor().getComponent(), gbc);
        GridBagUtils.addToPanel(dialogPane, this._paramUnit.getEditor().getLabelComponent(), gbc, "gridy=" + ++line);
        GridBagUtils.addToPanel(dialogPane, this._paramUnit.getEditor().getComponent(), gbc);
        GridBagUtils.addToPanel(dialogPane, this._paramDataType.getEditor().getLabelComponent(), gbc, "gridy=" + ++line);
        GridBagUtils.addToPanel(dialogPane, this._paramDataType.getEditor().getComponent(), gbc);
        this._paramDataType.setUIEnabled(false);
        GridBagUtils.addToPanel(dialogPane, this.createInfoPanel(), gbc, "gridy=" + ++line + ", insets.top=10, gridwidth=2");
        this.setContent(dialogPane);
        JComponent editorComponent = this._paramName.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)editorComponent;
            tc.selectAll();
            tc.requestFocus();
        }
    }

    private JPanel createInfoPanel() {
        JLabel parentProductLabel = new JLabel(this._currentProduct.getDisplayName());
        JLabel widthValueLabel = new JLabel(this._currentProduct.getSceneRasterWidth() + " pixel");
        JLabel heightValueLabel = new JLabel(this._currentProduct.getSceneRasterHeight() + " pixel");
        JLabel centerValueLatLabel = new JLabel("##\u00b0");
        JLabel centerValueLonLabel = new JLabel("##\u00b0");
        GeoCoding geoCoding = this._currentProduct.getSceneGeoCoding();
        if (geoCoding != null) {
            float centerX = 0.5f * (float)this._currentProduct.getSceneRasterWidth();
            float centerY = 0.5f * (float)this._currentProduct.getSceneRasterHeight();
            GeoPos pos = geoCoding.getGeoPos(new PixelPos((double)(centerX + 0.5f), (double)(centerY + 0.5f)), null);
            centerValueLatLabel.setText(pos.getLatString());
            centerValueLonLabel.setText(pos.getLonString());
        }
        JPanel infoPanel = GridBagUtils.createDefaultEmptyBorderPanel();
        infoPanel.setBorder(UIUtils.createGroupBorder("Band Info"));
        int line = 0;
        GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
        GridBagUtils.addToPanel(infoPanel, new JLabel("Parent Product:"), gbc, "weightx=0, gridy=" + ++line);
        GridBagUtils.addToPanel(infoPanel, parentProductLabel, gbc, "weightx=1");
        GridBagUtils.addToPanel(infoPanel, new JLabel("Raster Width:"), gbc, "weightx=0, gridy=" + ++line);
        GridBagUtils.addToPanel(infoPanel, widthValueLabel, gbc, "weightx=1");
        GridBagUtils.addToPanel(infoPanel, new JLabel("Raster Height:"), gbc, "weightx=0, gridy=" + ++line);
        GridBagUtils.addToPanel(infoPanel, heightValueLabel, gbc, "weightx=1");
        GridBagUtils.addToPanel(infoPanel, new JLabel("Center Latitude:"), gbc, "weightx=0, gridy=" + ++line);
        GridBagUtils.addToPanel(infoPanel, centerValueLatLabel, gbc, "weightx=1");
        GridBagUtils.addToPanel(infoPanel, new JLabel("Center Longitude:"), gbc, "weightx=0, gridy=" + ++line);
        GridBagUtils.addToPanel(infoPanel, centerValueLonLabel, gbc, "weightx=1");
        return infoPanel;
    }
}

