/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.swing.binding.BindingContext;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JidePopupMenu;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.util.math.Histogram;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.ui.ImageInfoEditorModel;
import org.esa.snap.ui.color.ColorChooserPanel;

public abstract class ImageInfoEditor
extends JPanel {
    public static final String PROPERTY_NAME_MODEL = "model";
    public static final String NO_DISPLAY_INFO_TEXT = "No information available.";
    public static final String FONT_NAME = "Verdana";
    public static final int FONT_SIZE = 9;
    public static final int INVALID_INDEX = -1;
    public static final int PALETTE_HEIGHT = 16;
    public static final int SLIDER_WIDTH = 12;
    public static final int SLIDER_HEIGHT = 10;
    public static final int SLIDER_VALUES_AREA_HEIGHT = 50;
    public static final int HOR_BORDER_SIZE = 10;
    public static final int VER_BORDER_SIZE = 4;
    public static final int PREF_HISTO_WIDTH = 256;
    public static final int PREF_HISTO_HEIGHT = 196;
    public static final Dimension PREF_COMPONENT_SIZE = new Dimension(276, 246);
    public static final BasicStroke STROKE_1 = new BasicStroke(1.0f);
    public static final BasicStroke STROKE_2 = new BasicStroke(2.0f);
    public static final BasicStroke DASHED_STROKE = new BasicStroke(0.75f, 2, 0, 1.0f, new float[]{5.0f}, 0.0f);
    private ImageInfoEditorModel model;
    private Font labelFont = ImageInfoEditor.createLabelFont();
    private final Shape sliderShape = ImageInfoEditor.createSliderShape();
    private int sliderTextBaseLineY;
    private final Rectangle sliderBaseLineRect = new Rectangle();
    private final Rectangle paletteRect = new Rectangle();
    private final Rectangle histoRect = new Rectangle();
    private double roundFactor;
    private final InternalMouseListener internalMouseListener = new InternalMouseListener();
    private double[] factors;
    private Color[] palette;
    private ModelCL modelCL = new ModelCL();
    private JidePopup popup;
    private BufferedImage paletteBackgound;
    private boolean logScaled = false;

    public ImageInfoEditor() {
        this.addChangeListener(new RepaintCL());
    }

    public final ImageInfoEditorModel getModel() {
        return this.model;
    }

    public final void setModel(ImageInfoEditorModel model) {
        ImageInfoEditorModel oldModel = this.model;
        if (oldModel != model) {
            this.model = model;
            this.deinstallMouseListener();
            if (oldModel != null) {
                oldModel.removeChangeListener(this.modelCL);
            }
            if (this.model != null) {
                this.roundFactor = MathUtils.computeRoundFactor((double)this.model.getMinSample(), (double)this.model.getMaxSample(), (int)2);
                this.installMouseListener();
                model.addChangeListener(this.modelCL);
            }
            this.firePropertyChange(PROPERTY_NAME_MODEL, oldModel, this.model);
            this.fireStateChanged();
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public boolean computePercent(boolean logScaled, double threshhold) {
        Histogram histogram = new Histogram(this.getModel().getHistogramBins(), this.scaleInverse(this.getModel().getMinSample()), this.scaleInverse(this.getModel().getMaxSample()));
        Range autoStretchRange = histogram.findRangeForPercent(threshhold);
        if (autoStretchRange == null) {
            return false;
        }
        if (logScaled && this.scale(autoStretchRange.getMin()) <= 0.0) {
            return false;
        }
        this.computeFactors();
        this.setFirstSliderSample(this.scale(autoStretchRange.getMin()));
        this.setLastSliderSample(this.scale(autoStretchRange.getMax()));
        this.partitionSliders(false);
        this.computeZoomInToSliderLimits();
        return true;
    }

    public boolean setRGBminmax(double min, double max) {
        this.computeFactors();
        this.setFirstSliderSample(min);
        this.setLastSliderSample(max);
        this.partitionSliders(false);
        this.computeZoomInToSliderLimits();
        return true;
    }

    public boolean compute100Percent(boolean logScaled) {
        if (logScaled && this.getModel().getMinSample() <= 0.0) {
            return false;
        }
        this.computeFactors();
        this.setFirstSliderSample(this.getModel().getMinSample());
        this.setLastSliderSample(this.getModel().getMaxSample());
        this.partitionSliders(false);
        this.computeZoomInToSliderLimits();
        return true;
    }

    public void distributeSlidersEvenly() {
        double pos1 = this.scaleInverse(this.getFirstSliderSample());
        double pos2 = this.scaleInverse(this.getLastSliderSample());
        double delta = pos2 - pos1;
        double evenSpace = delta / (double)(this.getSliderCount() - 2 + 1);
        for (int i = 0; i < this.getSliderCount(); ++i) {
            double value = this.scale(pos1 + evenSpace * (double)i);
            this.setSliderSample(i, value, false);
        }
    }

    private void partitionSliders(boolean adjusting) {
        double pos1 = this.scaleInverse(this.getFirstSliderSample());
        double pos2 = this.scaleInverse(this.getLastSliderSample());
        double delta = pos2 - pos1;
        for (int i = 0; i < this.getSliderCount() - 1; ++i) {
            double value = this.scale(pos1 + this.factors[i] * delta);
            this.setSliderSample(i, value, adjusting);
        }
    }

    private void computeFactors() {
        this.factors = new double[this.getSliderCount()];
        double firstPS = this.scaleInverse(this.getFirstSliderSample());
        double lastPS = this.scaleInverse(this.getLastSliderSample());
        double dsn = lastPS - firstPS;
        if (dsn == 0.0 || Double.isNaN(dsn)) {
            dsn = Double.MIN_VALUE;
        }
        for (int i = 0; i < this.getSliderCount(); ++i) {
            double sample = this.scaleInverse(this.getSliderSample(i));
            double dsi = sample - firstPS;
            this.factors[i] = dsi / dsn;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_COMPONENT_SIZE;
    }

    @Override
    public void setBounds(int x, int y, int width, int heigth) {
        super.setBounds(x, y, width, heigth);
        this.computeSizeAttributes();
    }

    public void computeZoomInToSliderLimits() {
        double firstSliderValue = this.scaleInverse(this.getFirstSliderSample());
        double lastSliderValue = this.scaleInverse(this.getLastSliderSample());
        double percentOffset = 0.0;
        double minViewSample = this.scale(firstSliderValue - 0.0);
        double maxViewSample = this.scale(lastSliderValue + 0.0);
        this.getModel().setMinHistogramViewSample(minViewSample);
        this.getModel().setMaxHistogramViewSample(maxViewSample);
        this.repaint();
    }

    public void computeZoomOutToFullHistogramm() {
        this.getModel().setMinHistogramViewSample(this.getMinSample());
        this.getModel().setMaxHistogramViewSample(this.getMaxSample());
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getModel() == null || this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(this.labelFont);
        this.computeSizeAttributes();
        if (this.isValidModel()) {
            this.drawPalette(g2d);
            this.drawSliders(g2d);
            this.drawHistogramPane(g2d);
        } else {
            FontMetrics fontMetrics = g2d.getFontMetrics();
            this.drawMissingBasicDisplayInfoMessage(g2d, fontMetrics);
        }
    }

    private boolean isHistogramAvailable() {
        return this.model.isHistogramAvailable();
    }

    private boolean isValidModel() {
        return this.model != null && this.model.getMinSample() <= this.model.getMaxSample() && this.model.getSampleScaling() != null && this.model.getSampleStx() != null;
    }

    public void computeZoomOutVertical() {
        this.getModel().setHistogramViewGain(this.getModel().getHistogramViewGain() * 0.7142857142857143);
        this.repaint();
    }

    public void computeZoomInVertical() {
        this.getModel().setHistogramViewGain(this.getModel().getHistogramViewGain() * 1.4);
        this.repaint();
    }

    private void drawMissingBasicDisplayInfoMessage(Graphics2D g2d, FontMetrics fontMetrics) {
        int totWidth = this.getWidth();
        int totHeight = this.getHeight();
        g2d.drawString(NO_DISPLAY_INFO_TEXT, (totWidth - fontMetrics.stringWidth(NO_DISPLAY_INFO_TEXT)) / 2, (totHeight + fontMetrics.getHeight()) / 2);
    }

    private void drawPalette(Graphics2D g2d) {
        if (this.paletteBackgound == null || this.paletteBackgound.getWidth() != this.paletteRect.width || this.paletteBackgound.getHeight() != this.paletteRect.height) {
            this.paletteBackgound = ImageInfoEditor.createAlphaBackground(this.paletteRect.width, this.paletteRect.height);
        }
        g2d.drawImage((Image)this.paletteBackgound, this.paletteRect.x, this.paletteRect.y, null);
        long paletteX1 = (long)this.paletteRect.x + Math.round(this.getRelativeSliderPos(this.getFirstSliderSample()));
        long paletteX2 = (long)this.paletteRect.x + Math.round(this.getRelativeSliderPos(this.getLastSliderSample()));
        g2d.setStroke(STROKE_1);
        Color[] colorPalette = this.getColorPalette();
        if (colorPalette != null) {
            for (int x = this.paletteRect.x; x < this.paletteRect.x + this.paletteRect.width; ++x) {
                long divisor = paletteX2 - paletteX1;
                int palIndex = divisor == 0L ? ((long)x < paletteX1 ? 0 : colorPalette.length - 1) : (int)((long)colorPalette.length * ((long)x - paletteX1) / divisor);
                if (palIndex < 0) {
                    palIndex = 0;
                }
                if (palIndex > colorPalette.length - 1) {
                    palIndex = colorPalette.length - 1;
                }
                g2d.setColor(colorPalette[palIndex]);
                g2d.drawLine(x, this.paletteRect.y, x, this.paletteRect.y + this.paletteRect.height);
            }
        }
        g2d.setStroke(STROKE_1);
        g2d.setColor(Color.darkGray);
        g2d.draw(this.paletteRect);
    }

    private static BufferedImage createAlphaBackground(int width, int height) {
        BufferedImage background = new BufferedImage(width, height, 2);
        DataBufferInt dataBuffer = (DataBufferInt)background.getRaster().getDataBuffer();
        int[] data = dataBuffer.getData();
        int gray = Color.LIGHT_GRAY.getRGB();
        int white = Color.WHITE.getRGB();
        for (int i = 0; i < data.length; ++i) {
            int x = i % width;
            int y = i / width;
            data[i] = x / 4 % 2 == y / 4 % 2 ? gray : white;
        }
        return background;
    }

    private Color[] getColorPalette() {
        if (this.palette == null) {
            this.palette = this.getModel().createColorPalette();
        }
        return this.palette;
    }

    private void drawSliders(Graphics2D g2d) {
        g2d.translate(this.sliderBaseLineRect.x, this.sliderBaseLineRect.y);
        g2d.setStroke(STROKE_1);
        for (int i = 0; i < this.getSliderCount(); ++i) {
            if (!this.isSliderVisible(i)) continue;
            double sliderPos = this.getRelativeSliderPos(this.getSliderSample(i));
            g2d.translate(sliderPos, 0.0);
            Color sliderColor = this.getSliderColor(i);
            g2d.setPaint(sliderColor);
            g2d.fill(this.sliderShape);
            int gray = (sliderColor.getRed() + sliderColor.getGreen() + sliderColor.getBlue()) / 3;
            g2d.setColor(gray < 128 ? Color.white : Color.black);
            g2d.draw(this.sliderShape);
            String text = this.getFormattedValue(this.getSliderSample(i));
            g2d.setColor(Color.black);
            AffineTransform oldTransform = g2d.getTransform();
            g2d.transform(AffineTransform.getRotateInstance(1.5707963267948966));
            g2d.drawString(text, 8.0f, 3.1499999f);
            g2d.setTransform(oldTransform);
            g2d.translate(-sliderPos, 0.0);
        }
        g2d.translate(-this.sliderBaseLineRect.x, -this.sliderBaseLineRect.y);
    }

    private String getFormattedValue(double value) {
        if (value < 0.1 && value > -0.1 && value != 0.0) {
            return new DecimalFormat("0.##E0").format(value);
        }
        return new DecimalFormat("#0.0#").format(this.round(value));
    }

    private void drawHistogramPane(Graphics2D g2d) {
        Shape oldClip = g2d.getClip();
        g2d.setClip(this.histoRect.x - 1, this.histoRect.y - 1, this.histoRect.width + 2, this.histoRect.height + 2);
        this.drawHistogram(g2d);
        this.drawGradationCurve(g2d);
        this.drawHistogramBorder(g2d);
        g2d.setClip(oldClip);
    }

    private void drawHistogramBorder(Graphics2D g2d) {
        g2d.setStroke(STROKE_1);
        g2d.setColor(Color.darkGray);
        g2d.draw(this.histoRect);
    }

    private void drawGradationCurve(Graphics2D g2d) {
        g2d.setColor(Color.white);
        g2d.setStroke(STROKE_2);
        int x1 = this.histoRect.x;
        int y1 = this.histoRect.y + this.histoRect.height - 1;
        int x2 = (int)this.getAbsoluteSliderPos(this.getFirstSliderSample());
        int y2 = y1;
        g2d.drawLine(x1, y1, x2, y2);
        x1 = x2;
        y1 = y2;
        x2 = (int)this.getAbsoluteSliderPos(this.getLastSliderSample());
        y2 = this.histoRect.y + 1;
        byte[] gammaCurve = this.getModel().getGammaCurve();
        if (gammaCurve != null) {
            int xx = x1;
            int yy = y1;
            int x = x1 + 1;
            while (x <= x2) {
                int i = MathUtils.roundAndCrop((float)(255.9f * (float)(x - x1) / (float)(x2 - x1)), (int)0, (int)255);
                int y = y1 + (y2 - y1) * (gammaCurve[i] & 0xFF) / 256;
                g2d.drawLine(xx, yy, x, y);
                xx = x++;
                yy = y;
            }
        } else {
            g2d.drawLine(x1, y1, x2, y2);
        }
        x1 = x2;
        y1 = y2;
        x2 = this.histoRect.x + this.histoRect.width;
        y2 = this.histoRect.y + 1;
        g2d.drawLine(x1, y1, x2, y2);
        g2d.setStroke(DASHED_STROKE);
        for (int i = 0; i < this.getSliderCount(); ++i) {
            x1 = (int)this.getAbsoluteSliderPos(this.getSliderSample(i));
            y1 = this.histoRect.y + this.histoRect.height - 1;
            x2 = x1;
            y2 = this.histoRect.y + 1;
            g2d.drawLine(x1, y1, x2, y2);
        }
    }

    private void drawHistogram(Graphics2D g2d) {
        if (this.model.isHistogramAvailable()) {
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(Color.DARK_GRAY);
            int[] histogramBins = this.model.getHistogramBins();
            double maxHistogramCounts = ImageInfoEditor.getMaxVisibleHistogramCounts(histogramBins, 0.0625);
            double viewBinCount = this.getHistogramViewBinCount();
            if (viewBinCount > 0.0 && maxHistogramCounts > 0.0) {
                g2d.setStroke(new BasicStroke(1.0f));
                double minViewBinIndex = this.getMinHistogramViewBinIndex();
                double binsPerPixel = viewBinCount / (double)this.histoRect.width;
                double maxBarHeight = 0.9 * (double)this.histoRect.height;
                double gain = this.model.getHistogramViewGain();
                double countsScale = gain * maxBarHeight / maxHistogramCounts;
                Rectangle2D.Double r = new Rectangle2D.Double();
                for (int i = 0; i < this.histoRect.width; ++i) {
                    int binIndex = (int)Math.floor(minViewBinIndex + (double)i * binsPerPixel);
                    double binHeight = 0.0;
                    if (binIndex >= 0 && binIndex < histogramBins.length) {
                        double counts = histogramBins[binIndex];
                        binHeight = countsScale * counts;
                    }
                    if (binHeight >= (double)this.histoRect.height) {
                        binHeight = this.histoRect.height - 1;
                    }
                    r.setRect(this.histoRect.x + i, (double)(this.histoRect.y + this.histoRect.height - 1) - binHeight, 1.0, binHeight);
                    g2d.fill(r);
                }
            }
            g2d.setPaint(oldPaint);
        }
    }

    private static double getMaxVisibleHistogramCounts(int[] histogramBins, double ratio) {
        double totalHistogramCounts = 0.0;
        for (int histogramBin : histogramBins) {
            totalHistogramCounts += (double)histogramBin;
        }
        double limitHistogramCounts = totalHistogramCounts * ratio;
        double maxHistogramCounts = 0.0;
        for (int histogramBin : histogramBins) {
            if (!((double)histogramBin < limitHistogramCounts)) continue;
            maxHistogramCounts = Math.max(maxHistogramCounts, (double)histogramBin);
        }
        return maxHistogramCounts;
    }

    private void installMouseListener() {
        this.addMouseListener(this.internalMouseListener);
        this.addMouseMotionListener(this.internalMouseListener);
    }

    private void deinstallMouseListener() {
        this.removeMouseListener(this.internalMouseListener);
        this.removeMouseMotionListener(this.internalMouseListener);
    }

    private double getMaxSample() {
        return this.getModel().getMaxSample();
    }

    private double getMinSample() {
        return this.getModel().getMinSample();
    }

    private int getSliderCount() {
        return this.getModel().getSliderCount();
    }

    private double getMinSliderSample(int sliderIndex) {
        if (sliderIndex == 0) {
            return this.getMinSample();
        }
        return this.getSliderSample(sliderIndex - 1);
    }

    private double getMaxSliderSample(int sliderIndex) {
        if (sliderIndex == this.getSliderCount() - 1) {
            return this.getMaxSample();
        }
        return this.getSliderSample(sliderIndex + 1);
    }

    private double getFirstSliderSample() {
        return this.getSliderSample(0);
    }

    private void setFirstSliderSample(double v) {
        this.setSliderSample(0, v);
    }

    private double getLastSliderSample() {
        return this.getSliderSample(this.getModel().getSliderCount() - 1);
    }

    private void setLastSliderSample(double v) {
        this.setSliderSample(this.getModel().getSliderCount() - 1, v);
    }

    private double getSliderSample(int index) {
        return this.getModel().getSliderSample(index);
    }

    private void setSliderSample(int index, double v) {
        this.getModel().setSliderSample(index, v);
    }

    protected abstract void applyChanges();

    private void setSliderSample(int index, double newValue, boolean adjusting) {
        if (adjusting) {
            double minValue = Double.NEGATIVE_INFINITY;
            if (index > 0 && index < this.getSliderCount() - 1) {
                minValue = this.getSliderSample(index - 1);
            }
            if (newValue < minValue) {
                newValue = minValue;
            }
        }
        this.setSliderSample(index, newValue);
    }

    private Color getSliderColor(int index) {
        ImageInfo.UncertaintyVisualisationMode uvMode = this.getModel().getImageInfo().getUncertaintyVisualisationMode();
        if (uvMode != null) {
            if (uvMode == ImageInfo.UncertaintyVisualisationMode.Transparency_Blending) {
                return Color.WHITE;
            }
            if (uvMode == ImageInfo.UncertaintyVisualisationMode.Monochromatic_Blending) {
                return this.getModel().getSliderColor(this.getSliderCount() - 1);
            }
        }
        return this.getModel().getSliderColor(index);
    }

    private void setSliderColor(int index, Color c) {
        this.getModel().setSliderColor(index, c);
        this.applyChanges();
    }

    private static Font createLabelFont() {
        return new Font(FONT_NAME, 0, 9);
    }

    public static Shape createSliderShape() {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, -5.0f);
        path.lineTo(6.0f, 5.0f);
        path.lineTo(-6.0f, 5.0f);
        path.closePath();
        return path;
    }

    private double computeSliderValueForX(int sliderIndex, int x) {
        double minVS = this.scaleInverse(this.getModel().getMinHistogramViewSample());
        double maxVS = this.scaleInverse(this.getModel().getMaxHistogramViewSample());
        double value = this.scale(minVS + (double)(x - this.sliderBaseLineRect.x) * (maxVS - minVS) / (double)this.sliderBaseLineRect.width);
        if (this.isFirstSliderIndex(sliderIndex)) {
            return Math.min(value, this.getLastSliderSample());
        }
        if (this.isLastSliderIndex(sliderIndex)) {
            return Math.max(value, this.getFirstSliderSample());
        }
        return this.computeAdjustedSliderValue(sliderIndex, value);
    }

    private double computeAdjustedSliderValue(int sliderIndex, double value) {
        double valueD = value;
        double minSliderValue = this.getMinSliderSample(sliderIndex);
        double maxSliderValue = this.getMaxSliderSample(sliderIndex);
        if (valueD < minSliderValue) {
            valueD = minSliderValue;
        }
        if (valueD > maxSliderValue) {
            valueD = maxSliderValue;
        }
        return valueD;
    }

    private boolean isFirstSliderIndex(int sliderIndex) {
        return sliderIndex == 0;
    }

    private boolean isLastSliderIndex(int sliderIndex) {
        return this.getSliderCount() - 1 == sliderIndex;
    }

    private double round(double value) {
        return MathUtils.round((double)value, (double)this.roundFactor);
    }

    private double getAbsoluteSliderPos(double sample) {
        return (double)this.sliderBaseLineRect.x + this.getRelativeSliderPos(sample);
    }

    private double getRelativeSliderPos(double sample) {
        return this.getNormalizedHistogramViewSampleValue(sample) * (double)this.sliderBaseLineRect.width;
    }

    private void computeSizeAttributes() {
        int totWidth = this.getWidth();
        int totHeight = this.getHeight();
        int imageWidth = totWidth - 20;
        this.sliderTextBaseLineY = totHeight - 4 - 50;
        this.sliderBaseLineRect.x = 10;
        this.sliderBaseLineRect.y = this.sliderTextBaseLineY - 5;
        this.sliderBaseLineRect.width = imageWidth;
        this.sliderBaseLineRect.height = 1;
        this.paletteRect.x = 10;
        this.paletteRect.y = this.sliderBaseLineRect.y - 16;
        this.paletteRect.width = imageWidth;
        this.paletteRect.height = 16;
        this.histoRect.x = 10;
        this.histoRect.y = 4;
        this.histoRect.width = imageWidth;
        this.histoRect.height = this.paletteRect.y - this.histoRect.y - 3;
    }

    private double getHistogramViewBinCount() {
        return Math.min(this.getDisplayableBinCount(), (double)this.model.getHistogramBins().length);
    }

    private double getDisplayableBinCount() {
        double max = Math.min(this.getMaxSample(), this.getModel().getMaxHistogramViewSample());
        double min = Math.max(this.getMinSample(), this.getModel().getMinHistogramViewSample());
        return this.getBinCountInRange(min, max);
    }

    private double getBinCountInRange(double minSample, double maxSample) {
        if (!this.isHistogramAvailable()) {
            return -1.0;
        }
        double minHistogramSample = this.model.getMinSample();
        double maxHistogramSample = this.model.getMaxSample();
        if (minSample >= maxHistogramSample || maxSample <= minHistogramSample) {
            return 0.0;
        }
        minSample = Math.max(minSample, minHistogramSample);
        maxSample = Math.min(maxSample, maxHistogramSample);
        double a = this.scaleInverse(maxSample) - this.scaleInverse(minSample);
        double b = this.scaleInverse(maxHistogramSample) - this.scaleInverse(minHistogramSample);
        return a / b * (double)this.model.getHistogramBins().length;
    }

    private double getMinHistogramViewBinIndex() {
        double minHistogramViewSample;
        if (!this.isHistogramAvailable()) {
            return -1.0;
        }
        double minHistogramSample = this.model.getMinSample();
        if (minHistogramSample != (minHistogramViewSample = this.model.getMinHistogramViewSample())) {
            double a = this.scaleInverse(minHistogramViewSample) - this.scaleInverse(minHistogramSample);
            double b = this.scaleInverse(this.model.getMaxSample()) - this.scaleInverse(minHistogramSample);
            return a / b * (double)this.model.getHistogramBins().length;
        }
        return 0.0;
    }

    private double getNormalizedHistogramViewSampleValue(double sample) {
        double minVisibleSample = this.scaleInverse(this.getModel().getMinHistogramViewSample());
        double maxVisibleSample = this.scaleInverse(this.getModel().getMaxHistogramViewSample());
        sample = this.scaleInverse(sample);
        double delta = maxVisibleSample - minVisibleSample;
        if (delta == 0.0 || Double.isNaN(delta)) {
            delta = 1.0;
        }
        return (sample - minVisibleSample) / delta;
    }

    private void editSliderColor(MouseEvent evt, int sliderIndex) {
        Color selectedColor = this.getSliderColor(sliderIndex);
        ColorChooserPanel panel = new ColorChooserPanel(selectedColor);
        panel.addPropertyChangeListener("selectedColor", evt1 -> {
            this.setSliderColor(sliderIndex, panel.getSelectedColor());
            this.hidePopup();
        });
        this.showPopup(evt, panel);
    }

    private boolean isSliderVisible(int sliderIndex) {
        if (sliderIndex == 0 || sliderIndex == this.getSliderCount() - 1) {
            return true;
        }
        ImageInfo.UncertaintyVisualisationMode uvMode = this.getModel().getImageInfo().getUncertaintyVisualisationMode();
        return uvMode == null || uvMode == ImageInfo.UncertaintyVisualisationMode.None || uvMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Blending || uvMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Overlay;
    }

    private boolean isSliderEditable(int sliderIndex) {
        ImageInfo.UncertaintyVisualisationMode uvMode = this.getModel().getImageInfo().getUncertaintyVisualisationMode();
        return uvMode == null || uvMode == ImageInfo.UncertaintyVisualisationMode.None || uvMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Blending || uvMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Overlay || uvMode == ImageInfo.UncertaintyVisualisationMode.Monochromatic_Blending && this.isLastSliderIndex(sliderIndex);
    }

    private boolean canChangeSliderCount() {
        ImageInfo.UncertaintyVisualisationMode uvMode = this.getModel().getImageInfo().getUncertaintyVisualisationMode();
        return uvMode == null || uvMode == ImageInfo.UncertaintyVisualisationMode.None || uvMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Blending || uvMode == ImageInfo.UncertaintyVisualisationMode.Polychromatic_Overlay;
    }

    private void editSliderSample(MouseEvent evt, int sliderIndex) {
        PropertyContainer vc = new PropertyContainer();
        vc.addProperty(Property.create((String)"sample", (Object)this.getSliderSample(sliderIndex)));
        vc.getDescriptor("sample").setDisplayName("sample");
        vc.getDescriptor("sample").setUnit(this.getModel().getParameterUnit());
        ValueRange valueRange = sliderIndex == 0 ? new ValueRange(Double.NEGATIVE_INFINITY, this.round(this.getMaxSliderSample(sliderIndex))) : (sliderIndex == this.getSliderCount() - 1 ? new ValueRange(this.round(this.getMinSliderSample(sliderIndex)), Double.POSITIVE_INFINITY) : new ValueRange(this.round(this.getMinSliderSample(sliderIndex)), this.round(this.getMaxSliderSample(sliderIndex))));
        vc.getDescriptor("sample").setValueRange(valueRange);
        BindingContext ctx = new BindingContext((PropertySet)vc);
        NumberFormatter formatter = new NumberFormatter(new DecimalFormat("#0.000000000#"));
        formatter.setValueClass(Double.class);
        JFormattedTextField field = new JFormattedTextField(formatter);
        field.setColumns(11);
        field.setHorizontalAlignment(4);
        ctx.bind("sample", field);
        this.showPopup(evt, field);
        ctx.addPropertyChangeListener("sample", pce -> {
            this.hidePopup();
            Double value = (Double)ctx.getBinding("sample").getPropertyValue();
            if (this.checkSliderRangeCompatibility(value, valueRange.getMin(), valueRange.getMax()) && this.checkLogCompatibility(value, "slider", this.isLogScaled())) {
                this.setSliderSample(sliderIndex, value);
                this.computeZoomInToSliderLimits();
                this.applyChanges();
            }
        });
    }

    private void showPopup(MouseEvent evt, JComponent component) {
        this.hidePopup();
        this.popup = new JidePopup();
        this.popup.setOwner((Component)this);
        this.popup.setDefaultFocusComponent((Component)component);
        this.popup.getContentPane().add(component);
        this.popup.setAttachable(true);
        this.popup.setMovable(false);
        this.popup.showPopup(evt.getXOnScreen(), evt.getYOnScreen());
    }

    private void hidePopup() {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.hidePopupImmediately();
            this.popup = null;
        }
    }

    private double scale(double value) {
        assert (this.model != null);
        return this.model.getSampleScaling().scale(value);
    }

    private double scaleInverse(double value) {
        assert (this.model != null);
        return this.model.getSampleScaling().scaleInverse(value);
    }

    protected abstract boolean checkLogCompatibility(double var1, String var3, boolean var4);

    protected abstract boolean checkSliderRangeCompatibility(double var1, double var3, double var5);

    public boolean isLogScaled() {
        return this.logScaled;
    }

    public void setLogScaled(boolean logScaled) {
        this.logScaled = logScaled;
    }

    private class ModelCL
    implements ChangeListener {
        private ModelCL() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ImageInfoEditor.this.fireStateChanged();
        }
    }

    private class RepaintCL
    implements ChangeListener {
        private RepaintCL() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ImageInfoEditor.this.palette = null;
            ImageInfoEditor.this.repaint();
        }
    }

    private class InternalMouseListener
    implements MouseListener,
    MouseMotionListener {
        private int draggedSliderIndex = -1;
        private boolean dragging;

        private InternalMouseListener() {
            ImageInfoEditor.this.factors = null;
            this.dragging = false;
        }

        public boolean isDragging() {
            return this.dragging;
        }

        public void setDragging(boolean dragging) {
            this.dragging = dragging;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ImageInfoEditor.this.hidePopup();
            this.resetState();
            if (!this.maybeShowSliderActions(mouseEvent)) {
                this.setDraggedSliderIndex(this.getNearestSliderIndex(mouseEvent.getX(), mouseEvent.getY()));
                if (this.isFirstSliderDragged() || this.isLastSliderDragged()) {
                    ImageInfoEditor.this.computeFactors();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (this.isDragging()) {
                this.doDragSlider(evt, false);
                this.setDragging(false);
                this.setDraggedSliderIndex(-1);
                ImageInfoEditor.this.applyChanges();
            } else if (!this.maybeShowSliderActions(evt) && SwingUtilities.isLeftMouseButton(evt)) {
                int mode = 0;
                int sliderIndex = this.getSelectedSliderIndex(evt);
                if (sliderIndex != -1 && ImageInfoEditor.this.getModel().isColorEditable()) {
                    mode = 1;
                }
                if (mode == 0) {
                    if (sliderIndex == -1) {
                        sliderIndex = this.getSelectedSliderTextIndex(evt);
                    }
                    if (sliderIndex != -1) {
                        mode = 2;
                    }
                }
                if (mode == 1) {
                    ImageInfoEditor.this.editSliderColor(evt, sliderIndex);
                } else if (mode == 2) {
                    ImageInfoEditor.this.editSliderSample(evt, sliderIndex);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            this.maybeShowSliderActions(evt);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.resetState();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.resetState();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.setDragging(true);
            this.doDragSlider(mouseEvent, true);
        }

        private void doDragSlider(MouseEvent mouseEvent, boolean adjusting) {
            if (this.getDraggedSliderIndex() != -1) {
                int x = mouseEvent.getX();
                x = Math.max(x, ImageInfoEditor.this.sliderBaseLineRect.x);
                x = Math.min(x, ImageInfoEditor.this.sliderBaseLineRect.x + ImageInfoEditor.this.sliderBaseLineRect.width);
                double newSample = ImageInfoEditor.this.computeSliderValueForX(this.getDraggedSliderIndex(), x);
                ImageInfoEditor.this.setSliderSample(this.getDraggedSliderIndex(), newSample, adjusting);
                if (this.isFirstSliderDragged() || this.isLastSliderDragged()) {
                    ImageInfoEditor.this.partitionSliders(adjusting);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.isDragging()) {
                this.mouseDragged(mouseEvent);
            }
        }

        private boolean maybeShowSliderActions(MouseEvent mouseEvent) {
            if (ImageInfoEditor.this.getModel().isColorEditable() && mouseEvent.isPopupTrigger()) {
                int sliderIndex = this.getSelectedSliderIndex(mouseEvent);
                this.showSliderActions(mouseEvent, sliderIndex);
                return true;
            }
            return false;
        }

        private void setDraggedSliderIndex(int draggedSliderIndex) {
            if (this.draggedSliderIndex != draggedSliderIndex) {
                this.draggedSliderIndex = draggedSliderIndex;
            }
        }

        public int getDraggedSliderIndex() {
            return this.draggedSliderIndex;
        }

        private void showSliderActions(MouseEvent evt, int sliderIndex) {
            JMenuItem menuItem;
            JidePopupMenu menu = new JidePopupMenu();
            boolean showPopupMenu = false;
            if (ImageInfoEditor.this.canChangeSliderCount()) {
                menuItem = this.createMenuItemAddNewSlider(sliderIndex, evt);
                if (menuItem != null) {
                    menu.add(menuItem);
                    showPopupMenu = true;
                }
                if (ImageInfoEditor.this.getSliderCount() > 2 && sliderIndex != -1) {
                    menuItem = this.createMenuItemDeleteSlider(sliderIndex);
                    menu.add(menuItem);
                    showPopupMenu = true;
                }
            }
            if (ImageInfoEditor.this.getSliderCount() > 2 && sliderIndex > 0 && sliderIndex < ImageInfoEditor.this.getSliderCount() - 1 && ImageInfoEditor.this.isSliderEditable(sliderIndex)) {
                menuItem = this.createMenuItemCenterSampleValue(sliderIndex);
                menu.add(menuItem);
                menuItem = this.createMenuItemCenterColorValue(sliderIndex);
                menu.add(menuItem);
                showPopupMenu = true;
            }
            if (showPopupMenu) {
                menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        private JMenuItem createMenuItemCenterColorValue(int sliderIndex) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText("Center Slider Colour");
            menuItem.setMnemonic('c');
            menuItem.addActionListener(actionEvent -> {
                Color newColor = ColorPaletteDef.getCenterColor((Color)ImageInfoEditor.this.getSliderColor(sliderIndex - 1), (Color)ImageInfoEditor.this.getSliderColor(sliderIndex + 1));
                ImageInfoEditor.this.setSliderColor(sliderIndex, newColor);
                ImageInfoEditor.this.hidePopup();
                ImageInfoEditor.this.applyChanges();
            });
            return menuItem;
        }

        private JMenuItem createMenuItemCenterSampleValue(int sliderIndex) {
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText("Center Slider Position");
            menuItem.setMnemonic('s');
            menuItem.addActionListener(actionEvent -> {
                double center = ImageInfoEditor.this.scale(0.5 * (ImageInfoEditor.this.scaleInverse(ImageInfoEditor.this.getSliderSample(sliderIndex - 1)) + ImageInfoEditor.this.scaleInverse(ImageInfoEditor.this.getSliderSample(sliderIndex + 1))));
                ImageInfoEditor.this.setSliderSample(sliderIndex, center, false);
                ImageInfoEditor.this.hidePopup();
                ImageInfoEditor.this.applyChanges();
            });
            return menuItem;
        }

        private JMenuItem createMenuItemDeleteSlider(int removeIndex) {
            JMenuItem menuItem = new JMenuItem("Remove Slider");
            menuItem.setMnemonic('D');
            menuItem.addActionListener(e -> {
                ImageInfoEditor.this.getModel().removeSlider(removeIndex);
                ImageInfoEditor.this.hidePopup();
                ImageInfoEditor.this.applyChanges();
            });
            return menuItem;
        }

        private JMenuItem createMenuItemAddNewSlider(int insertIndex, MouseEvent evt) {
            if (insertIndex == ImageInfoEditor.this.getModel().getSliderCount() - 1) {
                return null;
            }
            if (insertIndex == -1 && this.isClickOutsideExistingSliders(evt.getX())) {
                return null;
            }
            if (insertIndex == -1 && !this.isVerticalInColorBarArea(evt.getY())) {
                return null;
            }
            if (insertIndex == -1) {
                insertIndex = this.getNearestLeftSliderIndex(evt.getX());
            }
            if (insertIndex == -1) {
                return null;
            }
            int index = insertIndex;
            JMenuItem menuItem = new JMenuItem("Add new Slider");
            menuItem.setMnemonic('A');
            menuItem.addActionListener(e -> {
                assert (ImageInfoEditor.this.getModel() != null) : "getModel() != null";
                if (index < ImageInfoEditor.this.getModel().getSliderCount() - 1) {
                    ImageInfoEditor.this.getModel().createSliderAfter(index);
                }
                ImageInfoEditor.this.hidePopup();
                ImageInfoEditor.this.applyChanges();
            });
            return menuItem;
        }

        private boolean isClickOutsideExistingSliders(int x) {
            return (double)x < ImageInfoEditor.this.getAbsoluteSliderPos(ImageInfoEditor.this.getFirstSliderSample()) || (double)x > ImageInfoEditor.this.getAbsoluteSliderPos(ImageInfoEditor.this.getLastSliderSample());
        }

        private boolean isFirstSliderDragged() {
            return this.getDraggedSliderIndex() == 0;
        }

        private boolean isLastSliderDragged() {
            return this.getDraggedSliderIndex() == ImageInfoEditor.this.getSliderCount() - 1;
        }

        private boolean isVerticalInColorBarArea(int y) {
            int dy = Math.abs(ImageInfoEditor.this.paletteRect.y + 8 - y);
            return dy < 8;
        }

        private boolean isVerticalInSliderArea(int y) {
            int dy = Math.abs(ImageInfoEditor.this.sliderBaseLineRect.y - y);
            return dy < 5;
        }

        private int getSelectedSliderIndex(MouseEvent evt) {
            int sliderIndex;
            double dx;
            if (this.isVerticalInSliderArea(evt.getY()) && (dx = Math.abs(ImageInfoEditor.this.getAbsoluteSliderPos(ImageInfoEditor.this.getSliderSample(sliderIndex = this.getNearestSliderIndex(evt.getX()))) - (double)evt.getX())) < Math.floor(6.0)) {
                return sliderIndex;
            }
            return -1;
        }

        private int getSelectedSliderTextIndex(MouseEvent evt) {
            int sliderIndex;
            double dx;
            double dy = Math.abs(ImageInfoEditor.this.sliderTextBaseLineY + 50 - evt.getY());
            if (dy < 50.0 && (dx = Math.abs(ImageInfoEditor.this.getAbsoluteSliderPos(ImageInfoEditor.this.getSliderSample(sliderIndex = this.getNearestSliderIndex(evt.getX()))) - (double)evt.getX())) < Math.floor(4.5)) {
                return sliderIndex;
            }
            return -1;
        }

        private int getNearestSliderIndex(int x, int y) {
            if (this.isVerticalInSliderArea(y)) {
                return this.getNearestSliderIndex(x);
            }
            return -1;
        }

        private int getNearestLeftSliderIndex(int x) {
            int index = this.getNearestSliderIndex(x);
            double pos = ImageInfoEditor.this.getRelativeSliderPos(ImageInfoEditor.this.getSliderSample(index));
            if (pos > (double)x) {
                if (index > 0) {
                    return index - 1;
                }
                return -1;
            }
            return index;
        }

        private int getNearestSliderIndex(int x) {
            int i;
            int nearestIndex = -1;
            double minDx = 3.4028234663852886E38;
            double dx = 0.0;
            for (i = 0; i < ImageInfoEditor.this.getSliderCount(); ++i) {
                dx = ImageInfoEditor.this.getAbsoluteSliderPos(ImageInfoEditor.this.getSliderSample(i)) - (double)x;
                if (!(Math.abs(dx) <= minDx)) continue;
                nearestIndex = i;
                minDx = Math.abs(dx);
            }
            if (nearestIndex == ImageInfoEditor.this.getSliderCount() - 1 && ImageInfoEditor.this.getAbsoluteSliderPos(ImageInfoEditor.this.getSliderSample((i = ImageInfoEditor.this.getSliderCount() - 1) - 1)) == ImageInfoEditor.this.getAbsoluteSliderPos(ImageInfoEditor.this.getSliderSample(i))) {
                nearestIndex = dx <= 0.0 ? i : i - 1;
            }
            return nearestIndex;
        }

        private void resetState() {
            this.setDraggedSliderIndex(-1);
            ImageInfoEditor.this.factors = null;
        }
    }
}

