/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.jexp.Function;
import org.esa.snap.core.jexp.Namespace;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Parser;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.impl.Functions;
import org.esa.snap.core.jexp.impl.NamespaceImpl;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;

public class ExpressionPane
extends JPanel {
    public static final String HELP_ID = "expressionEditor";
    public static final String CODE_HISTORY_PREFERENCES_PREFIX = "expression.history.";
    private static final int CODE_HISTORY_MAX = 100;
    public static final String PLACEHOLDER = "@";
    private static final int PLACEHOLDER_LEN = "@".length();
    private static final String[] CONSTANT_LITERALS = new String[]{"PI", "E", "NaN", "true", "false", "X", "Y", "LAT", "LON", "TIME", "0.5", "0.0", "1.0", "2.0", "0", "1", "2", "273.15"};
    private static final String[] OPERATOR_PATTERNS = new String[]{"@ ? @ : @", "if @ then @ else @", "@ || @", "@ or @", "@ && @", "@ and @", "@ < @", "@ <= @", "@ > @", "@ >= @", "@ == @", "@ <= @", "@ | @", "@ ^ @", "@ & @", "@ + @", "@ - @", "@ * @", "@ / @", "@ % @", "+@", "-@", "~@", "!@", "not @"};
    private static final String[] FUNCTION_CALL_PATTERNS;
    private static Font exprTextAreaFont;
    private static Font insertCompFont;
    private static Color insertCompColor;
    private static Color okMsgColor;
    private static Color warnMsgColor;
    private Parser parser;
    private final Stack<String> undoBuffer = new Stack();
    private boolean booleanExpressionPreferred;
    private JTextArea codeArea;
    private JLabel messageLabel;
    private ActionPane actionPane;
    private String lastErrorMessage;
    private PropertyMap preferences;
    private List<String> history;
    private int historyIndex;
    private boolean emptyExpressionAllowed;

    public ExpressionPane(boolean requiresBoolExpr, Parser parser, PropertyMap preferences) {
        super(new BorderLayout(4, 4));
        this.parser = parser;
        this.booleanExpressionPreferred = requiresBoolExpr;
        this.history = new LinkedList<String>();
        this.historyIndex = -1;
        this.emptyExpressionAllowed = true;
        this.setPreferences(preferences);
        this.createUI();
    }

    public int showModalDialog(Window parent, String title) {
        ExpressionPaneDialog dialog = new ExpressionPaneDialog(parent, title);
        return dialog.show();
    }

    public PropertyMap getPreferences() {
        return this.preferences;
    }

    public void setPreferences(PropertyMap preferences) {
        this.preferences = preferences;
        if (this.preferences != null) {
            this.loadCodeHistory();
        }
    }

    public void setEmptyExpressionAllowed(boolean allow) {
        this.emptyExpressionAllowed = allow;
    }

    public boolean isEmptyExpressionAllowed() {
        return this.emptyExpressionAllowed;
    }

    public void updateCodeHistory() {
        String code = this.getCode();
        if (code != null && !(code = code.trim()).equals("")) {
            this.addToCodeHistory(code, true);
            this.storeCodeHistory();
        }
    }

    private void addToCodeHistory(String code, boolean head) {
        if (code != null && !(code = code.trim()).equals("")) {
            if (this.history.contains(code)) {
                this.history.remove(code);
            }
            if (head) {
                this.history.add(0, code);
            } else {
                this.history.add(code);
            }
        }
    }

    public void loadCodeHistory() {
        if (this.preferences != null) {
            this.history.clear();
            for (int index = 0; index < 100; ++index) {
                String code = this.preferences.getPropertyString(CODE_HISTORY_PREFERENCES_PREFIX + index);
                this.addToCodeHistory(code, false);
            }
            this.historyIndex = -1;
            this.updateUIState();
        }
    }

    public void storeCodeHistory() {
        if (this.history != null && this.preferences != null) {
            Iterator<String> iterator = this.history.iterator();
            for (int index = 0; index < 100 && iterator.hasNext(); ++index) {
                String code = iterator.next();
                this.preferences.setPropertyString(CODE_HISTORY_PREFERENCES_PREFIX + index, code);
            }
        }
    }

    protected void dispose() {
        this.undoBuffer.clear();
        this.parser = null;
        this.codeArea = null;
        this.messageLabel = null;
        this.actionPane = null;
    }

    public void setLeftAccessory(Component component) {
        this.add(component, "West");
    }

    public void setRightAccessory(Component component) {
        this.add(component, "East");
    }

    public void setTopAccessory(Component component) {
        this.add(component, "North");
    }

    public void setBottomAccessory(Component component) {
        this.add(component, "South");
    }

    public JTextArea getCodeArea() {
        return this.codeArea;
    }

    public boolean isBooleanExpressionPreferred() {
        return this.booleanExpressionPreferred;
    }

    public void setBooleanExpressionPreferred(boolean booleanExpressionPreferred) {
        this.booleanExpressionPreferred = booleanExpressionPreferred;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        Parser oldValue = this.parser;
        if (oldValue == parser) {
            return;
        }
        this.parser = parser;
        this.firePropertyChange("parser", oldValue, parser);
    }

    public String getCode() {
        return this.codeArea.getText();
    }

    public void setCode(String newCode) {
        this.setCode(newCode, false, -1);
    }

    public void setCode(String newCode, boolean recordUndo, int caretPos) {
        String oldCode = this.codeArea.getText();
        if (recordUndo) {
            this.pushCodeOnUndoStack(oldCode);
        }
        this.codeArea.setText(newCode == null ? "" : newCode);
        this.checkCode(newCode);
        this.updateUIState();
        if (caretPos >= 0) {
            this.codeArea.setCaretPosition(caretPos);
        }
        this.codeArea.requestFocus();
        this.firePropertyChange("code", oldCode, newCode);
    }

    public void clearCode() {
        this.setCode("");
    }

    public void selectAllCode() {
        this.codeArea.selectAll();
        this.codeArea.requestFocus();
    }

    public void undoLastEdit() {
        if (!this.undoBuffer.isEmpty()) {
            String code = this.undoBuffer.pop();
            this.setCode(code);
            this.updateUIState();
            this.codeArea.requestFocus();
        }
    }

    public void insertCodePattern(String pattern) {
        int newCaretPos;
        String oldCode = this.getCode();
        StringBuffer sb = new StringBuffer(oldCode.length() + 2 * pattern.length());
        int selPos1 = this.codeArea.getSelectionStart();
        int selPos2 = this.codeArea.getSelectionEnd();
        if (selPos1 >= 0 && selPos2 >= 0 && selPos1 > selPos2) {
            int temp = selPos1;
            selPos1 = selPos2;
            selPos2 = temp;
        }
        int phPatPos = pattern.indexOf(PLACEHOLDER);
        if (selPos2 > selPos1) {
            String selCode = oldCode.substring(selPos1, selPos2);
            ExpressionPane.append(sb, oldCode.substring(0, selPos1));
            if (phPatPos >= 0) {
                ExpressionPane.append(sb, pattern.substring(0, phPatPos));
                ExpressionPane.append(sb, selCode.trim());
                ExpressionPane.append(sb, pattern.substring(phPatPos + PLACEHOLDER_LEN));
            } else {
                ExpressionPane.append(sb, pattern);
            }
            newCaretPos = sb.length();
            ExpressionPane.append(sb, oldCode.substring(selPos2));
        } else {
            int phPos = oldCode.indexOf(PLACEHOLDER);
            if (phPos >= 0 && phPatPos == -1) {
                ExpressionPane.append(sb, oldCode.substring(0, phPos));
                ExpressionPane.append(sb, pattern);
                newCaretPos = sb.length();
                ExpressionPane.append(sb, oldCode.substring(phPos + PLACEHOLDER_LEN));
            } else {
                int caretPos = this.codeArea.getCaretPosition();
                String lCode = oldCode.substring(0, caretPos).trim();
                String rCode = oldCode.substring(caretPos).trim();
                if (lCode.length() > 0 && pattern.startsWith(PLACEHOLDER)) {
                    if (rCode.length() > 0 && pattern.endsWith(PLACEHOLDER)) {
                        ExpressionPane.append(sb, lCode);
                        ExpressionPane.append(sb, pattern.substring(PLACEHOLDER_LEN, pattern.length() - PLACEHOLDER_LEN));
                        newCaretPos = sb.length();
                        ExpressionPane.append(sb, rCode);
                    } else {
                        ExpressionPane.append(sb, lCode);
                        ExpressionPane.append(sb, pattern.substring(PLACEHOLDER_LEN));
                        newCaretPos = sb.length();
                        ExpressionPane.append(sb, rCode);
                    }
                } else if (rCode.length() > 0 && pattern.endsWith(PLACEHOLDER)) {
                    ExpressionPane.append(sb, lCode);
                    ExpressionPane.append(sb, pattern.substring(0, pattern.length() - PLACEHOLDER_LEN));
                    newCaretPos = sb.length();
                    ExpressionPane.append(sb, rCode);
                } else {
                    ExpressionPane.append(sb, lCode);
                    ExpressionPane.append(sb, pattern);
                    newCaretPos = sb.length();
                    ExpressionPane.append(sb, rCode);
                }
            }
        }
        this.setCode(sb.toString(), true, newCaretPos);
    }

    private static void append(StringBuffer sb, String s) {
        int n1 = sb.length();
        int n2 = s.length();
        if (n1 > 0 && n2 > 0) {
            char ch1 = sb.charAt(n1 - 1);
            char ch2 = s.charAt(0);
            if (ch1 != ' ' && ch2 != ' ' && ch1 != ',' && ch1 != '(' && ch2 != ')') {
                sb.append(' ');
            }
        }
        sb.append(s);
    }

    public ActionPane createActionPane() {
        return new ActionPane();
    }

    public JButton createInsertButton(String pattern) {
        JButton button = new JButton(pattern);
        button.setFont(insertCompFont);
        button.setForeground(insertCompColor);
        button.addActionListener(e -> this.insertCodePattern(pattern));
        return button;
    }

    private JComboBox<String> createInsertComboBox(String title, String[] patterns) {
        ArrayList<String> itemList = new ArrayList<String>();
        itemList.add(title);
        itemList.addAll(Arrays.asList(patterns));
        JComboBox<String> comboBox = new JComboBox<String>(itemList.toArray(new String[itemList.size()]));
        comboBox.setFont(insertCompFont);
        comboBox.setEditable(false);
        comboBox.setForeground(insertCompColor);
        comboBox.addActionListener(e -> {
            if (comboBox.getSelectedIndex() != 0) {
                this.insertCodePattern((String)comboBox.getSelectedItem());
                comboBox.setSelectedIndex(0);
            }
        });
        return comboBox;
    }

    public JList<String> createPatternList() {
        return this.createPatternList(null);
    }

    public JList<String> createPatternList(String[] patterns) {
        final JList<String> patternList = new JList<String>(patterns);
        patternList.setSelectionMode(0);
        ListCellRenderer<String> cellRenderer = patternList.getCellRenderer();
        Border cellBorder = BorderFactory.createEtchedBorder();
        patternList.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
            Component component1 = cellRenderer.getListCellRendererComponent(list, (String)value, index, isSelected, cellHasFocus);
            if (component1 instanceof JComponent) {
                ((JComponent)component1).setBorder(cellBorder);
            }
            return component1;
        });
        patternList.setFont(insertCompFont);
        patternList.setBackground(this.getBackground());
        patternList.setForeground(insertCompColor);
        patternList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = patternList.locationToIndex(e.getPoint());
                if (index >= 0) {
                    String value = (String)patternList.getModel().getElementAt(index);
                    String pattern = BandArithmetic.createExternalName((String)value);
                    ExpressionPane.this.insertCodePattern(pattern);
                    patternList.clearSelection();
                }
            }
        });
        return patternList;
    }

    protected JPanel createPatternListPane(String labelText, String[] patterns) {
        JList<String> list = this.createPatternList(patterns);
        JScrollPane scrollableList = new JScrollPane(list);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add("North", new JLabel(labelText));
        pane.add("Center", scrollableList);
        return pane;
    }

    protected void createUI() {
        this.codeArea = new JTextArea(10, 40);
        this.codeArea.setName("codeArea");
        this.codeArea.setLineWrap(true);
        this.codeArea.setWrapStyleWord(true);
        this.codeArea.setFont(exprTextAreaFont);
        this.codeArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExpressionPane.this.checkCode();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExpressionPane.this.checkCode();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExpressionPane.this.checkCode();
            }
        });
        this.actionPane = this.createActionPane();
        this.actionPane.setName("actionPane");
        this.messageLabel = new JLabel();
        this.messageLabel.setFont(this.getFont().deriveFont(10.0f));
        this.messageLabel.setHorizontalAlignment(4);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.actionPane, "West");
        panel.add((Component)this.messageLabel, "East");
        JScrollPane scrollableTextArea = new JScrollPane(this.codeArea);
        JPanel codePane = new JPanel(new BorderLayout());
        codePane.add((Component)new JLabel("Expression:"), "North");
        codePane.add((Component)scrollableTextArea, "Center");
        codePane.add((Component)panel, "South");
        this.add((Component)codePane, "Center");
        this.setCode("");
    }

    protected JPanel createPatternInsertionPane() {
        GridBagLayout gbl = new GridBagLayout();
        JPanel patternPane = new JPanel(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipadx = 1;
        gbc.ipady = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        if (this.booleanExpressionPreferred) {
            JButton andButton = this.createInsertButton("@ and @");
            JButton orButton = this.createInsertButton("@ or @");
            JButton notButton = this.createInsertButton("not @");
            andButton.setName("andButton");
            orButton.setName("orButton");
            notButton.setName("notButton");
            ExpressionPane.add(patternPane, andButton, gbc);
            ++gbc.gridy;
            ExpressionPane.add(patternPane, orButton, gbc);
            ++gbc.gridy;
            ExpressionPane.add(patternPane, notButton, gbc);
            ++gbc.gridy;
        } else {
            JButton plusButton = this.createInsertButton("@ + @");
            JButton minusButton = this.createInsertButton("@ - @");
            JButton mulButton = this.createInsertButton("@ * @");
            JButton divButton = this.createInsertButton("@ / @");
            plusButton.setName("plusButton");
            minusButton.setName("minusButton");
            mulButton.setName("mulButton");
            divButton.setName("divButton");
            ExpressionPane.add(patternPane, plusButton, gbc);
            ++gbc.gridy;
            ExpressionPane.add(patternPane, minusButton, gbc);
            ++gbc.gridy;
            ExpressionPane.add(patternPane, mulButton, gbc);
            ++gbc.gridy;
            ExpressionPane.add(patternPane, divButton, gbc);
            ++gbc.gridy;
        }
        String[] functionNames = this.getFunctionTemplates();
        JButton parenButton = this.createInsertButton("(@)");
        parenButton.setName("parenButton");
        JComboBox<String> functBox = this.createInsertComboBox("Functions...", functionNames);
        JComboBox<String> operBox = this.createInsertComboBox("Operators...", OPERATOR_PATTERNS);
        JComboBox<String> constBox = this.createInsertComboBox("Constants...", CONSTANT_LITERALS);
        functBox.setName("functBox");
        operBox.setName("operBox");
        constBox.setName("constBox");
        ExpressionPane.add(patternPane, parenButton, gbc);
        ++gbc.gridy;
        ExpressionPane.add(patternPane, constBox, gbc);
        ++gbc.gridy;
        ExpressionPane.add(patternPane, operBox, gbc);
        ++gbc.gridy;
        ExpressionPane.add(patternPane, functBox, gbc);
        ++gbc.gridy;
        return patternPane;
    }

    private String[] getFunctionTemplates() {
        Object[] functionNames;
        Namespace defaultNamespace = this.parser.getDefaultNamespace();
        if (defaultNamespace instanceof NamespaceImpl) {
            NamespaceImpl namespace = (NamespaceImpl)defaultNamespace;
            Function[] functions = namespace.getAllFunctions();
            functionNames = new String[functions.length];
            for (int i = 0; i < functions.length; ++i) {
                functionNames[i] = ExpressionPane.createFunctionTemplate(functions[i]);
            }
        } else {
            functionNames = FUNCTION_CALL_PATTERNS;
        }
        HashSet set = new HashSet();
        Collections.addAll(set, functionNames);
        functionNames = set.toArray(new String[set.size()]);
        Arrays.sort(functionNames);
        return functionNames;
    }

    private static String createFunctionTemplate(Function function) {
        StringBuilder sb = new StringBuilder(16);
        sb.append(function.getName());
        sb.append("(");
        for (int i = 0; i < function.getNumArgs(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(PLACEHOLDER);
        }
        sb.append(")");
        return sb.toString();
    }

    protected JPanel createDefaultAccessoryPane(Component subAssessory) {
        JPanel patternPane = this.createPatternInsertionPane();
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)new JLabel(" "), "North");
        p1.add((Component)patternPane, "Center");
        JPanel p2 = new JPanel(new BorderLayout(4, 4));
        p2.add((Component)p1, "North");
        if (subAssessory != null) {
            JPanel p3 = new JPanel(new BorderLayout(4, 4));
            p3.add(subAssessory, "West");
            p3.add((Component)p2, "East");
            return p3;
        }
        return p1;
    }

    private static void add(JPanel panel, Component comp, GridBagConstraints gbc) {
        GridBagLayout gbl = (GridBagLayout)panel.getLayout();
        gbl.setConstraints(comp, gbc);
        panel.add(comp, gbc);
    }

    protected void checkCode() {
        this.checkCode(this.getCode());
    }

    protected void checkCode(String code) {
        Color foreground;
        String message;
        block11: {
            this.lastErrorMessage = null;
            if (code == null || code.trim().isEmpty()) {
                if (this.emptyExpressionAllowed) {
                    return;
                }
                message = this.lastErrorMessage = "Empty expression not allowed.";
                foreground = warnMsgColor;
            } else if (code.contains(PLACEHOLDER)) {
                message = this.lastErrorMessage = "Replace '@' by inserting an element.";
                foreground = warnMsgColor;
            } else if (this.parser != null) {
                try {
                    Term term = this.parser.parse(code);
                    if (term != null && !BandArithmetic.areRastersEqualInSize((Term)term)) {
                        message = "Referenced rasters must all be of the same size";
                        foreground = warnMsgColor;
                        break block11;
                    }
                    if (term == null || !this.booleanExpressionPreferred || term.isB()) {
                        message = "Ok, no errors.";
                        foreground = okMsgColor;
                        break block11;
                    }
                    message = "Ok, but not a boolean expression.";
                    foreground = warnMsgColor;
                }
                catch (ParseException e) {
                    message = this.lastErrorMessage = e.getMessage();
                    foreground = warnMsgColor;
                }
            } else {
                message = "Ok, no errors.";
                foreground = okMsgColor;
            }
        }
        this.messageLabel.setText(message);
        this.messageLabel.setToolTipText(message);
        this.messageLabel.setForeground(foreground);
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    protected void updateUIState() {
        if (this.actionPane != null) {
            this.actionPane.updateUIState();
        }
    }

    private void pushCodeOnUndoStack(String code) {
        if (this.undoBuffer.isEmpty() || !code.equals(this.undoBuffer.peek())) {
            this.undoBuffer.push(code);
        }
    }

    private static String getTypeString(int type) {
        if (type == 1) {
            return "boolean";
        }
        if (type == 2) {
            return "int";
        }
        if (type == 3) {
            return "double";
        }
        return "?";
    }

    public static String getParamTypeString(String name, Term[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(ExpressionPane.getTypeString(args[i].getRetType()));
        }
        sb.append(')');
        return sb.toString();
    }

    private static String getFunctionCallPattern(Function function) {
        Object functionName = function.getName();
        int numArgs = function.getNumArgs();
        if (numArgs == -1) {
            return function.getName() + "(@, @, ...)";
        }
        if (numArgs == 0) {
            return function.getName() + "()";
        }
        functionName = (String)functionName + function.getName() + "(@";
        for (int j = 1; j < numArgs; ++j) {
            functionName = (String)functionName + ", @";
        }
        return (String)functionName + ")";
    }

    static {
        exprTextAreaFont = new Font("Courier", 0, 12);
        insertCompFont = new Font("Courier", 0, 11);
        insertCompColor = new Color(0, 0, 128);
        okMsgColor = new Color(0, 128, 0);
        warnMsgColor = new Color(128, 0, 0);
        List functions = Functions.getAll();
        FUNCTION_CALL_PATTERNS = new String[functions.size()];
        for (int i = 0; i < FUNCTION_CALL_PATTERNS.length; ++i) {
            ExpressionPane.FUNCTION_CALL_PATTERNS[i] = ExpressionPane.getFunctionCallPattern((Function)functions.get(i));
        }
    }

    class ExpressionPaneDialog
    extends ModalDialog {
        public ExpressionPaneDialog(Window parent, String title) {
            super(parent, title, ExpressionPane.this, 161, ExpressionPane.HELP_ID);
        }

        @Override
        protected void onOK() {
            ExpressionPane.this.updateCodeHistory();
            super.onOK();
        }

        @Override
        protected boolean verifyUserInput() {
            ExpressionPane.this.checkCode();
            String lastErrorMessage = ExpressionPane.this.getLastErrorMessage();
            if (lastErrorMessage != null) {
                JOptionPane.showMessageDialog(this.getJDialog(), lastErrorMessage, "Error", 0);
                return false;
            }
            return true;
        }
    }

    class ActionPane
    extends JPanel {
        private AbstractButton selAllButton;
        private AbstractButton undoButton;
        private AbstractButton clearButton;
        private AbstractButton historyUpButton;
        private AbstractButton historyDownButton;

        public ActionPane() {
            this.createUI();
        }

        protected void createUI() {
            this.selAllButton = ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/SelectAll24.gif"), false);
            this.selAllButton.setName("selAllButton");
            this.selAllButton.setToolTipText("Select all");
            this.selAllButton.addActionListener(e -> ExpressionPane.this.selectAllCode());
            this.clearButton = ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/Remove24.gif"), false);
            this.clearButton.setName("clearButton");
            this.clearButton.setToolTipText("Clear");
            this.clearButton.addActionListener(e -> ExpressionPane.this.clearCode());
            this.undoButton = ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/Undo24.gif"), false);
            this.undoButton.setName("undoButton");
            this.undoButton.setToolTipText("Undo");
            this.undoButton.addActionListener(e -> ExpressionPane.this.undoLastEdit());
            this.historyUpButton = ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/HistoryUp24.gif"), false);
            this.historyUpButton.setName("historyUpButton");
            this.historyUpButton.setToolTipText("Scroll history up");
            this.historyUpButton.addActionListener(e -> {
                if (ExpressionPane.this.history.size() > 0 && ExpressionPane.this.historyIndex < ExpressionPane.this.history.size()) {
                    ++ExpressionPane.this.historyIndex;
                    ExpressionPane.this.setCode(ExpressionPane.this.history.get(ExpressionPane.this.historyIndex));
                }
            });
            this.historyDownButton = ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/HistoryDown24.gif"), false);
            this.historyDownButton.setName("historyDownButton");
            this.historyDownButton.setToolTipText("Scroll history down");
            this.historyDownButton.addActionListener(e -> {
                if (ExpressionPane.this.history.size() > 0 && ExpressionPane.this.historyIndex >= 0) {
                    int oldHistoryIndex = ExpressionPane.this.historyIndex--;
                    ExpressionPane.this.setCode(ExpressionPane.this.history.get(oldHistoryIndex));
                }
            });
            this.add((Component)this.selAllButton, "West");
            this.add((Component)this.clearButton, "Center");
            this.add((Component)this.undoButton, "East");
            this.add(this.historyUpButton);
            this.add(this.historyDownButton);
        }

        protected void updateUIState() {
            String text = ExpressionPane.this.codeArea.getText();
            boolean hasText = text.length() > 0;
            boolean canUndo = !ExpressionPane.this.undoBuffer.isEmpty();
            boolean hasHistory = ExpressionPane.this.history != null && !ExpressionPane.this.history.isEmpty();
            this.selAllButton.setEnabled(hasText);
            this.clearButton.setEnabled(hasText);
            this.undoButton.setEnabled(canUndo);
            this.historyUpButton.setEnabled(hasHistory && ExpressionPane.this.historyIndex < ExpressionPane.this.history.size() - 1);
            this.historyDownButton.setEnabled(hasHistory && ExpressionPane.this.historyIndex >= 0);
        }
    }
}

