/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class ButtonOverlayControl
extends JComponent {
    private static final int BUTTON_SPACING = 3;
    private static final int BUTTON_AREA_INSET = 5;
    private static final int ARC_SIZE = 10;
    private final Dimension buttonDimension;
    private Rectangle2D.Double buttonArea;
    private List<ButtonDef> buttonDefList;
    private int numCols;

    public ButtonOverlayControl(Action ... actions) {
        this(2, actions);
    }

    public ButtonOverlayControl(int numCols, Action ... actions) {
        this.numCols = numCols;
        this.buttonDimension = new Dimension(24, 24);
        this.buttonDefList = new ArrayList<ButtonDef>();
        for (Action action : actions) {
            String toolTipText = (String)action.getValue("ToolTipText");
            this.buttonDefList.add(new ButtonDef(action, this.buttonDimension, numCols, toolTipText));
        }
        Dimension preferredSize = this.computePreferredSize();
        this.setPreferredSize(preferredSize);
        this.setBounds(0, 0, preferredSize.width, preferredSize.height);
        this.updateGeom(this.getPaintArea());
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return this.computePreferredSize();
    }

    @Override
    public final void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateGeom(this.getPaintArea());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle bounds = this.getPaintArea();
        if (bounds.isEmpty()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.setStroke(new BasicStroke(0.6f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawBackground(bounds, graphics2D);
        for (int i = 0; i < this.buttonDefList.size(); ++i) {
            this.drawButton(graphics2D, i);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (ButtonDef buttonDef : this.buttonDefList) {
            buttonDef.getAction().setEnabled(enabled);
        }
    }

    private void drawBackground(Rectangle bounds, Graphics2D graphics2D) {
        RoundRectangle2D.Double backgroundShape = new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height, 10.0, 10.0);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(backgroundShape);
        graphics2D.setColor(new Color(255, 255, 255, 64));
        graphics2D.fill(backgroundShape);
    }

    private void drawButton(Graphics2D graphics2D, int buttonIndex) {
        ButtonDef buttonDef = this.buttonDefList.get(buttonIndex);
        Shape shape = buttonDef.getShape();
        this.drawGradientShape(graphics2D, shape, buttonDef.isHighlighted());
        Image image = buttonDef.getImage();
        Point imageOffset = buttonDef.getImageOffset();
        graphics2D.drawImage(image, imageOffset.x, imageOffset.y, null);
    }

    private void drawGradientShape(Graphics2D graphics2D, Shape shape, boolean highlighted) {
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(shape);
        Point startPos = shape.getBounds().getLocation();
        Point endPos = (Point)startPos.clone();
        endPos.y = startPos.y + shape.getBounds().height;
        LinearGradientPaint paint = highlighted ? new LinearGradientPaint(startPos, endPos, new float[]{0.0f, 0.5f, 0.6f, 0.8f, 1.0f}, new Color[]{new Color(255, 255, 255, 64), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 160), new Color(0, 0, 0, 160)}) : new LinearGradientPaint(startPos, endPos, new float[]{0.0f, 0.5f, 0.6f, 0.8f, 1.0f}, new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 64), new Color(255, 255, 255, 64), new Color(255, 255, 255, 30), new Color(0, 0, 0, 40)});
        graphics2D.setPaint(paint);
        graphics2D.fill(shape);
    }

    private Point computeButtonLocation(int buttonIndex) {
        int xIndex = buttonIndex % this.numCols;
        int yIndex = buttonIndex / this.numCols;
        int xLocation = (int)this.buttonArea.x + xIndex * (this.buttonDimension.width + 3);
        int yLocation = (int)this.buttonArea.y + yIndex * (this.buttonDimension.height + 3);
        return new Point(xLocation, yLocation);
    }

    private Dimension computePreferredSize() {
        int numButtons = this.buttonDefList.size();
        int buttonCols = numButtons <= 1 ? 1 : this.numCols;
        int buttonRows = numButtons <= 1 ? 1 : (numButtons + 1) / buttonCols;
        int width = 5;
        int height = 5;
        width += buttonCols * this.buttonDimension.width;
        height += buttonRows * this.buttonDimension.height;
        width += (buttonCols - 1) * 3;
        height += (buttonRows - 1) * 3;
        return new Dimension(width += 5, height += 5);
    }

    private void updateGeom(Rectangle bounds) {
        this.buttonArea = new Rectangle2D.Double(bounds.x + 5 - 1, bounds.y + 5 - 1, bounds.width - 10 + 2, bounds.height - 10 + 2);
        for (int i = 0; i < this.buttonDefList.size(); ++i) {
            ButtonDef buttonDef = this.buttonDefList.get(i);
            buttonDef.setShapeLocation(this.computeButtonLocation(i));
        }
    }

    private Rectangle getPaintArea() {
        Insets insets = this.getInsets();
        int x = insets.left + 1;
        int y = insets.top + 1;
        int w = this.getWidth() - (insets.left + insets.right) - 2;
        int h = this.getHeight() - (insets.top + insets.bottom) - 2;
        return new Rectangle(x, y, w, h);
    }

    private ButtonDef getButtonDef(int x, int y) {
        for (ButtonDef buttonDef : this.buttonDefList) {
            if (!buttonDef.getShape().contains(x, y)) continue;
            return buttonDef;
        }
        return null;
    }

    private static class ButtonDef {
        private final Action action;
        private final int numCols;
        private final Image image;
        private RoundRectangle2D.Double shape;
        private boolean highlighted;
        private String toolTipText;

        private ButtonDef(Action action, Dimension buttonDimension, int numCols, String toolTipText) {
            this.action = action;
            this.numCols = numCols;
            this.toolTipText = toolTipText;
            Image rawImage = ButtonDef.iconToImage((Icon)this.action.getValue("SwingLargeIconKey"));
            this.image = rawImage.getScaledInstance(buttonDimension.width, buttonDimension.height, 4);
            this.shape = new RoundRectangle2D.Double();
            this.shape.arcwidth = 4.0;
            this.shape.archeight = 4.0;
            this.shape.setFrame(new Point(), buttonDimension);
        }

        public Action getAction() {
            return this.action;
        }

        public Image getImage() {
            return this.image;
        }

        public Point getImageOffset() {
            Rectangle bounds = this.shape.getBounds();
            int xOffset = bounds.x + (bounds.width - this.image.getWidth(null)) / this.numCols;
            int yOffset = bounds.y + (bounds.height - this.image.getHeight(null)) / this.numCols;
            return new Point(xOffset, yOffset);
        }

        public Shape getShape() {
            return (Shape)this.shape.clone();
        }

        public void setShapeLocation(Point point) {
            this.shape.setFrame(point, this.shape.getBounds().getSize());
        }

        public void setShapeDimension(Dimension dimension) {
            this.shape.setFrame(this.shape.getBounds().getLocation(), dimension);
        }

        private static Image iconToImage(Icon icon) {
            if (icon instanceof ImageIcon) {
                return ((ImageIcon)icon).getImage();
            }
            int w = icon.getIconWidth();
            int h = icon.getIconHeight();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            BufferedImage image = gc.createCompatibleImage(w, h);
            Graphics2D g = image.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            return image;
        }

        private String getToolTipText() {
            return this.toolTipText;
        }

        public void setHighlighted(boolean highlighted) {
            this.highlighted = highlighted;
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ButtonDef buttonDef = ButtonOverlayControl.this.getButtonDef(e.getX(), e.getY());
            if (buttonDef != null) {
                Action action = buttonDef.getAction();
                action.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.paramString()));
                e.consume();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            for (ButtonDef buttonDef : ButtonOverlayControl.this.buttonDefList) {
                if (buttonDef.getShape().contains(e.getX(), e.getY())) {
                    buttonDef.setHighlighted(true);
                    String toolTipText = buttonDef.getToolTipText();
                    ButtonOverlayControl.this.setToolTipText(toolTipText);
                    continue;
                }
                buttonDef.setHighlighted(false);
            }
            ButtonOverlayControl.this.repaint();
        }
    }
}

