/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.esa.snap.statistics.StatisticsOp;

public class StatisticalMappingAnalyser {
    private final TreeSet<String> statisticalMeasure;
    private final TreeSet<String> geophysicalParameter;

    public StatisticalMappingAnalyser(Set<String> fullNames) {
        int[] defaultPercentiles = StatisticsOp.DEFAULT_PERCENTILES_INTS;
        String[] measureNames = StatisticalMappingAnalyser.getMeasureNames(defaultPercentiles);
        StatisticalMappingAnalyser.sortAlongLength_BiggestFirst(measureNames);
        this.geophysicalParameter = new TreeSet();
        this.statisticalMeasure = new TreeSet();
        block0: for (String fullName : fullNames) {
            for (String measureName : measureNames) {
                if (!fullName.startsWith(measureName)) continue;
                this.statisticalMeasure.add(measureName);
                String paramName = fullName.substring(measureName.length());
                this.geophysicalParameter.add(this.trimWithUnderscores(paramName));
                continue block0;
            }
        }
    }

    private static String[] getMeasureNames(int[] percentiles) {
        ArrayList<Object> algorithms = new ArrayList<Object>();
        algorithms.add("minimum");
        algorithms.add("maximum");
        algorithms.add("median");
        algorithms.add("average");
        algorithms.add("sigma");
        for (int percentile : percentiles) {
            algorithms.add("p" + percentile + "_threshold");
        }
        algorithms.add("max_error");
        algorithms.add("total");
        return algorithms.toArray(new String[0]);
    }

    public String[] getStatisticalMeasureNames() {
        return this.toStrings(this.statisticalMeasure);
    }

    public String[] getGeophysicalParameterNames() {
        return this.toStrings(this.geophysicalParameter);
    }

    private String trimWithUnderscores(String s) {
        while (s.startsWith("_") && s.length() > 1) {
            s = s.substring(1);
            s = s.trim();
        }
        while (s.endsWith("_") && s.length() > 1) {
            s = s.substring(0, s.length() - 1);
            s = s.trim();
        }
        return s;
    }

    private String[] toStrings(Set<String> set) {
        return set.toArray(new String[set.size()]);
    }

    public static void sortAlongLength_BiggestFirst(String[] measureNames) {
        Arrays.sort(measureNames, (o1, o2) -> o2.length() - o1.length());
    }
}

