/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.statistics.output.BandNameCreator;
import org.esa.snap.statistics.output.EsriShapeFileWriter;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.esa.snap.statistics.output.StatisticsOutputter;
import org.esa.snap.statistics.output.Util;
import org.esa.snap.statistics.tools.TimeInterval;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureStatisticsWriter
implements StatisticsOutputter {
    private static final double FILL_VALUE = -999.0;
    private final String targetShapefile;
    private final FeatureCollection<SimpleFeatureType, SimpleFeature> originalFeatures;
    private final SimpleFeatureType originalFeatureType;
    private final BandNameCreator bandNameCreator;
    private SimpleFeatureType updatedFeatureType;
    private final List<SimpleFeature> features;

    public static FeatureStatisticsWriter createFeatureStatisticsWriter(URL originalShapefile, String targetShapefile, BandNameCreator bandNameCreator) {
        FeatureCollection features;
        FeatureSource featureSource;
        try {
            featureSource = FeatureUtils.getFeatureSource((URL)originalShapefile);
            features = featureSource.getFeatures();
        }
        catch (IOException e) {
            throw new OperatorException("Unable to initialise the output.", (Throwable)e);
        }
        return new FeatureStatisticsWriter((SimpleFeatureType)featureSource.getSchema(), targetShapefile, (FeatureCollection<SimpleFeatureType, SimpleFeature>)features, bandNameCreator);
    }

    public static FeatureStatisticsWriter createFeatureStatisticsWriter(FeatureCollection<SimpleFeatureType, SimpleFeature> originalFeatures, String targetShapefile, BandNameCreator bandNameCreator) {
        return new FeatureStatisticsWriter((SimpleFeatureType)originalFeatures.getSchema(), targetShapefile, originalFeatures, bandNameCreator);
    }

    private FeatureStatisticsWriter(SimpleFeatureType originalFeatureType, String targetShapefile, FeatureCollection<SimpleFeatureType, SimpleFeature> originalFeatures, BandNameCreator bandNameCreator) {
        this.originalFeatureType = originalFeatureType;
        this.targetShapefile = targetShapefile;
        this.originalFeatures = originalFeatures;
        this.bandNameCreator = bandNameCreator;
        this.features = new ArrayList<SimpleFeature>();
    }

    @Override
    public void initialiseOutput(StatisticsOutputContext statisticsOutputContext) {
        Arrays.sort(statisticsOutputContext.measureNames);
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.init(this.originalFeatureType);
        for (String measureName : statisticsOutputContext.measureNames) {
            for (String bandName : statisticsOutputContext.bandNames) {
                if (statisticsOutputContext.timeIntervals == null || statisticsOutputContext.timeIntervals.length <= 1) {
                    String attributeName = this.bandNameCreator.createUniqueAttributeName(measureName, bandName);
                    if (this.originalFeatureType.getDescriptor(attributeName) != null) continue;
                    if (statisticsOutputContext.isNotNumber(measureName)) {
                        typeBuilder.add(attributeName, String.class);
                        continue;
                    }
                    typeBuilder.add(attributeName, Double.class);
                    continue;
                }
                for (TimeInterval timeInterval : statisticsOutputContext.timeIntervals) {
                    String attributeName = this.bandNameCreator.createUniqueAttributeName(measureName, bandName, timeInterval);
                    if (this.originalFeatureType.getDescriptor(attributeName) != null) continue;
                    if (statisticsOutputContext.isNotNumber(measureName)) {
                        typeBuilder.add(attributeName, String.class);
                        continue;
                    }
                    typeBuilder.add(attributeName, Double.class);
                }
            }
        }
        typeBuilder.setName(this.originalFeatureType.getName());
        this.updatedFeatureType = typeBuilder.buildFeatureType();
    }

    @Override
    public void addToOutput(String bandName, String regionId, Map<String, Object> statistics) {
        String name;
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(this.updatedFeatureType);
        ArrayList<SimpleFeature> markedToRemove = new ArrayList<SimpleFeature>();
        HashMap<String, SimpleFeature> markedToAdd = new HashMap<String, SimpleFeature>();
        for (SimpleFeature feature : this.features) {
            for (String measureName : statistics.keySet()) {
                name = this.bandNameCreator.createUniqueAttributeName(measureName, bandName);
                if (!Util.getFeatureName(feature).equals(regionId)) continue;
                SimpleFeature featureToUpdate = markedToAdd.containsKey(regionId) ? (SimpleFeature)markedToAdd.get(regionId) : feature;
                SimpleFeature updatedFeature = FeatureStatisticsWriter.createUpdatedFeature(simpleFeatureBuilder, featureToUpdate, name, statistics.get(measureName));
                markedToRemove.add(feature);
                markedToAdd.put(regionId, updatedFeature);
            }
        }
        this.features.removeAll(markedToRemove);
        this.features.addAll(markedToAdd.values());
        if (!markedToAdd.isEmpty() || !markedToRemove.isEmpty()) {
            return;
        }
        FeatureIterator featureIterator = this.originalFeatures.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature;
            feature = (SimpleFeature)featureIterator.next();
            for (String measureName : statistics.keySet()) {
                name = this.bandNameCreator.createUniqueAttributeName(measureName, bandName);
                Object value = this.getValue(statistics, measureName, feature, regionId);
                feature = FeatureStatisticsWriter.createUpdatedFeature(simpleFeatureBuilder, feature, name, value);
            }
            this.features.add(feature);
        }
    }

    @Override
    public void addToOutput(String bandName, TimeInterval interval, String regionId, Map<String, Object> statistics) {
        String name;
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(this.updatedFeatureType);
        ArrayList<SimpleFeature> markedToRemove = new ArrayList<SimpleFeature>();
        HashMap<String, SimpleFeature> markedToAdd = new HashMap<String, SimpleFeature>();
        for (SimpleFeature feature : this.features) {
            for (String measureName : statistics.keySet()) {
                name = this.bandNameCreator.getUniqueAttributeName(measureName, bandName, interval);
                if (!Util.getFeatureName(feature).equals(regionId)) continue;
                SimpleFeature featureToUpdate = markedToAdd.containsKey(regionId) ? (SimpleFeature)markedToAdd.get(regionId) : feature;
                SimpleFeature updatedFeature = FeatureStatisticsWriter.createUpdatedFeature(simpleFeatureBuilder, featureToUpdate, name, statistics.get(measureName));
                markedToRemove.add(feature);
                markedToAdd.put(regionId, updatedFeature);
            }
        }
        this.features.removeAll(markedToRemove);
        this.features.addAll(markedToAdd.values());
        if (!markedToAdd.isEmpty() || !markedToRemove.isEmpty()) {
            return;
        }
        FeatureIterator featureIterator = this.originalFeatures.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature;
            feature = (SimpleFeature)featureIterator.next();
            for (String measureName : statistics.keySet()) {
                name = this.bandNameCreator.getUniqueAttributeName(measureName, bandName, interval);
                Object value = this.getValue(statistics, measureName, feature, regionId);
                feature = FeatureStatisticsWriter.createUpdatedFeature(simpleFeatureBuilder, feature, name, value);
            }
            this.features.add(feature);
        }
    }

    private Object getValue(Map<String, Object> statistics, String measureName, SimpleFeature originalFeature, String regionId) {
        if (Util.getFeatureName(originalFeature).equals(regionId)) {
            return statistics.get(measureName);
        }
        return -999.0;
    }

    @Override
    public void finaliseOutput() throws IOException {
        EsriShapeFileWriter.write(this.features, new File(this.targetShapefile));
    }

    public List<SimpleFeature> getFeatures() {
        return this.features;
    }

    public SimpleFeatureType getUpdatedFeatureType() {
        return this.updatedFeatureType;
    }

    private static SimpleFeature createUpdatedFeature(SimpleFeatureBuilder builder, SimpleFeature baseFeature, String name, Object value) {
        builder.init(baseFeature);
        builder.set(name, value);
        return builder.buildFeature(baseFeature.getID());
    }
}

