/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.esa.snap.statistics.output.StatisticsOutputter;
import org.esa.snap.statistics.tools.TimeInterval;

public class CsvStatisticsWriter
implements StatisticsOutputter {
    private final PrintStream csvOutput;
    private String[] measureNames;
    private Measures measures;
    private String featureId;

    public CsvStatisticsWriter(PrintStream csvOutput) {
        this.csvOutput = csvOutput;
        this.measures = new Measures();
    }

    @Override
    public void initialiseOutput(StatisticsOutputContext statisticsOutputContext) {
        this.measureNames = statisticsOutputContext.measureNames;
        this.featureId = statisticsOutputContext.featureId;
        Arrays.sort(this.measureNames);
    }

    @Override
    public void addToOutput(String bandName, String regionId, Map<String, Object> statistics) {
        this.measures.addMeasure(new Measure(bandName, null, regionId, statistics));
    }

    @Override
    public void addToOutput(String bandName, TimeInterval interval, String regionId, Map<String, Object> statistics) {
        this.measures.addMeasure(new Measure(bandName, interval, regionId, statistics));
    }

    @Override
    public void finaliseOutput() {
        if (this.measureNames == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " not initialised.");
        }
        this.writeHeader();
        this.measures.sort();
        for (int i = 0; i < this.measures.getSize(); ++i) {
            Measure measure = this.measures.getMeasure(i);
            if (this.measures.hasRegions()) {
                if (measure.regionId != null) {
                    this.csvOutput.append(measure.regionId).append("\t");
                } else {
                    this.csvOutput.append("\t").append("\t");
                }
            }
            if (this.measures.hasTimeIntervals()) {
                if (measure.interval != null) {
                    this.csvOutput.append(measure.interval.getIntervalStart().format()).append("\t").append(measure.interval.getIntervalEnd().format()).append("\t");
                } else {
                    this.csvOutput.append("\t").append("\t").append("\t").append("\t");
                }
            }
            if (this.measures.hasBands()) {
                if (measure.bandName != null) {
                    this.csvOutput.append(measure.bandName);
                } else {
                    this.csvOutput.append("\t");
                }
            }
            for (String measureName : this.measureNames) {
                this.csvOutput.append("\t");
                if (!measure.statistics.containsKey(measureName)) continue;
                Object value = measure.statistics.get(measureName);
                if (value instanceof Number) {
                    this.csvOutput.append(CsvStatisticsWriter.getValueAsString((Number)value));
                    continue;
                }
                this.csvOutput.append(value.toString());
            }
            this.csvOutput.append("\n");
        }
    }

    private void writeHeader() {
        if (this.measures.hasRegions()) {
            this.csvOutput.append(this.featureId).append("\t");
        }
        if (this.measures.hasTimeIntervals()) {
            this.csvOutput.append("Interval_Start").append("\t").append("Interval_End").append("\t");
        }
        if (this.measures.hasBands()) {
            this.csvOutput.append("Band").append("\t");
        }
        for (int i = 0; i < this.measureNames.length; ++i) {
            String measureName = this.measureNames[i];
            this.csvOutput.append(measureName);
            if (i >= this.measureNames.length - 1) continue;
            this.csvOutput.append("\t");
        }
        this.csvOutput.append("\n");
    }

    static String getValueAsString(Number numberValue) {
        if (numberValue instanceof Float || numberValue instanceof Double) {
            return String.format(Locale.ENGLISH, "%.4f", numberValue.doubleValue());
        }
        return numberValue.toString();
    }

    private class MeasureManager<T extends Comparable<? super T>> {
        private final List<T> elements = new ArrayList<T>();
        private final int measureIndex;

        MeasureManager(int measureIndex) {
            this.measureIndex = measureIndex;
        }

        public void add(T o) {
            if (this.elements.contains(o)) {
                return;
            }
            this.elements.add(o);
            Collections.sort(this.elements);
        }

        List<Measure> getSubListForIndex(List<Measure> measures, int index) {
            Comparable comparable = (Comparable)this.elements.get(index);
            ArrayList<Measure> subMeasures = new ArrayList<Measure>();
            for (Measure measure : measures) {
                if (!measure.get(this.measureIndex).equals(comparable)) continue;
                subMeasures.add(measure);
            }
            return subMeasures;
        }

        public int size() {
            return this.elements.size();
        }
    }

    private class Measures {
        static final int POLYGON_INTERVAL_BAND = 0;
        static final int POLYGON_BAND_INTERVAL = 1;
        static final int INTERVAL_POLYGON_BAND = 2;
        static final int INTERVAL_BAND_POLYGON = 3;
        static final int BAND_POLYGON_INTERVAL = 4;
        static final int BAND_INTERVAL_POLYGON = 5;
        private int order;
        private List<Measure> measures;
        private final MeasureManager<String> bandNamesManager;
        private final MeasureManager<String> regionIDsManager;
        private final MeasureManager<TimeInterval> timeIntervalsManager;

        Measures() {
            this(0);
        }

        Measures(int order) {
            this.order = order;
            this.measures = new ArrayList<Measure>();
            this.bandNamesManager = new MeasureManager(0);
            this.regionIDsManager = new MeasureManager(2);
            this.timeIntervalsManager = new MeasureManager(1);
        }

        boolean hasRegions() {
            return this.regionIDsManager.size() > 0;
        }

        boolean hasBands() {
            return this.bandNamesManager.size() > 0;
        }

        boolean hasTimeIntervals() {
            return this.timeIntervalsManager.size() > 0;
        }

        void addMeasure(Measure measure) {
            this.measures.add(measure);
            if (measure.bandName != null) {
                this.bandNamesManager.add(measure.bandName);
            }
            if (measure.interval != null) {
                this.timeIntervalsManager.add(measure.interval);
            }
            if (measure.regionId != null) {
                this.regionIDsManager.add(measure.regionId);
            }
        }

        Measure getMeasure(int index) {
            return this.measures.get(index);
        }

        void sort() {
            ArrayList<Measure> sortedMeasures = new ArrayList<Measure>();
            MeasureManager[] managers = this.getManagers();
            this.sort(this.measures, sortedMeasures, 0, managers);
            this.measures = sortedMeasures;
        }

        private void sort(List<Measure> measureList, List<Measure> sortedMeasures, int recursionDepth, MeasureManager[] managers) {
            if (recursionDepth < managers.length) {
                if (managers[recursionDepth].size() == 0) {
                    this.sort(measureList, sortedMeasures, recursionDepth + 1, managers);
                } else {
                    for (int i = 0; i < managers[recursionDepth].size(); ++i) {
                        List<Measure> subList = managers[recursionDepth].getSubListForIndex(measureList, i);
                        this.sort(subList, sortedMeasures, recursionDepth + 1, managers);
                    }
                }
            } else {
                sortedMeasures.addAll(measureList);
            }
        }

        void setOrder(int order) {
            this.order = order;
        }

        int getSize() {
            return this.measures.size();
        }

        private MeasureManager[] getManagers() {
            switch (this.order) {
                case 0: {
                    return new MeasureManager[]{this.regionIDsManager, this.timeIntervalsManager, this.bandNamesManager};
                }
                case 1: {
                    return new MeasureManager[]{this.regionIDsManager, this.bandNamesManager, this.timeIntervalsManager};
                }
                case 2: {
                    return new MeasureManager[]{this.timeIntervalsManager, this.regionIDsManager, this.bandNamesManager};
                }
                case 3: {
                    return new MeasureManager[]{this.timeIntervalsManager, this.bandNamesManager, this.regionIDsManager};
                }
                case 4: {
                    return new MeasureManager[]{this.bandNamesManager, this.regionIDsManager, this.timeIntervalsManager};
                }
            }
            return new MeasureManager[]{this.bandNamesManager, this.timeIntervalsManager, this.regionIDsManager};
        }
    }

    private class Measure {
        static final int BAND_NAME = 0;
        static final int INTERVAL = 1;
        static final int REGION_ID = 2;
        private final String bandName;
        private final TimeInterval interval;
        private final String regionId;
        private final Map<String, Object> statistics;

        Measure(String bandName, TimeInterval interval, String regionId, Map<String, Object> statistics) {
            this.bandName = bandName;
            this.interval = interval;
            this.regionId = regionId;
            this.statistics = new TreeMap<String, Object>();
            this.statistics.putAll(statistics);
        }

        Comparable get(int index) {
            switch (index) {
                case 0: {
                    return this.bandName;
                }
                case 1: {
                    return this.interval;
                }
                case 2: {
                    return this.regionId;
                }
            }
            return this.bandName;
        }
    }
}

