/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.statistics.tools.TimeInterval;

public class BandNameCreator {
    private Map<String, Integer> indexMap;
    private final PrintStream printStream;
    private Map<String, String> mappedNames;

    public BandNameCreator() {
        this(new PrintStream(new NullOutputStream()));
    }

    public BandNameCreator(PrintStream printStream) {
        this.printStream = printStream;
        this.indexMap = new HashMap<String, Integer>();
        this.mappedNames = new HashMap<String, String>();
    }

    public String createUniqueAttributeName(String measureName, String sourceBandName) {
        boolean tooLong;
        String desiredAttributeName = measureName + "_" + sourceBandName;
        if (this.mappedNames.containsKey(desiredAttributeName)) {
            return this.mappedNames.get(desiredAttributeName);
        }
        Object attributeName = desiredAttributeName;
        boolean bl = tooLong = desiredAttributeName.length() > 10;
        if (tooLong) {
            attributeName = measureName + "_" + sourceBandName.replace("_", "");
            attributeName = BandNameCreator.shorten((String)attributeName);
        }
        if (((String)attributeName).length() > 10) {
            int index = this.getIndex(sourceBandName);
            attributeName = BandNameCreator.shorten(measureName) + "_" + index;
            if (((String)attributeName).length() > 10) {
                String indexPart = Integer.toString(index);
                int idxLength = indexPart.length();
                attributeName = ((String)attributeName).substring(0, 10 - idxLength - 1) + "_" + indexPart;
            }
        }
        if (tooLong) {
            SystemUtils.LOG.warning("attribute name '" + desiredAttributeName + "' exceeds 10 characters in length. Shortened to '" + (String)attributeName + "'.");
        }
        this.addMapping(desiredAttributeName, (String)attributeName);
        this.print(desiredAttributeName, (String)attributeName, null);
        return attributeName;
    }

    public String createUniqueAttributeName(String measureName, String sourceBandName, TimeInterval timeInterval) {
        boolean tooLong;
        String desiredAttributeName = measureName + "_" + sourceBandName + "_" + timeInterval.getId();
        if (this.mappedNames.containsKey(desiredAttributeName)) {
            return this.mappedNames.get(desiredAttributeName);
        }
        Object attributeName = desiredAttributeName;
        boolean bl = tooLong = desiredAttributeName.length() > 10;
        if (tooLong) {
            attributeName = measureName + "_" + sourceBandName.replace("_", "") + "_" + timeInterval.getId();
            attributeName = BandNameCreator.shorten((String)attributeName);
        }
        if (((String)attributeName).length() > 10) {
            int index = this.getIndex(sourceBandName);
            attributeName = BandNameCreator.shorten(measureName) + "_" + index + "_" + timeInterval.getId();
            if (((String)attributeName).length() > 10) {
                String indexPart = Integer.toString(index);
                int idxLength = indexPart.length();
                String intervalIdPart = Integer.toString(timeInterval.getId());
                int intervalIdLength = intervalIdPart.length();
                attributeName = ((String)attributeName).substring(0, 10 - idxLength - intervalIdLength - 2) + "_" + indexPart + "_" + intervalIdPart;
            }
        }
        if (tooLong) {
            SystemUtils.LOG.warning("attribute name '" + desiredAttributeName + "' exceeds 10 characters in length. Shortened to '" + (String)attributeName + "'.");
        }
        this.addMapping(desiredAttributeName, (String)attributeName);
        this.print(desiredAttributeName, (String)attributeName, timeInterval);
        return attributeName;
    }

    String getUniqueAttributeName(String measureName, String sourceBandName, TimeInterval timeInterval) {
        String desiredAttributeName = measureName + "_" + sourceBandName + "_" + timeInterval.getId();
        if (this.mappedNames.containsKey(desiredAttributeName)) {
            return this.mappedNames.get(desiredAttributeName);
        }
        return this.getUniqueAttributeName(measureName, sourceBandName);
    }

    private String getUniqueAttributeName(String measureName, String sourceBandName) {
        String desiredAttributeName = measureName + "_" + sourceBandName;
        if (this.mappedNames.containsKey(desiredAttributeName)) {
            return this.mappedNames.get(desiredAttributeName);
        }
        throw new IllegalArgumentException("No such attribute: " + desiredAttributeName);
    }

    private static String shorten(String attributeName) {
        attributeName = attributeName.replace("minimum", "mn").replace("maximum", "mx").replace("_threshold", "");
        attributeName = attributeName.replace("a", "").replace("e", "").replace("i", "").replace("o", "").replace("u", "");
        return attributeName;
    }

    private synchronized int getIndex(String attributeName) {
        if (!this.indexMap.containsKey(attributeName)) {
            this.indexMap.put(attributeName, this.indexMap.size());
        }
        return this.indexMap.get(attributeName);
    }

    private void addMapping(String desiredAttributeName, String attributeName) {
        this.mappedNames.put(desiredAttributeName, attributeName);
    }

    private void print(String desiredAttributeName, String attributeName, TimeInterval timeInterval) {
        this.printStream.append(attributeName).append("=").append(desiredAttributeName);
        if (timeInterval != null) {
            this.printStream.append(" between ").append(timeInterval.getIntervalStart().format()).append(" and ").append(timeInterval.getIntervalEnd().format());
        }
        this.printStream.append("\n");
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

