/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.unit;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractUnit;
import tec.uom.se.quantity.QuantityDimension;

public final class ProductUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 962983585531030093L;
    private final Element[] elements;
    private final String symbol;

    public ProductUnit() {
        this.symbol = "";
        this.elements = new Element[0];
    }

    public ProductUnit(Unit<?> productUnit) {
        this.symbol = productUnit.getSymbol();
        this.elements = ((ProductUnit)productUnit).elements;
    }

    private ProductUnit(Element[] elements) {
        this.elements = elements;
        this.symbol = null;
    }

    public static AbstractUnit<?> getProductInstance(Unit<?> left, Unit<?> right) {
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left).elements : new Element[]{new Element(left, 1, 1)};
        Element[] rightElems = right instanceof ProductUnit ? ((ProductUnit)right).elements : new Element[]{new Element(right, 1, 1)};
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    public static AbstractUnit<?> getQuotientInstance(Unit<?> left, Unit<?> right) {
        Element[] rightElems;
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left).elements : new Element[]{new Element(left, 1, 1)};
        if (right instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)right).elements;
            rightElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                rightElems[i] = new Element(elems[i].unit, -elems[i].pow, elems[i].root);
            }
        } else {
            rightElems = new Element[]{new Element(right, -1, 1)};
        }
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    public static AbstractUnit<?> getRootInstance(Unit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit).elements;
            unitElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i].pow), elems[i].root * n);
                unitElems[i] = new Element(elems[i].unit, elems[i].pow / gcd, elems[i].root * n / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, 1, n)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    public static AbstractUnit<?> getPowInstance(Unit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit).elements;
            unitElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i].pow * n), elems[i].root);
                unitElems[i] = new Element(elems[i].unit, elems[i].pow * n / gcd, elems[i].root / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, n, 1)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    public int getUnitCount() {
        return this.elements.length;
    }

    public Unit<?> getUnit(int index) {
        return this.elements[index].getUnit();
    }

    public int getUnitPow(int index) {
        return this.elements[index].getPow();
    }

    public int getUnitRoot(int index) {
        return this.elements[index].getRoot();
    }

    @Override
    public Map<Unit<?>, Integer> getBaseUnits() {
        HashMap units = new HashMap();
        for (int i = 0; i < this.getUnitCount(); ++i) {
            units.put(this.getUnit(i), this.getUnitPow(i));
        }
        return units;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProductUnit) {
            ProductUnit other = (ProductUnit)obj;
            Arrays.sort(this.elements);
            Arrays.sort(other.elements);
            return Arrays.equals(this.elements, other.elements);
        }
        if (obj instanceof Unit) {
            return this.elements.length == 1 && this.elements[0].pow == this.elements[0].root && obj.equals(this.elements[0].unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.elements.length == 1 && this.equals(this.elements[0])) {
            return this.elements[0].hashCode();
        }
        Arrays.sort(this.elements);
        return Arrays.hashCode(this.elements);
    }

    @Override
    public AbstractUnit<Q> toSystemUnit() {
        Unit systemUnit = AbstractUnit.ONE;
        for (Element element : this.elements) {
            Unit unit = element.unit.getSystemUnit();
            unit = unit.pow(element.pow);
            unit = unit.root(element.root);
            systemUnit = systemUnit.multiply(unit);
        }
        return systemUnit;
    }

    @Override
    public boolean isSystemUnit() {
        for (Element element : this.elements) {
            if (element.unit instanceof AbstractUnit && ((AbstractUnit)element.unit).isSystemUnit()) continue;
            return super.isSystemUnit();
        }
        return true;
    }

    @Override
    public UnitConverter getSystemConverter() {
        AbstractConverter converter = AbstractConverter.IDENTITY;
        for (Element e : this.elements) {
            if (!(e.unit instanceof AbstractUnit)) continue;
            UnitConverter cvtr = ((AbstractUnit)e.unit).getSystemConverter();
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException(e.unit + " is non-linear, cannot convert");
            }
            if (e.root != 1) {
                throw new UnsupportedOperationException(e.unit + " holds a base unit with fractional exponent");
            }
            int pow = e.pow;
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j = 0; j < pow; ++j) {
                converter = converter.concatenate(cvtr);
            }
        }
        return converter;
    }

    @Override
    public Dimension getDimension() {
        Dimension dimension = QuantityDimension.NONE;
        for (int i = 0; i < this.getUnitCount(); ++i) {
            Unit<?> unit = this.getUnit(i);
            if (this.elements == null || unit.getDimension() == null) continue;
            Dimension d = unit.getDimension().pow(this.getUnitPow(i)).root(this.getUnitRoot(i));
            dimension = dimension.multiply(d);
        }
        return dimension;
    }

    private static AbstractUnit<?> getInstance(Element[] leftElems, Element[] rightElems) {
        Unit unit;
        Element[] result = new Element[leftElems.length + rightElems.length];
        int resultIndex = 0;
        for (Element leftElem : leftElems) {
            unit = leftElem.unit;
            int p1 = leftElem.pow;
            int r1 = leftElem.root;
            int p2 = 0;
            int r2 = 1;
            for (Element rightElem : rightElems) {
                if (!unit.equals(rightElem.unit)) continue;
                p2 = rightElem.pow;
                r2 = rightElem.root;
                break;
            }
            int pow = p1 * r2 + p2 * r1;
            int root = r1 * r2;
            if (pow == 0) continue;
            int gcd = ProductUnit.gcd(Math.abs(pow), root);
            result[resultIndex++] = new Element(unit, pow / gcd, root / gcd);
        }
        for (Element rightElem : rightElems) {
            unit = rightElem.unit;
            boolean hasBeenMerged = false;
            for (Element leftElem : leftElems) {
                if (!unit.equals(leftElem.unit)) continue;
                hasBeenMerged = true;
                break;
            }
            if (hasBeenMerged) continue;
            result[resultIndex++] = rightElem;
        }
        if (resultIndex == 0) {
            return AbstractUnit.ONE;
        }
        if (resultIndex == 1 && result[0].pow == result[0].root) {
            return ProductUnit.maybeWrap(result[0].unit);
        }
        Element[] elems = new Element[resultIndex];
        System.arraycopy(result, 0, elems, 0, resultIndex);
        return new ProductUnit(elems);
    }

    private static <Q extends Quantity<Q>> AbstractUnit<Q> maybeWrap(Unit<Q> unit) {
        if (unit instanceof AbstractUnit) {
            return (AbstractUnit)unit;
        }
        return new ProductUnit<Q>(unit);
    }

    private static int gcd(int m, int n) {
        if (n == 0) {
            return m;
        }
        return ProductUnit.gcd(n, m % n);
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    private static final class Element
    implements Serializable,
    Comparable<Element> {
        private static final long serialVersionUID = 452938412398890507L;
        private final Unit<?> unit;
        private final int pow;
        private final int root;

        private Element(Unit<?> unit, int pow, int root) {
            this.unit = unit;
            this.pow = pow;
            this.root = root;
        }

        public Unit<?> getUnit() {
            return this.unit;
        }

        public int getPow() {
            return this.pow;
        }

        public int getRoot() {
            return this.root;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element element = (Element)o;
            if (this.pow != element.pow) {
                return false;
            }
            return this.root == element.root && (this.unit != null ? this.unit.equals(element.unit) : element.unit == null);
        }

        @Override
        public int compareTo(Element other) {
            long theirHash;
            long ourHash = this.hashCode();
            if (ourHash < (theirHash = (long)other.hashCode())) {
                return -1;
            }
            if (ourHash == theirHash) {
                return 0;
            }
            return 1;
        }

        public int hashCode() {
            return Objects.hash(this.unit, (double)this.pow / (double)this.root);
        }
    }
}

