/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import tec.uom.se.AbstractConverter;
import tec.uom.se.ComparableUnit;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.function.AddConverter;
import tec.uom.se.function.MultiplyConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.quantity.QuantityDimension;
import tec.uom.se.spi.DimensionalModel;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.AnnotatedUnit;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;

public abstract class AbstractUnit<Q extends Quantity<Q>>
implements ComparableUnit<Q> {
    private static final long serialVersionUID = -4344589505537030204L;
    public static final AbstractUnit<Dimensionless> ONE = new ProductUnit<Dimensionless>();
    protected String name;
    private String symbol;
    protected static final Map<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();

    protected AbstractUnit() {
    }

    protected Type getActualType() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return parameterizedType.getActualTypeArguments()[0].getClass().getGenericInterfaces()[0];
    }

    @Override
    public boolean isSystemUnit() {
        Unit<Q> si = this.toSystemUnit();
        return this == si || this.equals(si);
    }

    protected abstract Unit<Q> toSystemUnit();

    public abstract UnitConverter getSystemConverter();

    public AnnotatedUnit<Q> annotate(String annotation) {
        return new AnnotatedUnit(this, annotation);
    }

    public static AbstractUnit<?> parse(CharSequence charSequence) {
        return SimpleUnitFormat.getInstance().parse(charSequence);
    }

    public String toString() {
        return SimpleUnitFormat.getInstance().format(this);
    }

    public final Unit<Q> getSystemUnit() {
        return this.toSystemUnit();
    }

    public final boolean isCompatible(Unit<?> that) {
        Dimension thatDimension;
        if (this == that || this.equals(that)) {
            return true;
        }
        if (!(that instanceof AbstractUnit)) {
            return false;
        }
        Dimension thisDimension = this.getDimension();
        if (thisDimension.equals(thatDimension = that.getDimension())) {
            return true;
        }
        DimensionalModel model = DimensionalModel.current();
        return model.getFundamentalDimension(thisDimension).equals(model.getFundamentalDimension(thatDimension));
    }

    @Override
    public boolean isEquivalentTo(Unit<Q> that) {
        if (this.compareTo(that) == 0) {
            return true;
        }
        return this.getConverterTo(that).equals(that.getConverterTo((Unit)this));
    }

    @Override
    public boolean isEquivalentOf(Unit<Q> that) {
        return this.isEquivalentTo(that);
    }

    public final <T extends Quantity<T>> AbstractUnit<T> asType(Class<T> type) {
        Dimension typeDimension = QuantityDimension.of(type);
        if (typeDimension != null && !typeDimension.equals(this.getDimension())) {
            throw new ClassCastException("The unit: " + this + " is not compatible with quantities of type " + type);
        }
        return this;
    }

    public abstract Map<? extends Unit<?>, Integer> getBaseUnits();

    public abstract Dimension getDimension();

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    protected void setSymbol(String s) {
        this.symbol = s;
    }

    public final UnitConverter getConverterTo(Unit<Q> that) throws UnconvertibleException {
        Unit thatSystemUnit;
        if (this == that || this.equals(that)) {
            return AbstractConverter.IDENTITY;
        }
        Unit<Q> thisSystemUnit = this.getSystemUnit();
        if (!thisSystemUnit.equals((Object)(thatSystemUnit = that.getSystemUnit()))) {
            try {
                return this.getConverterToAny(that);
            }
            catch (IncommensurableException e) {
                throw new UnconvertibleException((Throwable)e);
            }
        }
        UnitConverter thisToSI = this.getSystemConverter();
        UnitConverter thatToSI = that.getConverterTo(thatSystemUnit);
        return thatToSI.inverse().concatenate(thisToSI);
    }

    public final UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        if (!this.isCompatible(that)) {
            throw new IncommensurableException(this + " is not compatible with " + that);
        }
        AbstractUnit thatAbstr = (AbstractUnit)that;
        DimensionalModel model = DimensionalModel.current();
        Unit<Q> thisSystemUnit = this.getSystemUnit();
        UnitConverter thisToDimension = model.getDimensionalTransform(thisSystemUnit.getDimension()).concatenate(this.getSystemConverter());
        Unit<Q> thatSystemUnit = thatAbstr.getSystemUnit();
        UnitConverter thatToDimension = model.getDimensionalTransform(thatSystemUnit.getDimension()).concatenate(thatAbstr.getSystemConverter());
        return thatToDimension.inverse().concatenate(thisToDimension);
    }

    public final AbstractUnit<Q> alternate(String symbol) {
        return new AlternateUnit(this, symbol);
    }

    public final AbstractUnit<Q> transform(UnitConverter operation) {
        Unit<Q> systemUnit = this.getSystemUnit();
        UnitConverter cvtr = this.isSystemUnit() ? this.getSystemConverter().concatenate(operation) : operation;
        if (cvtr.equals(AbstractConverter.IDENTITY) && systemUnit instanceof AbstractUnit) {
            return (AbstractUnit)systemUnit;
        }
        return new TransformedUnit<Q>(null, this, systemUnit, cvtr);
    }

    public final AbstractUnit<Q> shift(double offset) {
        if (offset == 0.0) {
            return this;
        }
        return this.transform(new AddConverter(offset));
    }

    public final AbstractUnit<Q> multiply(double factor) {
        if (factor == 1.0) {
            return this;
        }
        if (AbstractUnit.isLongValue(factor)) {
            return this.transform(new RationalConverter(BigInteger.valueOf((long)factor), BigInteger.ONE));
        }
        return this.transform(new MultiplyConverter(factor));
    }

    private static boolean isLongValue(double value) {
        return !(value < -9.223372036854776E18) && !(value > 9.223372036854776E18) && Math.floor(value) == value;
    }

    public final AbstractUnit<?> multiply(Unit<?> that) {
        if (that instanceof AbstractUnit) {
            return this.multiply((AbstractUnit)that);
        }
        return ProductUnit.getProductInstance(this, that);
    }

    protected final AbstractUnit<?> multiply(AbstractUnit<?> that) {
        if (this.equals(ONE)) {
            return that;
        }
        if (that.equals(ONE)) {
            return this;
        }
        return ProductUnit.getProductInstance(this, that);
    }

    public final AbstractUnit<?> inverse() {
        if (this.equals(ONE)) {
            return this;
        }
        return ProductUnit.getQuotientInstance(ONE, this);
    }

    public final AbstractUnit<Q> divide(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        if (AbstractUnit.isLongValue(divisor)) {
            return this.transform(new RationalConverter(BigInteger.ONE, BigInteger.valueOf((long)divisor)));
        }
        return this.transform(new MultiplyConverter(1.0 / divisor));
    }

    public final AbstractUnit<?> divide(Unit<?> that) {
        return this.multiply(that.inverse());
    }

    protected final AbstractUnit<?> divide(AbstractUnit<?> that) {
        return this.multiply((AbstractUnit<?>)that.inverse());
    }

    public final AbstractUnit<?> root(int n) {
        if (n > 0) {
            return ProductUnit.getRootInstance(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide((AbstractUnit<?>)this.root(-n));
    }

    public final AbstractUnit<?> pow(int n) {
        if (n > 0) {
            return this.multiply((AbstractUnit<?>)this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide((AbstractUnit<?>)this.pow(-n));
    }

    @Override
    public int compareTo(Unit<Q> that) {
        if (this.name != null && this.getSymbol() != null) {
            return this.name.compareTo(that.getName()) + this.getSymbol().compareTo(that.getSymbol());
        }
        if (this.name == null) {
            if (this.getSymbol() != null && that.getSymbol() != null) {
                return this.getSymbol().compareTo(that.getSymbol());
            }
            return -1;
        }
        if (this.getSymbol() == null) {
            if (this.name != null) {
                return this.name.compareTo(that.getName());
            }
            return -1;
        }
        return -1;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

