/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;

class Sen3ExpAtmosphericConverter {
    Sen3ExpAtmosphericConverter() {
    }

    public static void main(String[] args) {
        String sourceDirPath = args[0];
        File sourceDir = new File(sourceDirPath);
        String targetDirPath = args[1];
        File targetDir = new File(targetDirPath);
        String propertyFilePath = args[2];
        File propertyFile = new File(propertyFilePath);
        Sen3ExpAtmosphericConverter.convert(sourceDir, targetDir, propertyFile, new ErrorHandler(){

            @Override
            public void error(Throwable t) {
                System.out.println("Error: " + t.getMessage());
                System.exit(1);
            }

            @Override
            public void warning(Throwable t) {
                System.out.println("Warning: " + t.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convert(File sourceDir, File targetDir, File propertyFile, ErrorHandler errorHandler) {
        File[] sourceFiles;
        Properties properties = new Properties();
        try (FileInputStream inStream = new FileInputStream(propertyFile);){
            properties.load(inStream);
        }
        catch (IOException e) {
            errorHandler.error(e);
        }
        for (File sourceFile : sourceFiles = sourceDir.listFiles((dir, name) -> name.endsWith(".nc"))) {
            Product product = null;
            try {
                product = ProductIO.readProduct((File)sourceFile);
                if (product == null) continue;
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    Band band = product.getBand((String)entry.getKey());
                    if (band == null) continue;
                    band.setSpectralWavelength(Float.parseFloat((String)entry.getValue()));
                }
                ProductIO.writeProduct((Product)product, (File)new File(targetDir, sourceFile.getName()), (String)"NetCDF", (boolean)false);
            }
            catch (IOException e) {
                errorHandler.warning(e);
            }
            finally {
                if (product != null) {
                    product.dispose();
                }
            }
        }
    }

    static interface ErrorHandler {
        public void error(Throwable var1);

        public void warning(Throwable var1);
    }
}

