/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.esa.snap.dataio.netcdf.NetCDF4Chunking;
import org.esa.snap.dataio.netcdf.nc.N4Variable;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.DimKey;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.write.Nc4Chunking;

public class N4FileWriteable
extends NFileWriteable {
    N4FileWriteable(String filename) throws IOException {
        this.netcdfFileWriter = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf4, (String)filename, (Nc4Chunking)new NetCDF4Chunking());
    }

    @Override
    public NVariable addScalarVariable(String name, DataType dataType) {
        Variable variable = this.netcdfFileWriter.addVariable(null, name, dataType, new ArrayList());
        N4Variable nVariable = new N4Variable(variable, null, this.netcdfFileWriter);
        this.variables.put(name, nVariable);
        return nVariable;
    }

    @Override
    public NVariable addVariable(String name, DataType dataType, boolean unsigned, Dimension tileSize, String dimensions, int compressionLevel) {
        String[] dims = dimensions.split(" ");
        ucar.nc2.Dimension[] nhDims = new ucar.nc2.Dimension[dims.length];
        Integer[] chunkLens = new Integer[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            nhDims[i] = (ucar.nc2.Dimension)this.dimensionsMap.get(dims[i]);
        }
        if (!dims[0].equals("")) {
            DimKey dimKey = new DimKey(nhDims);
            int indexWidth = dimKey.findXDimensionIndex();
            int indexHeight = dimKey.findYDimensionIndex();
            if (tileSize != null) {
                chunkLens[indexHeight] = tileSize.height;
                chunkLens[indexWidth] = tileSize.width;
                int imageWidth = nhDims[indexWidth].getLength();
                int imageHeight = nhDims[indexHeight].getLength();
                long imageSize = (long)imageHeight * (long)imageWidth;
                int scalingFactor = 2;
                while (imageSize / (long)(chunkLens[indexHeight] * chunkLens[indexWidth]) > 16383L) {
                    chunkLens[indexHeight] = tileSize.height * scalingFactor;
                    chunkLens[indexWidth] = tileSize.width * scalingFactor;
                    scalingFactor *= 2;
                }
                chunkLens[indexWidth] = Math.min(chunkLens[indexWidth], imageWidth);
                chunkLens[indexHeight] = Math.min(chunkLens[indexHeight], imageHeight);
                tileSize = new Dimension(chunkLens[indexWidth], chunkLens[indexHeight]);
            } else {
                for (int i = 0; i < dims.length; ++i) {
                    chunkLens[i] = nhDims[i].getLength();
                }
            }
        } else {
            chunkLens[0] = 1;
        }
        for (int i = 0; i < chunkLens.length; ++i) {
            if (chunkLens[i] != null) continue;
            chunkLens[i] = 1;
        }
        Variable variable = this.netcdfFileWriter.addVariable(null, name, dataType.withSignedness(unsigned ? DataType.Signedness.UNSIGNED : DataType.Signedness.SIGNED), dimensions);
        Attribute chunksizes = new Attribute("_ChunkSizes", Arrays.asList(chunkLens));
        variable.addAttribute(chunksizes);
        N4Variable nVariable = new N4Variable(variable, tileSize, this.netcdfFileWriter);
        this.variables.put(name, nVariable);
        return nVariable;
    }

    @Override
    public DataType getNetcdfDataType(int dataType) {
        return DataTypeUtils.getNetcdf4DataType(dataType);
    }
}

