/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.PartialDataCopier;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class N3Variable
implements NVariable {
    private final Variable variable;
    private final NetcdfFileWriter netcdfFileWriteable;
    private final HashMap<Integer, TileRowCache> tileRowCacheMap;
    private static final int Y_INDEX = 0;
    private static final int X_INDEX = 1;

    public N3Variable(Variable variable, NetcdfFileWriter netcdfFileWriteable) {
        this.variable = variable;
        this.netcdfFileWriteable = netcdfFileWriteable;
        this.tileRowCacheMap = new HashMap();
    }

    @Override
    public String getName() {
        return this.variable.getFullName();
    }

    @Override
    public DataType getDataType() {
        return this.variable.getDataType();
    }

    @Override
    public void setDataType(DataType dataType) {
        this.variable.setDataType(dataType);
    }

    @Override
    public Attribute addAttribute(String name, String value) {
        return this.variable.addAttribute(new Attribute(name, value));
    }

    @Override
    public Attribute addAttribute(String name, Number value) {
        return this.addAttribute(name, value, false);
    }

    @Override
    public Attribute addAttribute(String name, Number value, boolean isUnsigned) {
        if (value instanceof Long) {
            return this.variable.addAttribute(new Attribute(name, (Number)value.intValue()));
        }
        return this.variable.addAttribute(new Attribute(name, value));
    }

    @Override
    public Attribute addAttribute(String name, Array value) {
        if (DataType.getType((Class)value.getElementType(), (boolean)false) == DataType.LONG) {
            long[] longElems = (long[])value.get1DJavaArray(DataType.LONG);
            int[] intElems = new int[longElems.length];
            for (int i = 0; i < longElems.length; ++i) {
                intElems[i] = (int)longElems[i];
            }
            return this.variable.addAttribute(new Attribute(name, Array.factory((DataType)DataType.INT, (int[])new int[]{longElems.length}, (Object)intElems)));
        }
        return this.variable.addAttribute(new Attribute(name, value));
    }

    @Override
    public void writeFully(Array values) throws IOException {
        try {
            this.netcdfFileWriteable.write(this.variable, values);
        }
        catch (InvalidRangeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Attribute findAttribute(String name) {
        return this.variable.findAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int x, int y, int width, int height, boolean isYFlipped, ProductData data) throws IOException {
        block8: {
            TileRowCache tileRowCache;
            if (!this.tileRowCacheMap.containsKey(y)) {
                tileRowCache = new TileRowCache(height, this.variable);
                this.tileRowCacheMap.put(y, tileRowCache);
            } else {
                tileRowCache = this.tileRowCacheMap.get(y);
            }
            DataType dataType = this.variable.getDataType();
            int[] sourceShape = new int[]{height, width};
            Array sourceArray = Array.factory((DataType)dataType, (int[])sourceShape, (Object)data.getElems());
            if (isYFlipped) {
                sourceArray = sourceArray.flip(0);
            }
            try {
                tileRowCache.addTile(x, sourceArray);
                if (!tileRowCache.isFilled()) break block8;
                Array tileRow = tileRowCache.getTileRow();
                this.tileRowCacheMap.remove(y);
                String variableName = this.variable.getFullName();
                int[] writeOrigin = new int[2];
                int sceneHeight = this.variable.getDimension(0).getLength();
                writeOrigin[0] = isYFlipped ? sceneHeight - 1 - y : y;
                NetcdfFileWriter netcdfFileWriter = this.netcdfFileWriteable;
                synchronized (netcdfFileWriter) {
                    this.netcdfFileWriteable.write(variableName, writeOrigin, tileRow);
                }
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException("Unable to encode netCDF data.", e);
            }
        }
    }

    private static class TileRowCache {
        private final int height;
        private final Array row;
        private final Map<Integer, Integer> fillingAreaMap;
        private final int maxX;

        public TileRowCache(int height, Variable variable) {
            this.height = height;
            this.fillingAreaMap = Collections.synchronizedMap(new TreeMap());
            this.maxX = variable.getShape(1);
            this.row = Array.factory((DataType)variable.getDataType(), (int[])new int[]{height, this.maxX});
        }

        public void addTile(int x, Array sourceArray) throws InvalidRangeException {
            int[] shape = sourceArray.getShape();
            if (shape[0] != this.height) {
                throw new IllegalArgumentException("The array hight is " + shape[0] + " but expected " + this.height);
            }
            PartialDataCopier.copy(new int[]{0, x * -1}, sourceArray, this.row);
            this.fillingAreaMap.put(x, x + shape[1]);
        }

        public boolean isFilled() {
            this.combineFillingAreas();
            return this.fillingAreaMap.size() == 1 && this.fillingAreaMap.containsKey(0) && this.fillingAreaMap.get(0) == this.maxX;
        }

        private synchronized void combineFillingAreas() {
            Integer[] keys = this.fillingAreaMap.keySet().toArray(new Integer[0]);
            int currentKey = keys[0];
            int currentEnd = this.fillingAreaMap.get(currentKey);
            for (int i = 1; i < keys.length; ++i) {
                Integer key2 = keys[i];
                if (key2 == currentEnd) {
                    currentEnd = this.fillingAreaMap.remove(key2);
                    this.fillingAreaMap.put(currentKey, currentEnd);
                    continue;
                }
                currentKey = key2;
                currentEnd = this.fillingAreaMap.get(key2);
            }
        }

        public Array getTileRow() {
            return this.row;
        }
    }
}

