/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import java.awt.Rectangle;
import java.awt.geom.Area;
import org.esa.snap.core.datamodel.ProductData;

public class Chunk {
    final Rectangle chunkRect;
    final ProductData chunkData;
    final Area subArea;

    public Chunk(Rectangle chunkRect, int type) {
        this.chunkRect = chunkRect;
        this.chunkData = ProductData.createInstance((int)type, (int)(chunkRect.width * chunkRect.height));
        this.subArea = new Area(chunkRect);
    }

    public void copyDataFrom(Rectangle dataRect, ProductData data) {
        Rectangle part = this.chunkRect.intersection(dataRect);
        for (int cy = part.y; cy < part.y + part.height; ++cy) {
            int srcPos = (cy - dataRect.y) * dataRect.width + (part.x - dataRect.x);
            int destPos = (cy - this.chunkRect.y) * this.chunkRect.width + (part.x - this.chunkRect.x);
            System.arraycopy(data.getElems(), srcPos, this.chunkData.getElems(), destPos, part.width);
        }
        this.subArea.subtract(new Area(part));
    }

    public boolean complete() {
        return this.subArea.isEmpty();
    }

    public ProductData getData() {
        return this.chunkData;
    }
}

