/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.List;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosGridInfo;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.jdom2.Element;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public class HdfEosGeocodingPart
extends ProfilePartIO {
    private static final double PIXEL_CENTER = 0.0;

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        Element eosElement = (Element)ctx.getProperty("StructMetadata");
        List<HdfEosGridInfo> gridInfos = HdfEosGridInfo.createGridInfos(eosElement);
        List<HdfEosGridInfo> compatibleGridInfos = HdfEosGridInfo.getCompatibleGridInfos(gridInfos);
        if (!compatibleGridInfos.isEmpty()) {
            HdfEosGridInfo hdfEosGeocodingInfo = compatibleGridInfos.get(0);
            HdfEosGeocodingPart.attachGeoCoding(p, hdfEosGeocodingInfo.upperLeftLon, hdfEosGeocodingInfo.upperLeftLat, hdfEosGeocodingInfo.lowerRightLon, hdfEosGeocodingInfo.lowerRightLat, hdfEosGeocodingInfo.projection, hdfEosGeocodingInfo.getProjectionParameter());
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        throw new IllegalStateException();
    }

    public static void attachGeoCoding(Product p, double upperLeftLon, double upperLeftLat, double lowerRightLon, double lowerRightLat, String projection, double[] projectionParameter) {
        double pixelSizeX = (lowerRightLon - upperLeftLon) / (double)p.getSceneRasterWidth();
        double pixelSizeY = (upperLeftLat - lowerRightLat) / (double)p.getSceneRasterHeight();
        AffineTransform transform = new AffineTransform();
        transform.translate(upperLeftLon, upperLeftLat);
        transform.scale(pixelSizeX, -pixelSizeY);
        transform.translate(0.0, 0.0);
        Rectangle imageBounds = new Rectangle(p.getSceneRasterWidth(), p.getSceneRasterHeight());
        if (projection.equals("GCTP_GEO")) {
            if (upperLeftLon >= -180.0 && upperLeftLon <= 180.0 && upperLeftLat >= -90.0 && upperLeftLat <= 90.0 && lowerRightLon >= -180.0 && lowerRightLon <= 180.0 && lowerRightLat >= -90.0 && lowerRightLat <= 90.0) {
                try {
                    p.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, imageBounds, transform));
                }
                catch (FactoryException | TransformException throwable) {}
            }
        } else if (projection.equals("GCTP_SNSOID")) {
            MathTransform mathTransform;
            double semi_minor;
            double semi_major;
            ParameterValueGroup parameters;
            MathTransformFactory transformFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
            try {
                parameters = transformFactory.getDefaultParameters("Sinusoidal");
            }
            catch (NoSuchIdentifierException ignore2) {
                return;
            }
            if (projectionParameter != null) {
                semi_major = projectionParameter[0];
                semi_minor = projectionParameter[1];
                if (semi_minor == 0.0) {
                    semi_minor = semi_major;
                }
            } else {
                Ellipsoid ellipsoid = DefaultGeographicCRS.WGS84.getDatum().getEllipsoid();
                semi_major = ellipsoid.getSemiMajorAxis();
                semi_minor = ellipsoid.getSemiMinorAxis();
            }
            parameters.parameter("semi_major").setValue(semi_major);
            parameters.parameter("semi_minor").setValue(semi_minor);
            try {
                mathTransform = transformFactory.createParameterizedTransform(parameters);
            }
            catch (Exception ignore) {
                return;
            }
            DefaultGeographicCRS base = DefaultGeographicCRS.WGS84;
            DefaultProjectedCRS modelCrs = new DefaultProjectedCRS("Sinusoidal", (GeographicCRS)base, mathTransform, (CartesianCS)DefaultCartesianCS.PROJECTED);
            try {
                CrsGeoCoding geoCoding = new CrsGeoCoding((CoordinateReferenceSystem)modelCrs, imageBounds, transform);
                p.setSceneGeoCoding((GeoCoding)geoCoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

