/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.io.IOException;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfBandPart;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;

public class CfTiePointGridPart
extends ProfilePartIO {
    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        CfBandPart.defineRasterDataNodes(ctx, (RasterDataNode[])p.getTiePointGrids());
    }

    @Override
    public void encode(ProfileWriteContext ctx, Product p) throws IOException {
        boolean doFlip = this.getYFlippedProperty(ctx);
        for (TiePointGrid tiePointGrid : p.getTiePointGrids()) {
            Point[] tileIndices;
            String variableName = ReaderUtils.getVariableName((RasterDataNode)tiePointGrid);
            NVariable variable = ctx.getNetcdfFileWriteable().findVariable(variableName);
            int h = tiePointGrid.getRasterHeight();
            int w = tiePointGrid.getRasterWidth();
            MultiLevelImage sourceImage = tiePointGrid.getSourceImage();
            for (Point tileIndex : tileIndices = sourceImage.getTileIndices(new Rectangle(0, 0, w, h))) {
                Rectangle rect = sourceImage.getTileRect(tileIndex.x, tileIndex.y);
                if (rect.isEmpty()) continue;
                Raster data = sourceImage.getData(rect);
                ProductData productData = tiePointGrid.createCompatibleRasterData(rect.width, rect.height);
                data.getDataElements(rect.x, rect.y, rect.width, rect.height, productData.getElems());
                variable.write(rect.x, rect.y, rect.width, rect.height, doFlip, productData);
            }
        }
    }

    private boolean getYFlippedProperty(ProfileWriteContext ctx) {
        Object yFlippedProperty = ctx.getProperty("yFlipped");
        if (yFlippedProperty instanceof Boolean) {
            return (Boolean)yFlippedProperty;
        }
        return false;
    }
}

