/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.io.IOException;
import java.util.Arrays;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.util.MetadataUtils;
import org.esa.snap.dataio.netcdf.util.VariableNameHelper;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Group;

public class CfMetadataPart
extends ProfilePartIO {
    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        MetadataUtils.readNetcdfMetadata(ctx.getNetcdfFile(), p.getMetadataRoot());
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        MetadataAttribute[] globalAttributes;
        NFileWriteable netcdfFileWriteable = ctx.getNetcdfFileWriteable();
        MetadataElement metadataRoot = p.getMetadataRoot();
        for (MetadataAttribute attribute : globalAttributes = metadataRoot.getAttributes()) {
            int dataType = attribute.getDataType();
            String attributeName = attribute.getName();
            if (!VariableNameHelper.isVariableNameValid(attributeName)) {
                attributeName = VariableNameHelper.convertToValidName(attributeName);
                SystemUtils.LOG.warning("Found invalid attribute name '" + attribute.getName() + "' - replaced by '" + attributeName + "'.");
            }
            if (dataType == 41) {
                netcdfFileWriteable.addGlobalAttribute(attributeName, attribute.getData().getElemString());
                continue;
            }
            if (attribute.getNumDataElems() > 1L) continue;
            if (dataType == 10 || dataType == 20 || dataType == 11 || dataType == 21 || dataType == 12 || dataType == 22) {
                int data = attribute.getData().getElemInt();
                netcdfFileWriteable.addGlobalAttribute(attributeName, data);
                continue;
            }
            if (dataType == 30) {
                float data = attribute.getData().getElemFloat();
                netcdfFileWriteable.addGlobalAttribute(attributeName, Float.valueOf(data));
                continue;
            }
            if (dataType == 31) {
                double data = attribute.getData().getElemDouble();
                netcdfFileWriteable.addGlobalAttribute(attributeName, data);
                continue;
            }
            if (dataType != 13) continue;
            long data = (long)attribute.getData().getElemDouble();
            netcdfFileWriteable.addGlobalAttribute(attributeName, data);
        }
        if (metadataRoot.getNumElements() > 0) {
            Group rootGroup = CfMetadataPart.getRootGroup(netcdfFileWriteable);
            Group metadataGroup = netcdfFileWriteable.addGroup(rootGroup, "Metadata_Group");
            MetadataElement deepClone = metadataRoot.createDeepClone();
            CfMetadataPart.makeCompatible(deepClone);
            for (MetadataElement element : deepClone.getElements()) {
                this.addElementToGroup(netcdfFileWriteable, metadataGroup, element);
            }
            deepClone.dispose();
        }
    }

    static void makeCompatible(MetadataElement elem) {
        String[] subElemNames = elem.getElementNames();
        if (Arrays.stream(subElemNames).distinct().count() < (long)subElemNames.length) {
            MetadataElement[] subElems;
            for (MetadataElement subElem : subElems = elem.getElements()) {
                MetadataElement[] equalNameElems = (MetadataElement[])Arrays.stream(subElems).filter(s -> s.getName().equals(subElem.getName())).toArray(MetadataElement[]::new);
                if (equalNameElems.length <= 1) continue;
                for (int k = 0; k < equalNameElems.length; ++k) {
                    MetadataElement element = equalNameElems[k];
                    element.setName(element.getName() + "." + k);
                }
            }
        }
        Arrays.stream(elem.getElements()).forEach(CfMetadataPart::makeCompatible);
    }

    private void addElementToGroup(NFileWriteable netcdfFileWriteable, Group ncGroup, MetadataElement root) {
        MetadataElement[] elements;
        Group newGroup = netcdfFileWriteable.addGroup(ncGroup, root.getName());
        this.addAttributesToGroup(newGroup, root.getAttributes());
        for (MetadataElement element : elements = root.getElements()) {
            this.addElementToGroup(netcdfFileWriteable, newGroup, element);
        }
    }

    private static Group getRootGroup(NFileWriteable netcdfFileWriteable) {
        return netcdfFileWriteable.addGroup(null, "");
    }

    private void addAttributesToGroup(Group group, MetadataAttribute[] attributes) {
        for (MetadataAttribute attribute : attributes) {
            CfMetadataPart.addAttribute(group, attribute);
        }
    }

    private static void addAttribute(Group group, MetadataAttribute attribute) {
        block12: {
            int type;
            ProductData data;
            block11: {
                data = attribute.getData();
                type = data.getType();
                if (!data.isScalar()) break block11;
                switch (type) {
                    case 30: {
                        group.addAttribute(new Attribute(attribute.getName(), (Number)Float.valueOf(data.getElemFloat())));
                        break block12;
                    }
                    case 31: {
                        group.addAttribute(new Attribute(attribute.getName(), (Number)data.getElemDouble()));
                        break block12;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        group.addAttribute(new Attribute(attribute.getName(), (Number)data.getElemInt()));
                        break block12;
                    }
                    case 20: 
                    case 21: {
                        group.addAttribute(new Attribute(attribute.getName(), (Number)data.getElemInt(), data.isUnsigned()));
                        break block12;
                    }
                    case 13: 
                    case 22: {
                        group.addAttribute(new Attribute(attribute.getName(), (Number)data.getElemLong(), data.isUnsigned()));
                    }
                    case 23: {
                        group.addAttribute(new Attribute(attribute.getName(), (Number)data.getElemDouble()));
                        break block12;
                    }
                    case 41: {
                        group.addAttribute(new Attribute(attribute.getName(), data.getElemString()));
                        break block12;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + type);
                    }
                }
            }
            if (41 == type || 51 == type) {
                group.addAttribute(new Attribute(attribute.getName(), data.getElemString()));
            } else {
                group.addAttribute(new Attribute(attribute.getName(), Array.makeFromJavaArray((Object)data.getElems())));
            }
        }
    }
}

