/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.io.IOException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import org.esa.snap.dataio.netcdf.util.UnsignedChecker;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.util.EscapeStrings;

public class CfIndexCodingPart
extends ProfilePartIO {
    private static final String FLAG_VALUES = "flag_values";
    private static final String FLAG_MEANINGS = "flag_meanings";

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        Band[] bands;
        for (Band band : bands = p.getBands()) {
            String varName = EscapeStrings.backslashEscape((String)band.getName(), (String)"();,.\\");
            Variable variable = ctx.getNetcdfFile().findVariable(varName);
            UnsignedChecker.setUnsignedType(variable);
            IndexCoding indexCoding = CfIndexCodingPart.readIndexCoding(variable, band.getName());
            if (indexCoding == null) continue;
            p.getIndexCodingGroup().add((ProductNode)indexCoding);
            band.setSampleCoding((SampleCoding)indexCoding);
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        NFileWriteable writeable = ctx.getNetcdfFileWriteable();
        for (Band band : p.getBands()) {
            IndexCoding indexCoding = band.getIndexCoding();
            if (indexCoding == null) continue;
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            NVariable variable = writeable.findVariable(variableName);
            CfIndexCodingPart.writeIndexCoding(indexCoding, variable);
        }
    }

    public static void writeIndexCoding(IndexCoding indexCoding, NVariable variable) throws IOException {
        String[] indexNames = indexCoding.getIndexNames();
        ProductData indexValues = ProductData.createInstance((int)DataTypeUtils.getRasterDataType(variable.getDataType(), variable.getDataType().isUnsigned()), (int)indexNames.length);
        StringBuilder meanings = new StringBuilder();
        for (int i = 0; i < indexValues.getNumElems(); ++i) {
            if (meanings.length() > 0) {
                meanings.append(" ");
            }
            String name = indexNames[i];
            meanings.append(name);
            indexValues.setElemIntAt(i, indexCoding.getIndexValue(name));
        }
        variable.addAttribute(FLAG_MEANINGS, meanings.toString().trim());
        Array maskValues = Array.factory((DataType)variable.getDataType(), (int[])new int[]{indexNames.length}, (Object)indexValues.getElems());
        Attribute attribute = variable.addAttribute(FLAG_VALUES, maskValues);
        try {
            if (indexValues.isUnsigned()) {
                attribute.setDataType(attribute.getDataType().withSignedness(DataType.Signedness.UNSIGNED));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static IndexCoding readIndexCoding(Variable variable, String indexCodingName) {
        Attribute flagMeanings;
        int[] flagValues;
        Attribute flagValuesAtt = variable.findAttribute(FLAG_VALUES);
        if (flagValuesAtt != null) {
            flagValues = new int[flagValuesAtt.getLength()];
            for (int i = 0; i < flagValues.length; ++i) {
                flagValues[i] = flagValuesAtt.getNumericValue(i).intValue();
            }
        } else {
            flagValues = null;
        }
        String[] flagNames = (flagMeanings = variable.findAttribute(FLAG_MEANINGS)) != null ? StringUtils.makeStringsUnique((String[])flagMeanings.getStringValue().split(" ")) : null;
        return CfIndexCodingPart.createIndexCoding(indexCodingName, flagValues, flagNames);
    }

    private static IndexCoding createIndexCoding(String indexCodingName, int[] flagValues, String[] flagNames) {
        if (flagValues != null && flagNames != null && flagValues.length == flagNames.length) {
            IndexCoding coding = new IndexCoding(indexCodingName);
            for (int i = 0; i < flagValues.length; ++i) {
                String sampleName = flagNames[i];
                int sampleValue = flagValues[i];
                coding.addSample(sampleName, sampleValue, "");
            }
            if (coding.getNumAttributes() > 0) {
                return coding;
            }
        }
        return null;
    }
}

