/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.util.List;
import java.util.StringTokenizer;
import ucar.nc2.Attribute;

public class CfHdfEosGeoInfoExtractor {
    private List<Attribute> netcdfAttributes;
    private int xDim = -1;
    private int yDim = -1;
    private double ulLon;
    private double ulLat;
    private double lrLon;
    private double lrLat;
    private String projection;

    public CfHdfEosGeoInfoExtractor(List<Attribute> netcdfAttributes) {
        this.netcdfAttributes = netcdfAttributes;
    }

    public void extractInfo() throws NumberFormatException {
        String[] strings;
        Attribute structMetadataAttr = null;
        for (Attribute att : this.netcdfAttributes) {
            if (!att.getShortName().startsWith("StructMetadata")) continue;
            structMetadataAttr = att;
            break;
        }
        String structMetadataString = structMetadataAttr.getValue(0).toString();
        for (String string : strings = structMetadataString.split("\n")) {
            string = string.replaceAll("\t", "");
            StringTokenizer st = new StringTokenizer(string, "\n", false);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                String[] sSplit = s.split("=");
                if (sSplit == null || sSplit.length != 2) continue;
                String sArgString = sSplit[0];
                String sValString = sSplit[1];
                if (sArgString.equalsIgnoreCase("projection")) {
                    this.projection = sValString;
                    continue;
                }
                if (sArgString.equalsIgnoreCase("xdim")) {
                    try {
                        this.xDim = Integer.parseInt(sValString);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Cannot extract XDIM value: " + e.getMessage());
                    }
                    continue;
                }
                if (sArgString.equalsIgnoreCase("ydim")) {
                    try {
                        this.yDim = Integer.parseInt(sValString);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Cannot extract YDIM value: " + e.getMessage());
                    }
                    continue;
                }
                if (sArgString.toLowerCase().contains("upperleft")) {
                    try {
                        String[] ulNumberStrings = sValString.substring(1, sValString.length() - 1).split(",");
                        this.ulLon = Double.parseDouble(ulNumberStrings[0]);
                        this.ulLat = Double.parseDouble(ulNumberStrings[1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Cannot extract UPPERLEFT values: " + e.getMessage());
                    }
                    continue;
                }
                if (!sArgString.toLowerCase().contains("lowerright")) continue;
                try {
                    String[] lrNumberStrings = sValString.substring(1, sValString.length() - 1).split(",");
                    this.lrLon = Double.parseDouble(lrNumberStrings[0]);
                    this.lrLat = Double.parseDouble(lrNumberStrings[1]);
                }
                catch (NumberFormatException e) {
                    System.out.println("Cannot extract LOWERRIGHT values: " + e.getMessage());
                }
            }
        }
    }

    public int getxDim() {
        return this.xDim;
    }

    public int getyDim() {
        return this.yDim;
    }

    public double getUlLon() {
        return this.ulLon;
    }

    public double getUlLat() {
        return this.ulLat;
    }

    public double getLrLon() {
        return this.lrLon;
    }

    public double getLrLat() {
        return this.lrLat;
    }

    public String getProjection() {
        return this.projection;
    }
}

