/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.DataNode;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.ForLoop;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfCompliantUnitMapper;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfFlagCodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.DataTypeWorkarounds;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.DimKey;
import org.esa.snap.dataio.netcdf.util.NetcdfMultiLevelImage;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import org.esa.snap.dataio.netcdf.util.UnsignedChecker;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.units.ConversionException;
import ucar.units.PrefixDBException;
import ucar.units.SpecificationException;
import ucar.units.Unit;
import ucar.units.UnitDBException;
import ucar.units.UnitFormat;
import ucar.units.UnitFormatManager;
import ucar.units.UnitSystemException;

public class CfBandPart
extends ProfilePartIO {
    private static final DataTypeWorkarounds dataTypeWorkarounds = new DataTypeWorkarounds();
    private static final String NANO_METER = "nm";
    private static UnitFormat unitFormatManager = UnitFormatManager.instance();

    public static void readCfBandAttributes(Variable variable, RasterDataNode rasterDataNode) {
        rasterDataNode.setDescription(variable.getDescription());
        rasterDataNode.setUnit(variable.getUnitsString());
        rasterDataNode.setScalingFactor(CfBandPart.getScalingFactor(variable));
        rasterDataNode.setScalingOffset(CfBandPart.getAddOffset(variable));
        Number noDataValue = CfBandPart.getNoDataValue(variable);
        if (noDataValue != null) {
            rasterDataNode.setNoDataValue(noDataValue.doubleValue());
            rasterDataNode.setNoDataValueUsed(true);
        }
        if (rasterDataNode instanceof Band) {
            Band band = (Band)rasterDataNode;
            band.setSpectralWavelength(CfBandPart.getSpectralWavelength(variable));
        }
    }

    public static void writeCfBandAttributes(RasterDataNode rasterDataNode, NVariable variable) throws IOException {
        Band band;
        float spectralWavelength;
        double noDataValue;
        String unit;
        String description = rasterDataNode.getDescription();
        if (description != null) {
            variable.addAttribute("long_name", description);
        }
        if ((unit = rasterDataNode.getUnit()) != null) {
            unit = CfCompliantUnitMapper.tryFindUnitString(unit);
            variable.addAttribute("units", unit);
        }
        if (!rasterDataNode.isLog10Scaled()) {
            double scalingOffset;
            double scalingFactor = rasterDataNode.getScalingFactor();
            if (scalingFactor != 1.0) {
                variable.addAttribute("scale_factor", scalingFactor);
            }
            if ((scalingOffset = rasterDataNode.getScalingOffset()) != 0.0) {
                variable.addAttribute("add_offset", scalingOffset);
            }
            noDataValue = rasterDataNode.getNoDataValue();
        } else {
            noDataValue = rasterDataNode.getGeophysicalNoDataValue();
        }
        if (rasterDataNode.isNoDataValueUsed()) {
            Number fillValue = DataTypeUtils.convertTo(noDataValue, variable.getDataType());
            variable.addAttribute("_FillValue", fillValue, variable.getDataType().isUnsigned());
        }
        variable.addAttribute("coordinates", "lat lon");
        if (rasterDataNode instanceof Band && (spectralWavelength = (band = (Band)rasterDataNode).getSpectralWavelength()) > 0.0f) {
            variable.addAttribute("radiation_wavelength", Float.valueOf(spectralWavelength));
            variable.addAttribute("radiation_wavelength_unit", NANO_METER);
        }
    }

    static void defineRasterDataNodes(ProfileWriteContext ctx, RasterDataNode[] rasterDataNodes) throws IOException {
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        String dimensions = ncFile.getDimensions();
        for (RasterDataNode rasterDataNode : rasterDataNodes) {
            String variableName = ReaderUtils.getVariableName(rasterDataNode);
            int dataType = rasterDataNode.isLog10Scaled() ? rasterDataNode.getGeophysicalDataType() : rasterDataNode.getDataType();
            DataType netcdfDataType = DataTypeUtils.getNetcdfDataType(dataType);
            Dimension tileSize = ImageManager.getPreferredTileSize((Product)rasterDataNode.getProduct());
            NVariable variable = ncFile.addVariable(variableName, netcdfDataType, netcdfDataType.isUnsigned(), tileSize, dimensions);
            CfBandPart.writeCfBandAttributes(rasterDataNode, variable);
        }
    }

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        for (Variable variable : ctx.getRasterDigest().getRasterVariables()) {
            UnsignedChecker.setUnsignedType(variable);
            List dimensions = variable.getDimensions();
            int rank = dimensions.size();
            String bandBasename = variable.getShortName();
            if (rank == 2) {
                CfBandPart.addBand(ctx, p, variable, new int[0], bandBasename);
                continue;
            }
            int[] sizeArray = new int[rank - 2];
            int startIndexToCopy = DimKey.findStartIndexOfBandVariables(dimensions);
            System.arraycopy(variable.getShape(), startIndexToCopy, sizeArray, 0, sizeArray.length);
            ForLoop.execute((int[])sizeArray, (indexes, sizes) -> {
                StringBuilder bandNameBuilder = new StringBuilder(bandBasename);
                for (int i = 0; i < sizes.length; ++i) {
                    ucar.nc2.Dimension zDim = (ucar.nc2.Dimension)dimensions.get(i + startIndexToCopy);
                    String zName = zDim.getShortName();
                    String skipPrefix = "n_";
                    if (zName != null && zName.toLowerCase().startsWith("n_") && zName.length() > "n_".length()) {
                        zName = zName.substring("n_".length());
                    }
                    if (zDim.getLength() <= 1) continue;
                    if (zName != null) {
                        bandNameBuilder.append(String.format("_%s%d", zName, indexes[i] + 1));
                        continue;
                    }
                    bandNameBuilder.append(String.format("_%d", indexes[i] + 1));
                }
                CfBandPart.addBand(ctx, p, variable, indexes, bandNameBuilder.toString());
            });
        }
        p.setAutoGrouping(this.getAutoGrouping(ctx));
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        ctx.setProperty("convertLogScaledBands", true);
        CfBandPart.defineRasterDataNodes(ctx, (RasterDataNode[])p.getBands());
    }

    private static void addBand(ProfileReadContext ctx, Product p, Variable variable, int[] origin, String bandBasename) {
        int rasterDataType = CfBandPart.getRasterDataType(variable, dataTypeWorkarounds);
        if (variable.getDataType() == DataType.LONG) {
            Band lowerBand = p.addBand(bandBasename + "_lsb", rasterDataType);
            CfBandPart.readCfBandAttributes(variable, (RasterDataNode)lowerBand);
            if (lowerBand.getDescription() != null) {
                lowerBand.setDescription(lowerBand.getDescription() + "(least significant bytes)");
            }
            lowerBand.setSourceImage((MultiLevelImage)new NetcdfMultiLevelImage((RasterDataNode)lowerBand, variable, origin, ctx));
            CfBandPart.addSampleCodingOrMasksIfApplicable(p, lowerBand, variable, variable.getFullName() + "_lsb", false);
            Band upperBand = p.addBand(bandBasename + "_msb", rasterDataType);
            CfBandPart.readCfBandAttributes(variable, (RasterDataNode)upperBand);
            if (upperBand.getDescription() != null) {
                upperBand.setDescription(upperBand.getDescription() + "(most significant bytes)");
            }
            upperBand.setSourceImage((MultiLevelImage)new NetcdfMultiLevelImage((RasterDataNode)upperBand, variable, origin, ctx));
            CfBandPart.addSampleCodingOrMasksIfApplicable(p, upperBand, variable, variable.getFullName() + "_msb", true);
        } else {
            Band band = p.containsBand(bandBasename) ? p.addBand(bandBasename + "_" + variable.getParentGroup().getShortName(), rasterDataType) : p.addBand(bandBasename, rasterDataType);
            CfBandPart.readCfBandAttributes(variable, (RasterDataNode)band);
            band.setSourceImage((MultiLevelImage)new NetcdfMultiLevelImage((RasterDataNode)band, variable, origin, ctx));
            CfBandPart.addSampleCodingOrMasksIfApplicable(p, band, variable, variable.getFullName(), false);
        }
    }

    private static double getScalingFactor(Variable variable) {
        Attribute attribute = variable.findAttribute("scale_factor");
        if (attribute == null) {
            attribute = variable.findAttribute("slope");
        }
        if (attribute == null) {
            attribute = variable.findAttribute("scaling_factor");
        }
        if (attribute != null) {
            return CfBandPart.getAttributeValue(attribute).doubleValue();
        }
        return 1.0;
    }

    private static double getAddOffset(Variable variable) {
        Attribute attribute = variable.findAttribute("add_offset");
        if (attribute == null) {
            attribute = variable.findAttribute("intercept");
        }
        if (attribute != null) {
            return CfBandPart.getAttributeValue(attribute).doubleValue();
        }
        return 0.0;
    }

    static float getSpectralWavelength(Variable variable) {
        Attribute attribute = variable.findAttribute("radiation_wavelength");
        if (attribute == null) {
            return 0.0f;
        }
        Number wavelengthValue = CfBandPart.getAttributeValue(attribute);
        if (wavelengthValue == null) {
            return 0.0f;
        }
        float value = wavelengthValue.floatValue();
        Attribute attUnit = variable.findAttribute("radiation_wavelength_unit");
        if (attUnit == null) {
            return value;
        }
        String unitStr = attUnit.getStringValue().trim();
        if (unitStr.equals(NANO_METER)) {
            return value;
        }
        try {
            Unit sourceUnit = unitFormatManager.parse(unitStr);
            Unit nanoMeter = unitFormatManager.parse(NANO_METER);
            if (sourceUnit.isCompatible(nanoMeter)) {
                return sourceUnit.convertTo(value, nanoMeter);
            }
        }
        catch (ConversionException | PrefixDBException | SpecificationException | UnitDBException | UnitSystemException e) {
            Logger global = Logger.getGlobal();
            global.log(Level.WARNING, e.getMessage(), e);
        }
        return 0.0f;
    }

    private static Number getNoDataValue(Variable variable) {
        Attribute attribute = variable.findAttribute("_FillValue");
        if (attribute == null) {
            attribute = variable.findAttribute("missing_value");
        }
        if (attribute != null) {
            return CfBandPart.getAttributeValue(attribute);
        }
        return null;
    }

    private static Number getAttributeValue(Attribute attribute) {
        if (attribute.isString()) {
            String stringValue = attribute.getStringValue();
            if (stringValue.endsWith("b")) {
                return Byte.parseByte(stringValue.substring(0, stringValue.length() - 1));
            }
            if (!stringValue.isEmpty()) {
                return Double.parseDouble(stringValue);
            }
            return 0;
        }
        return attribute.getNumericValue();
    }

    private static int getRasterDataType(Variable variable, DataTypeWorkarounds workarounds) {
        if (workarounds != null && workarounds.hasWorkaround(variable.getFullName(), variable.getDataType())) {
            return workarounds.getRasterDataType(variable.getFullName(), variable.getDataType());
        }
        int rasterDataType = DataTypeUtils.getRasterDataType(variable);
        if (variable.getDataType() == DataType.LONG) {
            rasterDataType = variable.getDataType().isUnsigned() ? 22 : 12;
        }
        return rasterDataType;
    }

    private static boolean isUnsigned(DataNode dataNode) {
        return ProductData.isUIntType((int)dataNode.getDataType());
    }

    private static void addSampleCodingOrMasksIfApplicable(Product p, Band band, Variable variable, String sampleCodingName, boolean msb) {
        Attribute flagMeanings = variable.findAttribute("flag_meanings");
        if (flagMeanings == null) {
            flagMeanings = variable.findAttribute("flag_meaning");
        }
        if (flagMeanings == null) {
            return;
        }
        Attribute flagMasks = variable.findAttribute("flag_masks");
        Attribute flagValues = variable.findAttribute("flag_values");
        if (flagMasks != null) {
            if (!p.getFlagCodingGroup().contains(sampleCodingName)) {
                FlagCoding flagCoding = new FlagCoding(sampleCodingName);
                if (flagValues != null) {
                    CfBandPart.addSamples((SampleCoding)flagCoding, flagMeanings, flagMasks, flagValues, msb);
                } else {
                    CfBandPart.addSamples((SampleCoding)flagCoding, flagMeanings, flagMasks, msb);
                }
                p.getFlagCodingGroup().add((ProductNode)flagCoding);
            }
            band.setSampleCoding((SampleCoding)p.getFlagCodingGroup().get(sampleCodingName));
        } else if (flagValues != null) {
            if (!p.getIndexCodingGroup().contains(sampleCodingName)) {
                IndexCoding indexCoding = new IndexCoding(sampleCodingName);
                CfBandPart.addSamples((SampleCoding)indexCoding, flagMeanings, flagValues, msb);
                p.getIndexCodingGroup().add((ProductNode)indexCoding);
            }
            band.setSampleCoding((SampleCoding)p.getIndexCodingGroup().get(sampleCodingName));
        }
    }

    private static void addSamples(SampleCoding sampleCoding, Attribute sampleMeanings, Attribute sampleValues, boolean msb) {
        String[] meanings = CfBandPart.getSampleMeanings(sampleMeanings);
        String[] uniqueNames = StringUtils.makeStringsUnique((String[])meanings);
        int sampleCount = Math.min(uniqueNames.length, sampleValues.getLength());
        block6: for (int i = 0; i < sampleCount; ++i) {
            String sampleName = CfFlagCodingPart.replaceNonWordCharacters(uniqueNames[i]);
            switch (sampleValues.getDataType()) {
                case BYTE: 
                case UBYTE: {
                    sampleCoding.addSample(sampleName, (int)DataType.unsignedByteToShort((byte)sampleValues.getNumericValue(i).byteValue()), null);
                    continue block6;
                }
                case SHORT: 
                case USHORT: {
                    sampleCoding.addSample(sampleName, DataType.unsignedShortToInt((short)sampleValues.getNumericValue(i).shortValue()), null);
                    continue block6;
                }
                case INT: 
                case UINT: {
                    sampleCoding.addSample(sampleName, sampleValues.getNumericValue(i).intValue(), null);
                    continue block6;
                }
                case LONG: 
                case ULONG: {
                    long sampleValue = sampleValues.getNumericValue(i).longValue();
                    if (msb) {
                        long sampleValueMsb = sampleValue >>> 32;
                        if (sampleValueMsb <= 0L) continue block6;
                        sampleCoding.addSample(sampleName, (int)sampleValueMsb, null);
                        continue block6;
                    }
                    long sampleValueLsb = sampleValue & 0xFFFFFFFFL;
                    if (sampleValueLsb <= 0L && sampleValue != 0L) continue block6;
                    sampleCoding.addSample(sampleName, (int)sampleValueLsb, null);
                }
            }
        }
    }

    private static void addSamples(SampleCoding sampleCoding, Attribute sampleMeanings, Attribute sampleMasks, Attribute sampleValues, boolean msb) {
        String[] meanings = CfBandPart.getSampleMeanings(sampleMeanings);
        String[] uniqueNames = StringUtils.makeStringsUnique((String[])meanings);
        int sampleCount = Math.min(uniqueNames.length, sampleMasks.getLength());
        block6: for (int i = 0; i < sampleCount; ++i) {
            String sampleName = CfFlagCodingPart.replaceNonWordCharacters(uniqueNames[i]);
            switch (sampleMasks.getDataType()) {
                case BYTE: 
                case UBYTE: {
                    int[] byteValues = new int[]{DataType.unsignedByteToShort((byte)sampleMasks.getNumericValue(i).byteValue()), DataType.unsignedByteToShort((byte)sampleValues.getNumericValue(i).byteValue())};
                    if (byteValues[0] == byteValues[1]) {
                        sampleCoding.addSample(sampleName, byteValues[0], null);
                        continue block6;
                    }
                    sampleCoding.addSamples(sampleName, byteValues, null);
                    continue block6;
                }
                case SHORT: 
                case USHORT: {
                    int[] shortValues = new int[]{DataType.unsignedShortToInt((short)sampleMasks.getNumericValue(i).shortValue()), DataType.unsignedShortToInt((short)sampleValues.getNumericValue(i).shortValue())};
                    if (shortValues[0] == shortValues[1]) {
                        sampleCoding.addSample(sampleName, shortValues[0], null);
                        continue block6;
                    }
                    sampleCoding.addSamples(sampleName, shortValues, null);
                    continue block6;
                }
                case INT: 
                case UINT: {
                    int[] intValues = new int[]{sampleMasks.getNumericValue(i).intValue(), sampleValues.getNumericValue(i).intValue()};
                    if (intValues[0] == intValues[1]) {
                        sampleCoding.addSample(sampleName, intValues[0], null);
                        continue block6;
                    }
                    sampleCoding.addSamples(sampleName, intValues, null);
                    continue block6;
                }
                case LONG: 
                case ULONG: {
                    int[] intLongValues;
                    long[] longValues = new long[]{sampleMasks.getNumericValue(i).longValue(), sampleValues.getNumericValue(i).longValue()};
                    if (msb) {
                        intLongValues = new int[]{(int)(longValues[0] >>> 32), (int)(longValues[1] >>> 32)};
                        if (longValues[0] <= 0L) continue block6;
                        if (intLongValues[0] == intLongValues[1]) {
                            sampleCoding.addSample(sampleName, intLongValues[0], null);
                            continue block6;
                        }
                        sampleCoding.addSamples(sampleName, intLongValues, null);
                        continue block6;
                    }
                    intLongValues = new int[]{(int)(longValues[0] & 0xFFFFFFFFL), (int)(longValues[1] & 0xFFFFFFFFL)};
                    if (intLongValues[0] <= 0 && longValues[0] != 0L) continue block6;
                    if (intLongValues[0] == intLongValues[1]) {
                        sampleCoding.addSample(sampleName, intLongValues[0], null);
                        continue block6;
                    }
                    sampleCoding.addSamples(sampleName, intLongValues, null);
                }
            }
        }
    }

    private static String[] getSampleMeanings(Attribute sampleMeanings) {
        int sampleMeaningsCount = sampleMeanings.getLength();
        if (sampleMeaningsCount > 1) {
            String[] strings = new String[sampleMeaningsCount];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = sampleMeanings.getStringValue(i);
            }
            return strings;
        }
        return sampleMeanings.getStringValue().split(" ");
    }

    private String getAutoGrouping(ProfileReadContext ctx) {
        ArrayList<String> bandNames = new ArrayList<String>();
        block0: for (Variable variable : ctx.getRasterDigest().getRasterVariables()) {
            List dimensions = variable.getDimensions();
            int rank = dimensions.size();
            for (int i = 0; i < rank - 2; ++i) {
                ucar.nc2.Dimension dim = (ucar.nc2.Dimension)dimensions.get(i);
                if (dim.getLength() <= 1) continue;
                bandNames.add(variable.getFullName());
                continue block0;
            }
        }
        return StringUtils.join(bandNames, (String)":");
    }
}

