/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartReader;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartReader;

class NetCdfReadProfile {
    private ProfileInitPartReader profileInitPart;
    private final List<ProfilePartReader> profileParts = new ArrayList<ProfilePartReader>();

    NetCdfReadProfile() {
    }

    public void setInitialisationPartReader(ProfileInitPartReader initPart) {
        this.profileInitPart = initPart;
    }

    public void addProfilePartReader(ProfilePartReader profilePart) {
        this.profileParts.add(profilePart);
    }

    public Product readProduct(ProfileReadContext ctx) throws IOException {
        Product product = this.profileInitPart.readProductBody(ctx);
        AbstractProductReader.configurePreferredTileSize((Product)product);
        for (ProfilePartReader profilePart : this.profileParts) {
            profilePart.preDecode(ctx, product);
        }
        for (ProfilePartReader profilePart : this.profileParts) {
            profilePart.decode(ctx, product);
        }
        return product;
    }
}

