/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import java.util.List;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter2;
import ucar.nc2.Variable;
import ucar.nc2.write.Nc4Chunking;

public class NetCDF4Chunking
implements Nc4Chunking {
    private static final int MIN_VARIABLE_BYTES = (int)Math.pow(2.0, 16.0);
    private static final int DEFAULT_CHUNKSIZE_BYTES = (int)Math.pow(2.0, 18.0);
    private static final int MIN_CHUNKSIZE_BYTES = (int)Math.pow(2.0, 13.0);
    private static final int DEFLAT_LEVEL = 5;
    private static final boolean IS_SHUFFLE = true;
    private int minVariableSize = MIN_VARIABLE_BYTES;
    private int defaultChunkSize = DEFAULT_CHUNKSIZE_BYTES;
    private int minChunksize = MIN_CHUNKSIZE_BYTES;

    public boolean isChunked(Variable v) {
        if (v.isUnlimited()) {
            return true;
        }
        long size = v.getSize() * (long)v.getElementSize();
        return size > (long)this.minVariableSize;
    }

    public long[] computeChunking(Variable v) {
        int[] resultFromAtt = this.computeChunkingFromAttribute(v);
        if (resultFromAtt != null) {
            return this.convertToLong(resultFromAtt);
        }
        int maxElements = this.defaultChunkSize / v.getElementSize();
        if (!v.isUnlimited()) {
            int[] result = this.fillRightmost(v.getShape(), maxElements);
            return this.convertToLong(result);
        }
        int[] result = this.computeUnlimitedChunking(v.getDimensions(), v.getElementSize());
        return this.convertToLong(result);
    }

    private int[] computeChunkingFromAttribute(Variable v) {
        Attribute att = this.getChunkAttribute(v);
        if (att != null) {
            int[] result = new int[v.getRank()];
            for (int i = 0; i < v.getRank(); ++i) {
                result[i] = att.getNumericValue(i).intValue();
            }
            return result;
        }
        return null;
    }

    private int[] computeUnlimitedChunking(List<Dimension> dims, int elemSize) {
        int maxElements = this.defaultChunkSize / elemSize;
        int[] result = this.fillRightmost(this.convertUnlimitedShape(dims), maxElements);
        long resultSize = new Section(result).computeSize();
        if (resultSize < (long)this.minChunksize) {
            maxElements = this.minChunksize / elemSize;
            result = this.incrUnlimitedShape(dims, result, maxElements);
        }
        return result;
    }

    private int[] fillRightmost(int[] shape, int maxElements) {
        FileWriter2.ChunkingIndex index = new FileWriter2.ChunkingIndex(shape);
        return index.computeChunkShape((long)maxElements);
    }

    private long[] convertToLong(int[] shape) {
        if (shape.length == 0) {
            shape = new int[1];
        }
        long[] result = new long[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            result[i] = shape[i] > 0 ? (long)shape[i] : 1L;
        }
        return result;
    }

    private int[] convertUnlimitedShape(List<Dimension> dims) {
        int[] result = new int[dims.size()];
        int count = 0;
        for (Dimension d : dims) {
            result[count++] = d.isUnlimited() ? 1 : d.getLength();
        }
        return result;
    }

    private Attribute getChunkAttribute(Variable v) {
        Attribute att = v.findAttribute("_ChunkSizes");
        if (att != null && att.getDataType().isIntegral() && att.getLength() == v.getRank()) {
            return att;
        }
        return null;
    }

    private int[] incrUnlimitedShape(List<Dimension> dims, int[] shape, long maxElements) {
        int countUnlimitedDims = 0;
        for (Dimension d : dims) {
            if (!d.isUnlimited()) continue;
            ++countUnlimitedDims;
        }
        long shapeSize = new Section(shape).computeSize();
        int needFactor = (int)(maxElements / shapeSize);
        int need = countUnlimitedDims <= 1 ? needFactor : (countUnlimitedDims == 2 ? (int)Math.sqrt(needFactor) : (countUnlimitedDims == 3 ? (int)Math.cbrt(needFactor) : (int)Math.pow(needFactor, 1.0 / (double)countUnlimitedDims)));
        int[] result = new int[shape.length];
        int count = 0;
        for (Dimension d : dims) {
            result[count] = d.isUnlimited() ? need : shape[count];
            ++count;
        }
        return result;
    }

    public int getDeflateLevel(Variable v) {
        return 5;
    }

    public boolean isShuffle(Variable v) {
        return true;
    }
}

