/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.netcdf.DefaultNetCdfReader;
import org.esa.snap.dataio.netcdf.NullProfilePartReader;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartReader;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartReader;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import org.esa.snap.dataio.netcdf.util.RasterDigest;
import ucar.nc2.NetcdfFile;

public abstract class AbstractNetCdfReaderPlugIn
implements ProductReaderPlugIn {
    private static final String ZIP_FILE_EXTENSION = ".zip";

    public final Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DecodeQualification getDecodeQualification(Object input) {
        NetcdfFile netcdfFile = null;
        try {
            netcdfFile = NetcdfFileOpener.open(input.toString());
            if (netcdfFile == null) {
                DecodeQualification decodeQualification = DecodeQualification.UNABLE;
                return decodeQualification;
            }
            DecodeQualification decodeQualification = this.getDecodeQualification(netcdfFile);
            return decodeQualification;
        }
        catch (Throwable ignored) {
            String trimmed;
            File file;
            String pathname;
            if (input != null && (pathname = input.toString()).toLowerCase().trim().endsWith(ZIP_FILE_EXTENSION) && (file = new File(pathname = (trimmed = pathname.trim()).substring(0, trimmed.length() - 4))).isFile() && file.length() == 0L && !file.delete()) {
                file.deleteOnExit();
            }
        }
        finally {
            try {
                if (netcdfFile != null) {
                    netcdfFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return DecodeQualification.UNABLE;
    }

    public ProductReader createReaderInstance() {
        return new DefaultNetCdfReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    protected void initReadContext(ProfileReadContext ctx) throws IOException {
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        RasterDigest rasterDigest = RasterDigest.createRasterDigest(netcdfFile.getRootGroup());
        if (rasterDigest == null) {
            throw new IOException("File does not contain any bands.");
        }
        ctx.setRasterDigest(rasterDigest);
    }

    protected abstract DecodeQualification getDecodeQualification(NetcdfFile var1);

    public abstract ProfileInitPartReader createInitialisationPartReader();

    public ProfilePartReader createMetadataPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createBandPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createFlagCodingPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createGeoCodingPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createImageInfoPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createIndexCodingPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createMaskPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createStxPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createTiePointGridPartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createTimePartReader() {
        return new NullProfilePartReader();
    }

    public ProfilePartReader createDescriptionPartReader() {
        return new NullProfilePartReader();
    }
}

