/*
 * Decompiled with CFR 0.152.
 */
package eu.esa.snap.netbeans.javahelp;

import eu.esa.snap.netbeans.javahelp.HelpAction;
import eu.esa.snap.netbeans.javahelp.JavaHelp;
import eu.esa.snap.netbeans.javahelp.api.Help;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;

public class Installer
extends ModuleInstall {
    public static final Logger log = Logger.getLogger("eu.esa.snap.netbeans.javahelp");
    public static final Logger UI = Logger.getLogger("org.netbeans.ui.javahelp");
    public static final Logger USG = Logger.getLogger("org.netbeans.ui.metrics.javahelp");

    private static void cleanDefaults(UIDefaults d) {
        HashSet badKeys = new HashSet(10);
        Iterator it = d.entrySet().iterator();
        ClassLoader aboutToDie = Installer.class.getClassLoader();
        while (it.hasNext()) {
            Class c;
            Map.Entry e;
            try {
                e = it.next();
            }
            catch (ConcurrentModificationException x) {
                return;
            }
            Object k = e.getKey();
            Object o = e.getValue();
            if (o instanceof Class) {
                c = (Class)o;
                if (c.getClassLoader() != aboutToDie) continue;
                badKeys.add(k);
                continue;
            }
            if (!(k instanceof Class) || (c = (Class)k).getClassLoader() != aboutToDie) continue;
            badKeys.add(k);
        }
        if (!badKeys.isEmpty()) {
            log.fine("Cleaning up old UIDefaults keys (JRE bug #4675772): " + badKeys);
            for (Object o : badKeys) {
                d.put(o, (Object)null);
            }
        }
    }

    public void restored() {
        log.fine("restored module");
        HelpAction.WindowActivatedDetector.install();
        Help lookup = (Help)Lookup.getDefault().lookup(Help.class);
    }

    public void uninstalled() {
        log.fine("uninstalled module");
        Help help = (Help)Lookup.getDefault().lookup(Help.class);
        if (help instanceof JavaHelp) {
            ((JavaHelp)help).deactivate();
        }
        HelpAction.WindowActivatedDetector.uninstall();
        Installer.cleanDefaults(UIManager.getDefaults());
        Installer.cleanDefaults(UIManager.getLookAndFeelDefaults());
    }
}

