/*
 * Decompiled with CFR 0.152.
 */
package eu.esa.snap.netbeans.javahelp;

import eu.esa.snap.netbeans.javahelp.CopyLinkLocationAction;
import eu.esa.snap.netbeans.javahelp.Installer;
import eu.esa.snap.netbeans.javahelp.Utils;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HyperlinkEventProcessor
extends MouseAdapter
implements HyperlinkListener,
CopyLinkLocationAction.LinkOwner {
    private boolean isInsideHyperlink = false;
    private URL url;
    private JEditorPane pane;
    private JPopupMenu popupMenu;

    private HyperlinkEventProcessor(JEditorPane pane) {
        this.pane = pane;
        this.popupMenu = HyperlinkEventProcessor.getPopupMenu(new CopyLinkLocationAction(this));
    }

    static JPopupMenu getPopupMenu(CopyLinkLocationAction cllAction) {
        JMenuItem copyItem = new JMenuItem(cllAction);
        JPopupMenu menu = new JPopupMenu();
        menu.add(copyItem);
        return menu;
    }

    public static void addTo(JEditorPane pane) {
        assert (pane != null);
        HyperlinkEventProcessor proc = new HyperlinkEventProcessor(pane);
        pane.addHyperlinkListener(proc);
        pane.addMouseListener(proc);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        this.url = hyperlinkEvent.getURL();
        HyperlinkEvent.EventType type = hyperlinkEvent.getEventType();
        if (type == HyperlinkEvent.EventType.ENTERED) {
            this.isInsideHyperlink = true;
            this.pane.setToolTipText(this.getURLExternalForm());
        } else if (type == HyperlinkEvent.EventType.ACTIVATED) {
            this.isInsideHyperlink = false;
            this.pane.setToolTipText(null);
        } else if (type == HyperlinkEvent.EventType.EXITED) {
            this.isInsideHyperlink = false;
            this.pane.setToolTipText(null);
        } else {
            Installer.log.log(Level.SEVERE, "Unknown hyperlinkEvent: " + hyperlinkEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isInsideHyperlink && Utils.isMouseRightClick(e)) {
            Utils.showPopupMenu(e, this.popupMenu, this.pane);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public String getURLExternalForm() {
        return this.url == null ? null : this.url.toExternalForm();
    }

    @Override
    public Clipboard getClipboard() {
        return this.pane.getToolkit().getSystemClipboard();
    }
}

