/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class FlatCheckBoxIcon
extends FlatAbstractIcon {
    public final int focusWidth = UIManager.getInt("Component.focusWidth");
    protected final Color focusColor = FlatUIUtils.getUIColor("CheckBox.icon.focusedColor", UIManager.getColor("Component.focusColor"));
    protected final int arc = FlatUIUtils.getUIInt("CheckBox.arc", 2);
    protected final Color borderColor = UIManager.getColor("CheckBox.icon.borderColor");
    protected final Color disabledBorderColor = UIManager.getColor("CheckBox.icon.disabledBorderColor");
    protected final Color selectedBorderColor = UIManager.getColor("CheckBox.icon.selectedBorderColor");
    protected final Color focusedBorderColor = UIManager.getColor("CheckBox.icon.focusedBorderColor");
    protected final Color hoverBorderColor = UIManager.getColor("CheckBox.icon.hoverBorderColor");
    protected final Color selectedFocusedBorderColor = UIManager.getColor("CheckBox.icon.selectedFocusedBorderColor");
    protected final Color background = UIManager.getColor("CheckBox.icon.background");
    protected final Color disabledBackground = UIManager.getColor("CheckBox.icon.disabledBackground");
    protected final Color focusedBackground = UIManager.getColor("CheckBox.icon.focusedBackground");
    protected final Color hoverBackground = UIManager.getColor("CheckBox.icon.hoverBackground");
    protected final Color pressedBackground = UIManager.getColor("CheckBox.icon.pressedBackground");
    protected final Color selectedBackground = UIManager.getColor("CheckBox.icon.selectedBackground");
    protected final Color selectedHoverBackground = UIManager.getColor("CheckBox.icon.selectedHoverBackground");
    protected final Color selectedPressedBackground = UIManager.getColor("CheckBox.icon.selectedPressedBackground");
    protected final Color checkmarkColor = UIManager.getColor("CheckBox.icon.checkmarkColor");
    protected final Color disabledCheckmarkColor = UIManager.getColor("CheckBox.icon.disabledCheckmarkColor");
    static final int ICON_SIZE = 15;

    public FlatCheckBoxIcon() {
        super(15, 15, null);
    }

    @Override
    protected void paintIcon(Component c, Graphics2D g2) {
        boolean selected;
        boolean indeterminate = c instanceof JComponent && FlatClientProperties.clientPropertyEquals((JComponent)c, "JButton.selectedState", "indeterminate");
        boolean bl = selected = indeterminate || c instanceof AbstractButton && ((AbstractButton)c).isSelected();
        if (c.hasFocus() && this.focusWidth > 0) {
            g2.setColor(this.focusColor);
            this.paintFocusBorder(g2);
        }
        g2.setColor(FlatButtonUI.buttonStateColor(c, selected ? this.selectedBorderColor : this.borderColor, this.disabledBorderColor, selected && this.selectedFocusedBorderColor != null ? this.selectedFocusedBorderColor : this.focusedBorderColor, this.hoverBorderColor, null));
        this.paintBorder(g2);
        FlatUIUtils.setColor(g2, FlatButtonUI.buttonStateColor(c, selected ? this.selectedBackground : this.background, this.disabledBackground, this.focusedBackground, selected && this.selectedHoverBackground != null ? this.selectedHoverBackground : this.hoverBackground, selected && this.selectedPressedBackground != null ? this.selectedPressedBackground : this.pressedBackground), this.background);
        this.paintBackground(g2);
        if (selected || indeterminate) {
            g2.setColor(c.isEnabled() ? this.checkmarkColor : this.disabledCheckmarkColor);
            if (indeterminate) {
                this.paintIndeterminate(g2);
            } else {
                this.paintCheckmark(g2);
            }
        }
    }

    protected void paintFocusBorder(Graphics2D g2) {
        int wh = 14 + this.focusWidth * 2;
        int arcwh = this.arc + this.focusWidth * 2;
        g2.fillRoundRect(-this.focusWidth + 1, -this.focusWidth, wh, wh, arcwh, arcwh);
    }

    protected void paintBorder(Graphics2D g2) {
        int arcwh = this.arc;
        g2.fillRoundRect(1, 0, 14, 14, arcwh, arcwh);
    }

    protected void paintBackground(Graphics2D g2) {
        int arcwh = this.arc - 1;
        g2.fillRoundRect(2, 1, 12, 12, arcwh, arcwh);
    }

    protected void paintCheckmark(Graphics2D g2) {
        Path2D.Float path = new Path2D.Float();
        path.moveTo(4.5f, 7.5f);
        path.lineTo(6.6f, 10.0f);
        path.lineTo(11.25f, 3.5f);
        g2.setStroke(new BasicStroke(1.9f, 1, 1));
        g2.draw(path);
    }

    protected void paintIndeterminate(Graphics2D g2) {
        g2.fill(new RoundRectangle2D.Float(3.75f, 5.75f, 8.5f, 2.5f, 2.0f, 2.0f));
    }
}

