/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wms.map;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.io.ImageIOExt;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.request.GetFeatureInfoRequest;
import org.geotools.ows.wms.request.GetMapRequest;
import org.geotools.ows.wms.response.GetFeatureInfoResponse;
import org.geotools.ows.wms.response.GetMapResponse;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSCoverageReader
extends AbstractGridCoverage2DReader {
    public static final Logger LOGGER = Logging.getLogger(WMSCoverageReader.class);
    static GridCoverageFactory gcf = new GridCoverageFactory();
    WebMapServer wms;
    List<LayerStyle> layers = new ArrayList<LayerStyle>();
    String srsName;
    String format;
    GetMapRequest mapRequest;
    GridCoverage2D grid;
    Set<String> validSRS;
    ReferencedEnvelope bounds;
    ReferencedEnvelope requestedEnvelope;
    int width;
    int height;
    CoordinateReferenceSystem requestCRS;

    public WMSCoverageReader(WebMapServer wms, Layer layer) {
        this(wms, layer, "");
    }

    public WMSCoverageReader(WebMapServer wms, Layer layer, String style) {
        this.wms = wms;
        this.addLayer(layer, style);
        List<String> formats = wms.getCapabilities().getRequest().getGetMap().getFormats();
        this.format = this.getDefaultFormat(formats);
    }

    public WMSCoverageReader(WebMapServer wms, Layer layer, String style, String preferredFormat) {
        this.wms = wms;
        this.addLayer(layer, style);
        List<String> formats = wms.getCapabilities().getRequest().getGetMap().getFormats();
        this.format = preferredFormat;
        if (!formats.contains(preferredFormat)) {
            this.format = this.getDefaultFormat(formats);
        }
    }

    public String getDefaultFormat(List<String> formats) {
        for (String format : formats) {
            if (!"image/png".equals(format) && !"image/png24".equals(format) && !"png".equals(format) && !"png24".equals(format) && !"image/png; mode=24bit".equals(format)) continue;
            return format;
        }
        return !formats.isEmpty() ? formats.get(0) : "image/png";
    }

    void addLayer(Layer layer) {
        this.addLayer(layer, "");
    }

    void addLayer(Layer layer, String style) {
        this.layers.add(new LayerStyle(layer, style));
        if (this.srsName == null) {
            String priorityCRS = this.getCRSWithBoundingBoxes(layer);
            if (priorityCRS != null) {
                this.srsName = priorityCRS;
            }
            if (this.srsName == null) {
                for (String srs : layer.getBoundingBoxes().keySet()) {
                    try {
                        CRS.decode((String)srs);
                        this.srsName = srs;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (this.srsName == null) {
                this.srsName = layer.getSrs().contains("EPSG:4326") ? "EPSG:4326" : layer.getSrs().iterator().next();
            }
            this.validSRS = new LinkedHashSet<String>(layer.getSrs());
        } else {
            LinkedHashSet<String> intersection = new LinkedHashSet<String>(this.validSRS);
            intersection.retainAll(layer.getSrs());
            if (!intersection.contains(this.srsName)) {
                if (intersection.isEmpty()) {
                    throw new IllegalArgumentException("The layer being appended does not have any SRS in common with the ones already included in the WMS request, cannot be merged");
                }
                this.srsName = intersection.contains("EPSG:4326") ? "EPSG:4326" : (String)intersection.iterator().next();
                this.validSRS = intersection;
            }
        }
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)this.srsName);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Bounds unavailable for layer" + layer);
        }
        this.crs = crs;
        this.updateBounds();
    }

    private String getCRSWithBoundingBoxes(Layer layer) {
        for (String srs : this.getCRSWithBoundingBoxesList(layer)) {
            try {
                CRS.decode((String)srs);
                return srs;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error decoding CRS code.", e);
            }
        }
        return null;
    }

    private List<String> getCRSWithBoundingBoxesList(Layer layer) {
        LinkedHashSet<String> layerSrsSet = new LinkedHashSet<String>(layer.getSrs());
        Map<String, CRSEnvelope> boundingBoxes = layer.getBoundingBoxes();
        return layerSrsSet.stream().filter(boundingBoxes::containsKey).collect(Collectors.toList());
    }

    public InputStream getFeatureInfo(DirectPosition2D pos, String infoFormat, int featureCount, GetMapRequest getmap) throws IOException {
        GetFeatureInfoRequest request = this.wms.createGetFeatureInfoRequest(getmap);
        request.setFeatureCount(1);
        LinkedHashSet<Layer> queryLayers = new LinkedHashSet<Layer>();
        for (LayerStyle ls : this.layers) {
            queryLayers.add(ls.getLayer());
        }
        request.setQueryLayers(queryLayers);
        request.setInfoFormat(infoFormat);
        request.setFeatureCount(featureCount);
        try {
            AffineTransform tx = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)this.requestedEnvelope, (Rectangle)new Rectangle(this.width, this.height));
            Point2D.Double dest = new Point2D.Double();
            Point2D.Double src = new Point2D.Double(pos.x, pos.y);
            tx.transform(src, dest);
            request.setQueryPoint((int)((Point2D)dest).getX(), (int)((Point2D)dest).getY());
        }
        catch (Exception e) {
            throw new IOException("Failed to grab feature info", e);
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Issuing request: " + request.getFinalURL());
            }
            GetFeatureInfoResponse response = this.wms.issueRequest(request);
            return response.getInputStream();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException("Failed to grab feature info", t);
        }
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        GeneralEnvelope requestedEnvelope = null;
        int width = -1;
        int height = -1;
        Color backgroundColor = null;
        if (parameters != null) {
            for (GeneralParameterValue param : parameters) {
                ReferenceIdentifier name = param.getDescriptor().getName();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                    GridGeometry2D gg = (GridGeometry2D)((ParameterValue)param).getValue();
                    requestedEnvelope = gg.getEnvelope();
                    width = gg.getGridRange().getHigh(0) + 1;
                    height = gg.getGridRange().getHigh(1) + 1;
                    continue;
                }
                if (!name.equals(AbstractGridFormat.BACKGROUND_COLOR.getName())) continue;
                backgroundColor = (Color)((ParameterValue)param).getValue();
            }
        }
        if (requestedEnvelope == null) {
            requestedEnvelope = this.getOriginalEnvelope();
            width = 640;
            height = (int)Math.round(requestedEnvelope.getSpan(1) / requestedEnvelope.getSpan(0) * 640.0);
        }
        if (this.grid != null && this.grid.getGridGeometry().getGridRange2D().getWidth() == (double)width && this.grid.getGridGeometry().getGridRange2D().getHeight() == (double)height && this.grid.getEnvelope().equals(requestedEnvelope)) {
            return this.grid;
        }
        this.grid = this.getMap(this.reference((Envelope)requestedEnvelope), width, height, backgroundColor);
        return this.grid;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    GridCoverage2D getMap(ReferencedEnvelope requestedEnvelope, int width, int height, Color backgroundColor) throws IOException {
        ReferencedEnvelope gridEnvelope = this.initMapRequest(requestedEnvelope, width, height, backgroundColor);
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Issuing request: " + this.mapRequest.getFinalURL());
            }
            GetMapResponse response = this.wms.issueRequest(this.mapRequest);
            try {
                try (InputStream is = response.getInputStream();){
                    RenderedImage image = ImageIOExt.read((Object)is);
                    if (image == null) {
                        throw new IOException("GetMap failed: " + this.mapRequest.getFinalURL());
                    }
                    GridCoverage2D gridCoverage2D = gcf.create((CharSequence)this.layers.get(0).getLayer().getTitle(), image, (Envelope)gridEnvelope);
                    return gridCoverage2D;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                response.dispose();
            }
        }
        catch (ServiceException e) {
            throw new IOException("GetMap failed", e);
        }
    }

    ReferencedEnvelope initMapRequest(ReferencedEnvelope bbox, int width, int height, Color backgroundColor) throws IOException {
        ReferencedEnvelope gridEnvelope = bbox;
        String requestSrs = this.srsName;
        try {
            String code = null;
            Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)bbox.getCoordinateReferenceSystem(), (boolean)false);
            code = epsgCode != null ? "EPSG:" + epsgCode : CRS.lookupIdentifier((IdentifiedObject)bbox.getCoordinateReferenceSystem(), (boolean)false);
            if (code != null && this.validSRS.contains(code)) {
                requestSrs = code;
            } else {
                gridEnvelope = bbox.transform(this.getCoordinateReferenceSystem(), true);
                if (gridEnvelope.getWidth() < gridEnvelope.getHeight()) {
                    height = (int)Math.round((double)width * gridEnvelope.getHeight() / gridEnvelope.getWidth());
                } else {
                    width = (int)Math.round((double)height * gridEnvelope.getWidth() / gridEnvelope.getHeight());
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Could not reproject the request envelope", e);
        }
        GetMapRequest mapRequest = this.wms.createGetMapRequest();
        ArrayList<LayerStyle> reversed = new ArrayList<LayerStyle>(this.layers);
        Collections.reverse(reversed);
        for (LayerStyle layer : reversed) {
            mapRequest.addLayer(layer.getLayer(), layer.getStyle());
        }
        mapRequest.setDimensions(width, height);
        mapRequest.setFormat(this.format);
        if (backgroundColor == null) {
            mapRequest.setTransparent(true);
        } else {
            String rgba = Integer.toHexString(backgroundColor.getRGB());
            String rgb = rgba.substring(2, rgba.length());
            mapRequest.setBGColour("0x" + rgb.toUpperCase());
            mapRequest.setTransparent(backgroundColor.getAlpha() < 255);
        }
        try {
            this.requestCRS = CRS.decode((String)requestSrs);
        }
        catch (Exception e) {
            throw new IOException("Could not decode request SRS " + requestSrs);
        }
        ReferencedEnvelope requestEnvelope = gridEnvelope;
        mapRequest.setBBox(requestEnvelope);
        mapRequest.setSRS(requestSrs);
        this.mapRequest = mapRequest;
        this.requestedEnvelope = gridEnvelope;
        this.width = width;
        this.height = height;
        return gridEnvelope;
    }

    public Format getFormat() {
        return null;
    }

    public void updateBounds() {
        ReferencedEnvelope result = this.reference(this.layers.get(0).getLayer().getEnvelope(this.crs));
        for (int i = 1; i < this.layers.size(); ++i) {
            ReferencedEnvelope layerEnvelope = this.reference(this.layers.get(i).getLayer().getEnvelope(this.crs));
            result.expandToInclude(layerEnvelope);
        }
        this.bounds = result;
        this.originalEnvelope = new GeneralEnvelope((Envelope)result);
    }

    ReferencedEnvelope reference(Envelope envelope) {
        ReferencedEnvelope env = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
        env.expandToInclude(envelope.getMinimum(0), envelope.getMinimum(1));
        env.expandToInclude(envelope.getMaximum(0), envelope.getMaximum(1));
        return env;
    }

    ReferencedEnvelope reference(GeneralEnvelope ge) {
        return new ReferencedEnvelope(ge.getMinimum(0), ge.getMaximum(0), ge.getMinimum(1), ge.getMaximum(1), ge.getCoordinateReferenceSystem());
    }

    public String[] getMetadataNames() {
        return new String[]{"ReprojectingReader"};
    }

    public String getMetadataValue(String name) {
        if ("ReprojectingReader".equals(name)) {
            return "true";
        }
        return super.getMetadataValue(name);
    }

    public List<Layer> getLayers() {
        ArrayList<Layer> ret = new ArrayList<Layer>();
        for (LayerStyle l : this.layers) {
            ret.add(l.getLayer());
        }
        return ret;
    }

    public List<String> getStyles() {
        ArrayList<String> ret = new ArrayList<String>();
        for (LayerStyle l : this.layers) {
            ret.add(l.getStyle());
        }
        return ret;
    }

    private class LayerStyle {
        private Layer layer;
        private String style = "";

        public LayerStyle(Layer layer, String style) {
            this.layer = layer;
            this.style = style;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public String getStyle() {
            return this.style;
        }
    }
}

