/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.gml;

import java.util.List;
import org.geotools.xml.gml.ChoiceAttributeTypeImpl;
import org.geotools.xml.gml.ChoiceGeometryType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ChoiceGeometryTypeImpl
extends ChoiceAttributeTypeImpl
implements ChoiceGeometryType,
GeometryType {
    private CoordinateReferenceSystem crs;

    public ChoiceGeometryTypeImpl(Name name, Class[] types, Class defaultType, boolean nillable, int min, int max, Object defaultValue, CoordinateReferenceSystem crs, List<Filter> filter) {
        super(name, types, defaultType, nillable, min, max, defaultValue, filter);
        this.crs = crs;
    }

    @Override
    public Object convert(Object obj) {
        GeometryFactory fac = new GeometryFactory();
        if (this.getBinding() == MultiPolygon.class && obj instanceof Polygon) {
            return fac.createMultiPolygon(new Polygon[]{(Polygon)obj});
        }
        if (this.getBinding() == MultiPoint.class && obj instanceof Point) {
            return fac.createMultiPoint(new Point[]{(Point)obj});
        }
        if (this.getBinding() == MultiLineString.class && obj instanceof LineString) {
            return fac.createMultiLineString(new LineString[]{(LineString)obj});
        }
        if (this.getBinding() == GeometryCollection.class && obj instanceof Geometry) {
            return fac.createGeometryCollection(new Geometry[]{(Geometry)obj});
        }
        return obj;
    }

    public GeometryType getType() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }
}

