/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewelcli.internal.guava.collect;

import com.lexicalscope.jewelcli.internal.guava.base.$Preconditions;
import com.lexicalscope.jewelcli.internal.guava.base.$Predicate;
import com.lexicalscope.jewelcli.internal.guava.collect.$AbstractIterator;
import com.lexicalscope.jewelcli.internal.guava.collect.$UnmodifiableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class $Iterators {
    static final $UnmodifiableIterator<Object> EMPTY_ITERATOR = new $UnmodifiableIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    };
    private static final Iterator<Object> EMPTY_MODIFIABLE_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    public static int size(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static <T> boolean removeIf(Iterator<T> removeFrom, $Predicate<? super T> predicate) {
        $Preconditions.checkNotNull(predicate);
        boolean modified = false;
        while (removeFrom.hasNext()) {
            if (!predicate.apply(removeFrom.next())) continue;
            removeFrom.remove();
            modified = true;
        }
        return modified;
    }

    public static String toString(Iterator<?> iterator) {
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[').append(iterator.next());
        while (iterator.hasNext()) {
            builder.append(", ").append(iterator.next());
        }
        return builder.append(']').toString();
    }

    public static <T> $UnmodifiableIterator<T> filter(final Iterator<T> unfiltered, final $Predicate<? super T> predicate) {
        $Preconditions.checkNotNull(unfiltered);
        $Preconditions.checkNotNull(predicate);
        return new $AbstractIterator<T>(){

            @Override
            protected T computeNext() {
                while (unfiltered.hasNext()) {
                    Object element = unfiltered.next();
                    if (!predicate.apply(element)) continue;
                    return element;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> boolean any(Iterator<T> iterator, $Predicate<? super T> predicate) {
        $Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!predicate.apply(element)) continue;
            return true;
        }
        return false;
    }
}

