/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewelcli.internal.fluentreflection;

import com.lexicalscope.jewelcli.internal.fluentreflection.$AbstractFluentAnnotated;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ConvertTypeLiteralToReflectedType;
import com.lexicalscope.jewelcli.internal.fluentreflection.$FluentClass;
import com.lexicalscope.jewelcli.internal.fluentreflection.$FluentMethod;
import com.lexicalscope.jewelcli.internal.fluentreflection.$FluentObject;
import com.lexicalscope.jewelcli.internal.fluentreflection.$IllegalAccessRuntimeException;
import com.lexicalscope.jewelcli.internal.fluentreflection.$IllegalArgumentRuntimeException;
import com.lexicalscope.jewelcli.internal.fluentreflection.$InvocationTargetRuntimeException;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedTypeFactory;
import com.lexicalscope.jewelcli.internal.fluentreflection.$Visibility;
import com.lexicalscope.jewelcli.internal.guice.$TypeLiteral;
import com.lexicalscope.jewelcli.internal.lamdaj.$Lambda;
import com.lexicalscope.jewelcli.internal.lang3.builder.$EqualsBuilder;
import com.lexicalscope.jewelcli.internal.lang3.builder.$HashCodeBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class $FluentMethodImpl
extends $AbstractFluentAnnotated
implements $FluentMethod {
    private final $ReflectedTypeFactory reflectedTypeFactory;
    private final $TypeLiteral<?> typeLiteral;
    private final Method method;

    public $FluentMethodImpl($ReflectedTypeFactory reflectedTypeFactory, $TypeLiteral<?> typeLiteral, Method method) {
        super(reflectedTypeFactory, method);
        this.reflectedTypeFactory = reflectedTypeFactory;
        this.typeLiteral = typeLiteral;
        this.method = method;
    }

    @Override
    public String name() {
        return this.method.getName();
    }

    @Override
    public List<$FluentClass<?>> args() {
        ArrayList result = new ArrayList();
        result.addAll($Lambda.convert(this.typeLiteral.getParameterTypes(this.method), new $ConvertTypeLiteralToReflectedType(this.reflectedTypeFactory)));
        return result;
    }

    @Override
    public int argCount() {
        return this.method.getParameterTypes().length;
    }

    @Override
    public $FluentClass<?> declarer() {
        return this.reflectedTypeFactory.reflect(this.typeLiteral);
    }

    @Override
    public $FluentObject<?> call(Object ... args) {
        Object object = this.callRaw(args);
        if (object == null && this.typeLiteral.getReturnType(this.method) != null) {
            return this.reflectedTypeFactory.reflect(this.typeLiteral.getReturnType(this.method), null);
        }
        return this.reflectedTypeFactory.reflect(object.getClass(), object);
    }

    private Object callRaw(Object ... args) {
        if (this.isStatic()) {
            return this.invokeMethod(null, args);
        }
        if (args.length < 1) {
            throw new IllegalArgumentException("target instance must be specified as first argument when calling " + this.method);
        }
        if (args[0] == null) {
            return null;
        }
        Object[] remainingArguments = new Object[args.length - 1];
        System.arraycopy(args, 1, remainingArguments, 0, args.length - 1);
        return this.invokeMethod(args[0], remainingArguments);
    }

    private Object invokeMethod(Object instance, Object[] arguments) {
        try {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            return this.method.invoke(instance, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new $IllegalArgumentRuntimeException(e, this.method, instance, arguments);
        }
        catch (IllegalAccessException e) {
            throw new $IllegalAccessRuntimeException(e, this.method);
        }
        catch (InvocationTargetException e) {
            throw new $InvocationTargetRuntimeException(e, this.method);
        }
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.method.getModifiers());
    }

    @Override
    public $FluentClass<?> type() {
        $TypeLiteral<?> returnType = this.typeLiteral.getReturnType(this.method);
        if (returnType == null) {
            return null;
        }
        return this.reflectedTypeFactory.reflect(returnType);
    }

    @Override
    public String property() {
        String name = this.name();
        if (name.length() > 2) {
            if (name.length() > 3 && (name.startsWith("get") || name.startsWith("set"))) {
                return this.initialLowerCase(name.substring(3));
            }
            if (name.startsWith("is")) {
                return this.initialLowerCase(name.substring(2));
            }
        }
        return this.method.getName();
    }

    private String initialLowerCase(String substring) {
        return substring.substring(0, 1).toLowerCase() + substring.substring(1);
    }

    @Override
    public Method member() {
        return this.method;
    }

    @Override
    public $Visibility visibility() {
        return $Visibility.visibilityFromModifiers(this.method.getModifiers());
    }

    private List<TypeVariable<Method>> typeParameters() {
        return Arrays.asList(this.method.getTypeParameters());
    }

    public String toString() {
        String visibility = this.visibility().toString().isEmpty() ? this.visibility().toString() : this.visibility().toString() + " ";
        String staticModifier = this.isStatic() ? "static " : "";
        String finalModifier = this.isFinal() ? "final " : "";
        String typeParameters = this.typeParameters().isEmpty() ? "" : "<" + $Lambda.joinFrom(this.typeParameters(), ", ").toString() + "> ";
        String arguments = this.argCount() > 0 ? $Lambda.joinFrom(this.args(), ", ").toString() : "";
        return String.format("%s%s%s%s%s %s(%s)", visibility, staticModifier, finalModifier, typeParameters, this.type(), this.method.getName(), arguments);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().equals(obj.getClass())) {
            $FluentMethodImpl that = ($FluentMethodImpl)obj;
            return new $EqualsBuilder().append(this.method, that.method).append(this.typeLiteral, that.typeLiteral).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new $HashCodeBuilder().append(this.method).append(this.typeLiteral).toHashCode();
    }
}

