/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jaitools.CollectionFactory;
import org.jaitools.numeric.Range;

public class RangeExtendedComparator<T extends Number> {
    public static final int LT = -1;
    public static final int EQ = 0;
    public static final int GT = 1;
    private static final int UNDEFINED = -2;
    public static final int MIN_MAX = 0;
    public static final int MIN_MIN = 1;
    public static final int MAX_MAX = 2;
    public static final int MAX_MIN = 3;

    public static boolean isIntersection(Result r) {
        return r != Result.LLLL && r != Result.GGGG;
    }

    public Result compare(Range<T> r1, Range<T> r2) {
        int flag;
        if (r1.isPoint() || r2.isPoint()) {
            return this.pointCompare(r1, r2);
        }
        int[] compFlags = new int[4];
        compFlags[0] = -2;
        compFlags[0] = r1.isMinClosed() ? (r2.isMaxClosed() ? ((flag = this.validFlag(((Comparable)r1.getMin()).compareTo(r2.getMax()))) == 0 ? (r1.isMinIncluded() ? (r2.isMaxIncluded() ? 0 : 1) : 1) : flag) : -1) : -1;
        assert (compFlags[0] != -2);
        compFlags[1] = -2;
        compFlags[1] = r1.isMinClosed() ? (r2.isMinClosed() ? ((flag = this.validFlag(((Comparable)r1.getMin()).compareTo(r2.getMin()))) == 0 ? (r1.isMinIncluded() ? (r2.isMinIncluded() ? 0 : -1) : (r2.isMinIncluded() ? 1 : 0)) : flag) : 1) : (r2.isMinClosed() ? -1 : 0);
        assert (compFlags[1] != -2);
        compFlags[2] = -2;
        compFlags[2] = r1.isMaxClosed() ? (r2.isMaxClosed() ? ((flag = this.validFlag(((Comparable)r1.getMax()).compareTo(r2.getMax()))) == 0 ? (r1.isMaxIncluded() ? (r2.isMaxIncluded() ? 0 : 1) : (r2.isMaxIncluded() ? -1 : 0)) : flag) : -1) : (r2.isMaxClosed() ? 1 : 0);
        assert (compFlags[2] != -2);
        compFlags[3] = -2;
        compFlags[3] = r1.isMaxClosed() ? (r2.isMinClosed() ? ((flag = this.validFlag(((Comparable)r1.getMax()).compareTo(r2.getMin()))) == 0 ? (r1.isMaxIncluded() ? (r2.isMinIncluded() ? 0 : -1) : -1) : flag) : 1) : 1;
        assert (compFlags[3] != -2);
        return Result.get(compFlags);
    }

    private Result pointCompare(Range<T> r1, Range<T> r2) {
        int[] compFlags = new int[4];
        if (r1.isPoint() && r2.isPoint()) {
            if (r1.isMinNegInf()) {
                if (r2.isMinNegInf()) {
                    compFlags[3] = 0;
                    compFlags[2] = 0;
                    compFlags[1] = 0;
                    compFlags[0] = 0;
                } else {
                    compFlags[3] = -1;
                    compFlags[2] = -1;
                    compFlags[1] = -1;
                    compFlags[0] = -1;
                }
            } else if (r1.isMinInf()) {
                if (r2.isMinInf()) {
                    compFlags[3] = 0;
                    compFlags[2] = 0;
                    compFlags[1] = 0;
                    compFlags[0] = 0;
                } else {
                    compFlags[3] = 1;
                    compFlags[2] = 1;
                    compFlags[1] = 1;
                    compFlags[0] = 1;
                }
            } else if (r2.isMinNegInf()) {
                compFlags[3] = 1;
                compFlags[2] = 1;
                compFlags[1] = 1;
                compFlags[0] = 1;
            } else if (r2.isMinInf()) {
                compFlags[3] = -1;
                compFlags[2] = -1;
                compFlags[1] = -1;
                compFlags[0] = -1;
            } else {
                compFlags[2] = compFlags[3] = this.validFlag(((Comparable)r1.getMin()).compareTo(r2.getMin()));
                compFlags[1] = compFlags[3];
                compFlags[0] = compFlags[3];
            }
        } else if (r1.isPoint()) {
            if (r1.isMinNegInf()) {
                if (r2.isMinNegInf()) {
                    compFlags[0] = -1;
                    compFlags[1] = 0;
                    compFlags[2] = -1;
                    compFlags[3] = 0;
                } else {
                    compFlags[3] = -1;
                    compFlags[2] = -1;
                    compFlags[1] = -1;
                    compFlags[0] = -1;
                }
            } else if (r1.isMinInf()) {
                if (r2.isMaxInf()) {
                    compFlags[0] = 0;
                    compFlags[1] = 1;
                    compFlags[2] = 0;
                    compFlags[3] = 1;
                } else {
                    compFlags[3] = 1;
                    compFlags[2] = 1;
                    compFlags[1] = 1;
                    compFlags[0] = 1;
                }
            } else {
                int flag;
                if (r2.isMaxInf()) {
                    compFlags[2] = -1;
                    compFlags[0] = -1;
                } else {
                    flag = this.validFlag(((Comparable)r1.getMin()).compareTo(r2.getMax()));
                    if (flag == 0) {
                        if (r2.isMaxIncluded()) {
                            compFlags[2] = 0;
                            compFlags[0] = 0;
                        } else {
                            compFlags[2] = 1;
                            compFlags[0] = 1;
                        }
                    } else {
                        compFlags[0] = compFlags[2] = flag;
                    }
                }
                if (r2.isMinNegInf()) {
                    compFlags[3] = 1;
                    compFlags[1] = 1;
                } else {
                    flag = this.validFlag(((Comparable)r1.getMin()).compareTo(r2.getMin()));
                    if (flag == 0) {
                        if (r2.isMinIncluded()) {
                            compFlags[3] = 0;
                            compFlags[1] = 0;
                        } else {
                            compFlags[3] = -1;
                            compFlags[1] = -1;
                        }
                    } else {
                        compFlags[1] = compFlags[3] = flag;
                    }
                }
            }
        } else if (r2.isPoint()) {
            if (r2.isMinNegInf()) {
                if (r1.isMinNegInf()) {
                    compFlags[0] = 0;
                    compFlags[1] = 0;
                    compFlags[2] = 1;
                    compFlags[3] = 1;
                } else {
                    compFlags[3] = 1;
                    compFlags[2] = 1;
                    compFlags[1] = 1;
                    compFlags[0] = 1;
                }
            } else if (r2.isMinInf()) {
                if (r1.isMaxInf()) {
                    compFlags[0] = -1;
                    compFlags[1] = -1;
                    compFlags[2] = 0;
                    compFlags[3] = 0;
                } else {
                    compFlags[3] = -1;
                    compFlags[2] = -1;
                    compFlags[1] = -1;
                    compFlags[0] = -1;
                }
            } else {
                int flag;
                if (r1.isMinNegInf()) {
                    compFlags[1] = -1;
                    compFlags[0] = -1;
                } else {
                    flag = this.validFlag(((Comparable)r1.getMin()).compareTo(r2.getMin()));
                    if (flag == 0) {
                        if (r1.isMinIncluded()) {
                            compFlags[1] = 0;
                            compFlags[0] = 0;
                        } else {
                            compFlags[1] = 1;
                            compFlags[0] = 1;
                        }
                    } else {
                        compFlags[0] = compFlags[1] = flag;
                    }
                }
                if (r1.isMaxInf()) {
                    compFlags[3] = 1;
                    compFlags[2] = 1;
                } else {
                    flag = this.validFlag(((Comparable)r1.getMax()).compareTo(r2.getMin()));
                    if (flag == 0) {
                        if (r1.isMaxIncluded()) {
                            compFlags[3] = 0;
                            compFlags[2] = 0;
                        } else {
                            compFlags[3] = -1;
                            compFlags[2] = -1;
                        }
                    } else {
                        compFlags[2] = compFlags[3] = flag;
                    }
                }
            }
        }
        return Result.get(compFlags);
    }

    private int validFlag(int flag) {
        if (flag < 0) {
            return -1;
        }
        if (flag > 0) {
            return 1;
        }
        return 0;
    }

    public static enum Result {
        LLLL("<<<<", "is entirely less than"),
        LLLE("<<<=", "extends to min of"),
        LLLG("<<<>", "starts below and extends within"),
        LLEG("<<=>", "starts below and extends to max of"),
        LEGG("<=>>", "starts with and extends beyond"),
        LLEE("<<==", "starts below and has max at point location of"),
        EEGG("==>>", "extends from point location of"),
        LEEG("<==>", "is exactly equal to finite interval"),
        EEEE("====", "is exactly equal to point"),
        LLGG("<<>>", "strictly encloses"),
        LGLG("<><>", "is strictly enclosed by"),
        LGGG("<>>>", "starts within and extends beyond"),
        LGEG("<>=>", "starts within and extends to max of"),
        LELG("<=<>", "starts with and ends within"),
        EGEG("=>=>", "is a point at max of"),
        LELE("<=<=", "is a point at min of"),
        EGGG("=>>>", "extends from max of"),
        GGGG(">>>>", "is entirely greater than");

        private static final Map<String, Result> lookup;
        private String notation;
        private String desc;
        private int[] flags;

        private Result(String notation, String desc) {
            this.notation = notation;
            this.desc = desc;
            this.flags = new int[notation.length()];
            String symbols = "<=>";
            for (int i = 0; i < notation.length(); ++i) {
                this.flags[i] = "<=>".indexOf(notation.charAt(i)) - 1;
            }
        }

        public String getNotation() {
            return this.notation;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getAt(int pos) {
            return this.flags[pos];
        }

        public List<Result> match(int op, int pos) {
            return this.match(op, pos, EnumSet.allOf(Result.class));
        }

        public List<Result> match(int op, int pos, Collection<Result> typesToSearch) {
            if (op < -1 || op > 1) {
                throw new IllegalArgumentException("op must be one of LT, EQ or GT");
            }
            if (pos < 0 || pos >= 4) {
                throw new IllegalArgumentException("pos must be in the range [0, NOTATION_LENGTH)");
            }
            List<Result> types = CollectionFactory.list();
            for (Result t : typesToSearch) {
                if (t.flags[pos] != op) continue;
                types.add(t);
            }
            return types;
        }

        public static Result get(int[] compFlags) {
            char[] name = new char[4];
            block5: for (int i = 0; i < 4; ++i) {
                switch (compFlags[i]) {
                    case -1: {
                        name[i] = 76;
                        continue block5;
                    }
                    case 0: {
                        name[i] = 69;
                        continue block5;
                    }
                    case 1: {
                        name[i] = 71;
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException("compOps must only contain LT, EQ or GT");
                    }
                }
            }
            return lookup.get(new String(name));
        }

        static {
            lookup = CollectionFactory.map();
            for (Result t : EnumSet.allOf(Result.class)) {
                lookup.put(t.name(), t);
            }
        }
    }
}

