/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k;

import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;

public class ModuleSpec
implements Cloneable {
    public static final byte SPEC_TYPE_COMP = 0;
    public static final byte SPEC_TYPE_TILE = 1;
    public static final byte SPEC_TYPE_TILE_COMP = 2;
    public static final byte SPEC_DEF = 0;
    public static final byte SPEC_COMP_DEF = 1;
    public static final byte SPEC_TILE_DEF = 2;
    public static final byte SPEC_TILE_COMP = 3;
    protected int specType;
    protected int nTiles = 0;
    protected int nComp = 0;
    protected byte[][] specValType;
    protected Object def = null;
    protected Object[] compDef = null;
    protected Object[] tileDef = null;
    protected Hashtable tileCompVal;
    protected String specified;

    public ModuleSpec getCopy() {
        return (ModuleSpec)this.clone();
    }

    public ModuleSpec(int n, int n2, byte by) {
        this.nTiles = n;
        this.nComp = n2;
        this.specValType = new byte[n][n2];
        switch (by) {
            case 1: {
                this.specType = 1;
                break;
            }
            case 0: {
                this.specType = 0;
                break;
            }
            case 2: {
                this.specType = 2;
            }
        }
    }

    protected Object clone() {
        int n;
        ModuleSpec moduleSpec;
        try {
            moduleSpec = (ModuleSpec)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Error when cloning ModuleSpec instance");
        }
        moduleSpec.specValType = new byte[this.nTiles][this.nComp];
        for (n = 0; n < this.nTiles; ++n) {
            for (int i = 0; i < this.nComp; ++i) {
                moduleSpec.specValType[n][i] = this.specValType[n][i];
            }
        }
        if (this.tileDef != null) {
            moduleSpec.tileDef = new Object[this.nTiles];
            for (n = 0; n < this.nTiles; ++n) {
                moduleSpec.tileDef[n] = this.tileDef[n];
            }
        }
        if (this.tileCompVal != null) {
            moduleSpec.tileCompVal = new Hashtable();
            Enumeration enumeration = this.tileCompVal.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this.tileCompVal.get(string);
                moduleSpec.tileCompVal.put(string, v);
            }
        }
        return moduleSpec;
    }

    public void rotate90(Point point) {
        int n;
        int n2;
        int n3;
        byte[][] byArrayArray = new byte[this.nTiles][];
        Point point2 = new Point(point.y, point.x);
        for (int i = 0; i < point2.y; ++i) {
            for (n3 = 0; n3 < point2.x; ++n3) {
                n2 = n3;
                n = point2.y - i - 1;
                byArrayArray[n2 * point.x + n] = this.specValType[i * point2.x + n3];
            }
        }
        this.specValType = byArrayArray;
        if (this.tileDef != null) {
            Object[] objectArray = new Object[this.nTiles];
            for (n3 = 0; n3 < point2.y; ++n3) {
                for (int i = 0; i < point2.x; ++i) {
                    n2 = i;
                    n = point2.y - n3 - 1;
                    objectArray[n2 * point.x + n] = this.tileDef[n3 * point2.x + i];
                }
            }
            this.tileDef = objectArray;
        }
        if (this.tileCompVal != null && this.tileCompVal.size() > 0) {
            Hashtable hashtable = new Hashtable();
            Enumeration enumeration = this.tileCompVal.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this.tileCompVal.get(string);
                int n4 = string.indexOf(116);
                int n5 = string.indexOf(99);
                int n6 = new Integer(string.substring(n4 + 1, n5));
                int n7 = n6 % point2.x;
                int n8 = n6 / point2.x;
                n2 = n7;
                n = point2.y - n8 - 1;
                int n9 = n + n2 * point.x;
                hashtable.put("t" + n9 + string.substring(n5), v);
            }
            this.tileCompVal = hashtable;
        }
    }

    public void setDefault(Object object) {
        this.def = object;
    }

    public Object getDefault() {
        return this.def;
    }

    public void setCompDef(int n, Object object) {
        if (this.specType == 1) {
            String string = "Option whose value is '" + object + "' cannot be " + "specified for components as it is a 'tile only' specific " + "option";
            throw new Error(string);
        }
        if (this.compDef == null) {
            this.compDef = new Object[this.nComp];
        }
        for (int i = 0; i < this.nTiles; ++i) {
            if (this.specValType[i][n] >= 1) continue;
            this.specValType[i][n] = 1;
        }
        this.compDef[n] = object;
    }

    public Object getCompDef(int n) {
        if (this.specType == 1) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.compDef == null || this.compDef[n] == null) {
            return this.getDefault();
        }
        return this.compDef[n];
    }

    public void setTileDef(int n, Object object) {
        if (this.specType == 0) {
            String string = "Option whose value is '" + object + "' cannot be " + "specified for tiles as it is a 'component only' specific " + "option";
            throw new Error(string);
        }
        if (this.tileDef == null) {
            this.tileDef = new Object[this.nTiles];
        }
        for (int i = 0; i < this.nComp; ++i) {
            if (this.specValType[n][i] >= 2) continue;
            this.specValType[n][i] = 2;
        }
        this.tileDef[n] = object;
    }

    public Object getTileDef(int n) {
        if (this.specType == 0) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.tileDef == null || this.tileDef[n] == null) {
            return this.getDefault();
        }
        return this.tileDef[n];
    }

    public void setTileCompVal(int n, int n2, Object object) {
        if (this.specType != 2) {
            String string = "Option whose value is '" + object + "' cannot be " + "specified for ";
            switch (this.specType) {
                case 1: {
                    string = string + "components as it is a 'tile only' specific option";
                    break;
                }
                case 0: {
                    string = string + "tiles as it is a 'component only' specific option";
                }
            }
            throw new Error(string);
        }
        if (this.tileCompVal == null) {
            this.tileCompVal = new Hashtable();
        }
        this.specValType[n][n2] = 3;
        this.tileCompVal.put("t" + n + "c" + n2, object);
    }

    public Object getTileCompVal(int n, int n2) {
        if (this.specType != 2) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        return this.getSpec(n, n2);
    }

    protected Object getSpec(int n, int n2) {
        switch (this.specValType[n][n2]) {
            case 0: {
                return this.getDefault();
            }
            case 1: {
                return this.getCompDef(n2);
            }
            case 2: {
                return this.getTileDef(n);
            }
            case 3: {
                return this.tileCompVal.get("t" + n + "c" + n2);
            }
        }
        throw new IllegalArgumentException("Not recognized spec type");
    }

    public byte getSpecValType(int n, int n2) {
        return this.specValType[n][n2];
    }

    public boolean isCompSpecified(int n) {
        return this.compDef != null && this.compDef[n] != null;
    }

    public boolean isTileSpecified(int n) {
        return this.tileDef != null && this.tileDef[n] != null;
    }

    public boolean isTileCompSpecified(int n, int n2) {
        return this.tileCompVal != null && this.tileCompVal.get("t" + n + "c" + n2) != null;
    }

    public static final boolean[] parseIdx(String string, int n) {
        int n2;
        int n3 = string.length();
        char c = string.charAt(0);
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        boolean[] blArray = new boolean[n];
        for (int i = 1; i < n3; ++i) {
            c = string.charAt(i);
            if (Character.isDigit(c)) {
                if (n4 == -1) {
                    n4 = 0;
                }
                n4 = n4 * 10 + (c - 48);
                continue;
            }
            if (n4 == -1 || c != ',' && c != '-') {
                throw new IllegalArgumentException("Bad construction for parameter: " + string);
            }
            if (n4 < 0 || n4 >= n) {
                throw new IllegalArgumentException("Out of range index in parameter `" + string + "' : " + n4);
            }
            if (c == ',') {
                if (bl) {
                    for (n2 = n5 + 1; n2 < n4; ++n2) {
                        blArray[n2] = true;
                    }
                }
                bl = false;
            } else {
                bl = true;
            }
            blArray[n4] = true;
            n5 = n4;
            n4 = -1;
        }
        if (n4 < 0 || n4 >= n) {
            throw new IllegalArgumentException("Out of range index in parameter `" + string + "' : " + n4);
        }
        if (bl) {
            for (n2 = n5 + 1; n2 < n4; ++n2) {
                blArray[n2] = true;
            }
        }
        blArray[n4] = true;
        return blArray;
    }
}

